//=============================================================================
// HXDeusExTrainingMunitionsTrooperTrigger.
//=============================================================================
class HXDeusExTrainingMunitionsTrooperTrigger extends HXTrigger;

var Name FlagName;
var bool FlagValue;

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	local HXPlayerPawn PlayerPawn;

	Super.Touch( Other );

	if ( !IsRelevant(Other) )
		return;

	PlayerPawn = HXPlayerPawn(Other);
	if ( PlayerPawn!=None && RemoveAllInventory(PlayerPawn) && FlagName!='' )
		HXGameInfo(Level.Game).Steve.FlagBase.SetBool( FlagName, FlagValue );
}

// ----------------------------------------------------------------------------
// RemoveAllInventory()
// ----------------------------------------------------------------------------

function bool RemoveAllInventory( HXPlayerPawn Player )
{
	local Inventory item, nextItem, lastItem;
	local bool bRemovedSomething;

	if ( Player.Inventory!=None )
	{
		Item     = Player.Inventory;
		NextItem = Item.Inventory;
		LastItem = Item;

		do
		{
			if ( Item!=None && Item.bDisplayableInv || Item.IsA('Ammo') )
			{
				// Make sure everything is turned off
				if ( Item.IsA('HXWeapon') )
				{
					HXWeapon(Item).ScopeOff();
					HXWeapon(Item).LaserOff();
				}
				if ( Item.IsA('HXPickup') )
				{
					if ( HXPickup(Item).bActive )
						HXPickup(Item).Activate();
				}

   			if ( Item.IsA('HXChargedPickup') )
					Player.HXRemoveChargedDisplay( HXChargedPickup(Item) );

				Player.DeleteInventory( Item );
				Item.Destroy();
				bRemovedSomething = true;
			}
			Item = NextItem;

			if ( Item!=None )
				NextItem = Item.Inventory;
		}
		until ( Item==None || Item==LastItem );
		if ( Item==LastItem )
			Warn( "Circular inventory loop detected while removing all inventory for " $ Player );
	}

	return bRemovedSomething;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bTriggerOnceOnly=False
	TriggerType=TT_PlayerProximity
	CollisionRadius=96.0
	FlagName=MunitionsTrooperReady
	FlagValue=True
}
