//=============================================================================
// HXDirectionalTrigger.
//
// Notes:
//  * Maybe merge code into IsRelevant() instead.
//=============================================================================
class HXDirectionalTrigger extends HXTrigger;

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

singular function Touch( Actor Other )
{
	local Vector X, Y, Z;
	local float AngleCos;
	local bool bDoIt;

	// Should we even pay attention to this actor?
	if ( !IsRelevant(Other) )
		return;

	bDoIt = true;

	if ( Other!=None )
	{
		GetAxes( Rotation, X, Y, Z );
		AngleCos = (Location-Other.Location) dot X;

		// If we're on the wrong side of the trigger, then don't trigger it.
		if ( AngleCos>0.0 )
			bDoIt = false;
	}

	if ( bDoIt )
		Super.Touch( Other );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ReTriggerDelay=1.0
	bDirectional=True
}
