//=============================================================================
// HXBarkBarkNomNom.
//=============================================================================
class HXDog extends HXAnimal
	abstract;

var Sound DogBarkSounds[2];

var localized String BarkedWrongTree;

var float Time;

function PlayDogBark()
{
	if ( FRand()<0.5 )
		PlaySound( DogBarkSounds[0], SLOT_None );
	else
		PlaySound( DogBarkSounds[1], SLOT_None );
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	time += deltaTime;

	// check for random noises
	if (time > 1.0)
	{
		time = 0;
		if (FRand() < 0.05)
			PlayDogBark();
	}
}

function PlayTakingHit(EHitLocation hitPos)
{
	// nil
}

function PlayAttack()
{
	PlayAnimPivot('Attack');
}

function TweenToAttack(float tweentime)
{
	TweenAnimPivot('Attack', tweentime);
}

function PlayBarking()
{
	PlayAnimPivot('Bark');
}

// ----------------------------------------------------------------------------
// KillMessage()
// ----------------------------------------------------------------------------

function string KillMessage( Name DamageType, Pawn Other )
{
	return BarkedWrongTree;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	BarkedWrongTree=" barked up the wrong tree."
	bPlayDying=True
	MinHealth=2.0
	InitialAlliances(7)=(AllianceName=Cat,AllianceLevel=-1.0)
	InitialInventory(0)=(Inventory=Class'WeaponDogBite')
	BaseEyeHeight=12.5
	Alliance=Dog
	Buoyancy=97.0
	WalkingSpeed=0.2
	GroundSpeed=250.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=500.0
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	DrawType=DT_Mesh
}
