//=============================================================================
// Effects, the base class of all gratuitous special effects.
// 
// HX_NOTE: Added an override for Rotation replication.
//
// TODO:
//  * Move stuff to HXActor.
//=============================================================================
class HXEffects extends HXActor
	abstract
	native;

var float EffectsTime;  // Used for getting EffectsTimer() messages (for TrashGenerator, etc.)

var() Sound EffectSound1;
var() Sound EffectSound2;
var() bool bOnlyTriggerable;

var bool bReplicateRotation;

event EffectsTimer();

// ----------------------------------------------------------------------------
// Network replication overrides.
// ----------------------------------------------------------------------------
/*
replication
{
	// Additional replication of Rotation for DT_Sprite, etc.
	reliable if ( Role==ROLE_Authority && bReplicateRotation && ((DrawType!=DT_Mesh && DrawType!=DT_Brush && bNetInitial) || RemoteRole==ROLE_SimulatedProxy) )
		Rotation;
}
*/

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Effects OtherEffects;

	Super.Succeeds( Other );

	// Special Effects Init.
	OtherEffects = Effects(Other);
	if ( OtherEffects!=None )
	{
		// Effects.
		EffectSound1     = OtherEffects.EffectSound1;
		EffectSound2     = OtherEffects.EffectSound2;
		bOnlyTriggerable = OtherEffects.bOnlyTriggerable;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	DrawType=DT_None
	bGameRelevant=True
	CollisionRadius=0.0
	CollisionHeight=0.0
	bReplicateRotation=False
}
