//=============================================================================
// HXEllipseEffect.
//=============================================================================
class HXEllipseEffect extends HXEffects
	transient;

// LifeSpan is not replicated, so this is needed for the bNetTemporary pattern.
var float RemainingLifeSpan;

// -------------------------------------------------------------------------------
// Network replication.
// -------------------------------------------------------------------------------

replication
{
	// Server to client.
	reliable if ( Role==ROLE_Authority )
		RemainingLifeSpan;
}

// ----------------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	Super.PostNetBeginPlay();

	LifeSpan = RemainingLifeSpan;
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	RemainingLifeSpan = LifeSpan;
	ScaleGlow = 2.0 * (LifeSpan / Default.LifeSpan);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	NetPriority=4.000000
	bNetTemporary=True
	LifeSpan=1.000000
	RemainingLifeSpan=1.000000
	DrawType=DT_Mesh
	Style=STY_Translucent
	Mesh=LodMesh'DeusExItems.EllipseEffect'
	bUnlit=True
}
