//=============================================================================
// HXFadeViewTrigger.
//=============================================================================
class HXFadeViewTrigger extends HXTrigger;

var() color FadeColor;
var() float FadeTime;
var() float PostFadeTime;
var() bool bFadeDown;

//var DeusExPlayer player;
//var float time;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local FadeViewTrigger OtherFadeViewTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special FadeViewTrigger Init.
	OtherFadeViewTrigger = FadeViewTrigger(Other);
	if ( OtherFadeViewTrigger!=None )
	{
		FadeColor    = OtherFadeViewTrigger.FadeColor;
		FadeTime     = OtherFadeViewTrigger.FadeTime;
		PostFadeTime = OtherFadeViewTrigger.PostFadeTime;
		bFadeDown    = OtherFadeViewTrigger.bFadeDown;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	Super.Trigger( Other, Instigator );
	FadeView();
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

singular function Touch( Actor Other )
{
	if (!IsRelevant(Other))
		return;

	Super.Touch( Other );
	FadeView();
}

// ----------------------------------------------------------------------------
// FadeView()
// ----------------------------------------------------------------------------

function FadeView()
{
	Warn( Self @"triggered, but FadeViewTriggers are not supported in HX. FIX ME" );

	/*player = DeusExPlayer(GetPlayerPawn());
	if (player != None)
	{
		// can't have a negative or zero FadeTime
		if (FadeTime < 0.1)
			FadeTime = 0.1;

		// can't have a negative postFadeTime
		if (postFadeTime < 0.0)
			postFadeTime = 0.0;

		time = FadeTime + postFadeTime;
	}*/
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

/*function Tick(float deltaTime)
{
	local float alpha;
	local vector FadeTo;

	Super.Tick(deltaTime);

	if (player != None)
	{
		time -= deltaTime;
		if (time < 0.0)
			time = 0.0;

		alpha = FClamp(1.0 - ((time - postFadeTime) / FadeTime), 0.0, 1.0);
		FadeTo.X = float(FadeColor.R) / 255.0;
		FadeTo.Y = float(FadeColor.G) / 255.0;
		FadeTo.Z = float(FadeColor.B) / 255.0;
		if (bFadeDown)
		{
			alpha = -alpha;
			FadeTo.X = float(255 - FadeColor.R) / 255.0;
			FadeTo.Y = float(255 - FadeColor.G) / 255.0;
			FadeTo.Z = float(255 - FadeColor.B) / 255.0;
		}

		// Fade the view to the selected color
		player.InstantFog = alpha * FadeTo;
		player.InstantFlash = alpha;

		// after Fade, delay postFadeTime seconds
		if (time <= 0)
			Destroy();
	}
}*/

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FadeColor=(R=255,G=255,B=255)
	FadeTime=2.0
	bTriggerOnceOnly=True
	CollisionRadius=96.0
}
