//=============================================================================
// HXFaucet.
//=============================================================================
class HXFaucet extends HXDecoration;

var() bool bOpen;
var ParticleGenerator	WaterGen;

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
  // Server to client.
  reliable if ( Role==ROLE_Authority )
		bOpen;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Faucet OtherFaucet;

	// Call Super.
	Super.Succeeds( Other );

	// Special Faucet Init.
	OtherFaucet = Faucet(Other);
	if ( OtherFaucet!=None )
	{
		bOpen = OtherFaucet.bOpen;
	}
}

// ----------------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------------

simulated function Destroyed()
{
	if ( WaterGen!=None )
		WaterGen.DelayedDestroy();

	Super.Destroyed();
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	Super.Tick( DeltaTime );

	// If WaterGen is in wrong state, trigger it.
	if ( WaterGen!=None && bOpen!=WaterGen.bSpewing )
		WaterGen.Trigger( None, None );
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	Super.Frob(Frobber, frobWith);

	bOpen = !bOpen;

	if ( bOpen )
	{
		PlaySound( Sound'ValveOpen',,,, 256, 2.0 );
		PlayAnim( 'On' );

		// Extinguish the player if he frobbed this.
		if ( HXPlayerPawn(Frobber)!=None )
			if ( HXPlayerPawn(Frobber).bOnFire )
				HXPlayerPawn(Frobber).ExtinguishFire();
	}
	else
	{
		PlaySound( Sound'ValveClose',,,, 256, 2.0 );
		PlayAnim( 'Off' );
	}

	// Alert AI.
	Instigator = Pawn(Frobber);
	AISendEvent( 'LoudNoise', EAITYPE_Audio,, 384 );
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	if ( Role==ROLE_Authority )
	{
		SpawnGenerator();

		// Play the correct startup animation.
		// Note: This tweentime has caused problems for Valve in network
		//       before, but seems to work here.
		if ( bOpen )
			PlayAnim( 'On', 10.0, 0.001 );
		else
			PlayAnim( 'Off', 10.0, 0.001 );
	}
}

// ----------------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	Super.PostNetBeginPlay();

	SpawnGenerator();
}

// ----------------------------------------------------------------------------
// SpawnGenerator()
// ----------------------------------------------------------------------------

simulated function SpawnGenerator()
{
	local Vector Loc;

	if ( WaterGen==None )
	{
		// spawn a particle generator
		// rotate the spray offsets into object coordinate space
		Loc = vect(0,0,0);
		Loc.X += CollisionRadius * 0.9;
		Loc = Loc >> Rotation;
		Loc += Location;

		WaterGen = Spawn( Class'ParticleGenerator', Self,, Loc, Rotation-rot(12288,0,0) );

		if ( WaterGen!=None )
		{
			WaterGen.particleDrawScale = 0.05;
			WaterGen.checkTime = 0.05;
			WaterGen.frequency = 1.0;
			WaterGen.bGravity = True;
			WaterGen.bScale = False;
			WaterGen.bFade = True;
			WaterGen.ejectSpeed = 50.0;
			WaterGen.particleLifeSpan = 0.5;
			WaterGen.numPerSpawn = 5;
			WaterGen.bRandomEject = True;
			WaterGen.particleTexture = Texture'Effects.Generated.WtrDrpSmall';
			WaterGen.bAmbientSound = True;
			WaterGen.AmbientSound = Sound'Sink';
			WaterGen.SoundRadius = 16;
			WaterGen.bTriggered = True;
			WaterGen.bInitiallyOn = bOpen;
			WaterGen.SetBase(Self);

			// Let this not bother networking
			WaterGen.RemoteRole = ROLE_None;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	RemoteRole=ROLE_SimulatedProxy
	bInvincible=True
	ItemName="Faucet"
	bPushable=False
	Physics=PHYS_None
	Mesh=Faucet
	CollisionRadius=11.20
	//CollisionHeight=4.80
	CollisionHeight=4.05
	Mass=20.0
	Buoyancy=10.0
}
