//=============================================================================
// HXFireExtinguisher.
//=============================================================================
class HXFireExtinguisher extends HXDeusExPickup;

#exec OBJ LOAD FILE=Ambient

// ----------------------------------------------------------------------------
// state Activated.
// ----------------------------------------------------------------------------

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local HXHalonGasGenerator Gen;
		local Vector loc;
		local Rotator rot;

		Super.BeginState();

		//Log( Self $ ".BeginState() called." );

		// force-extinguish the player
		if ( HXPlayerPawn(Owner)!=None && HXPlayerPawn(Owner).bOnFire )
			HXPlayerPawn(Owner).ExtinguishFire();

		// spew halon gas
		Rot = Pawn(Owner).ViewRotation;
		Loc = Vector(rot) * Owner.CollisionRadius;
		Loc.Z += Owner.CollisionHeight * 0.9;
		Loc += Owner.Location;

		Gen = Spawn(class'HXHalonGasGenerator', None,, loc, rot);

		if ( Gen!=None )
		{
			//gen.ProjectileClass = class'HXHalonGas';
			Gen.SetBase(Owner);
			//Gen.LifeSpan = 3;
			//Gen.ejectSpeed = 300;
			//Gen.projectileLifeSpan = 1.5;
			//Gen.frequency = 0.9;
			//Gen.checkTime = 0.1;
			//Gen.bAmbientSound = True;
			//Gen.AmbientSound = sound'SteamVent2';
			//Gen.SoundVolume = 192;
			//Gen.SoundPitch = 32;

			Gen.RemoteRole = ROLE_None;
		}

		// blast for 3 seconds, then destroy
		//SetTimer(3.0, False);
		LifeSpan = 3.0;
	}
Begin:
}

// ----------------------------------------------------------------------------
// state DeActivated
// ----------------------------------------------------------------------------

state DeActivated
{
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bActivatable=True
	ItemName="Fire Extinguisher"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=FireExtinguisher
	PickupViewMesh=FireExtinguisher
	ThirdPersonMesh=FireExtinguisher
	LandSound=GlassDrop
	Icon=BeltIconFireExtinguisher
	LargeIcon=LargeIconFireExtinguisher
	LargeIconWidth=25
	LargeIconHeight=49
	Description="A chemical fire extinguisher."
	BeltDescription="FIRE EXT"
	Mesh=FireExtinguisher
	CollisionRadius=8.00
	//CollisionHeight=10.27
	CollisionHeight=9.52
	Mass=30.0
	Buoyancy=20.0
}
