//=============================================================================
// HXFirePlug.
//=============================================================================
class HXFirePlug extends HXOutdoorThings;

enum ESkinColor
{
	SC_Red,
	SC_Orange,
	SC_Blue,
	SC_Gray
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Red:    Skin = Texture'FirePlugTex1'; break;
			case SC_Orange: Skin = Texture'FirePlugTex2'; break;
			case SC_Blue:   Skin = Texture'FirePlugTex3'; break;
			case SC_Gray:   Skin = Texture'FirePlugTex4'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local FirePlug OtherFirePlug;

	// Call Super.
	Super.Succeeds( Other );

	// Special FirePlug Init.
	OtherFirePlug = FirePlug(Other);
	if ( OtherFirePlug!=None )
	{
		SetPropertyText( "SkinColor", OtherFirePlug.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FragType=MetalFragment
	ItemName="Fire Plug"
	Mesh=FirePlug
	Skin=FirePlugTex1
	CollisionRadius=8.00
	//CollisionHeight=16.50
	CollisionHeight=15.75
	Mass=50.0
	Buoyancy=30.0
}
