//=============================================================================
// HXFishGenerator.
//=============================================================================
class HXFishGenerator extends HXPawnGenerator;

// ----------------------------------------------------------------------------
// GenerateRandomVelocity()
// ----------------------------------------------------------------------------

function vector GenerateRandomVelocity()
{
	local vector newVector;
	local float  magnitude;

	magnitude = VSize(SumVelocities);
	if (magnitude < 0.01)
		magnitude = 0.01;
	newVector = Vector(Rand(32768)*2*rot(0,1,0))*magnitude*1.1;

	return newVector;
}

// ----------------------------------------------------------------------------
// GenerateCoastPeriod()
// ----------------------------------------------------------------------------

function float GenerateCoastPeriod()
{
	return (FRand()*3.0+3.0);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	PawnClasses(0)=(Count=10,PawnClass=Class'HXFish')
	Alliance=Fish
	PawnHomeExtent=400.0
	ActiveArea=1200.0
	Radius=70.0
	MaxCount=10
	bPawnsTransient=True
	Focus=0.6
}
