//=============================================================================
// HXFishes.
//=============================================================================
class HXFishes extends HXAnimal
	abstract;

var float LeaderTimer;
var float ForwardTimer;
var float BumpTimer;
var float AbortTimer;
var float BreatheTimer;

var() bool bFlock;
var() bool bStayHorizontal;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Fishes OtherFishes;

	// Call Super.
	Super.Succeeds( Other );

	// Special Fishes Init.
	OtherFishes = Fishes(Other);
	if ( OtherFishes!=None )
	{
		bFlock          = OtherFishes.bFlock;
		bStayHorizontal = OtherFishes.bStayHorizontal;
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	if ( bDeleteMe || IsInRelevant() )
		return;

	ResetLeaderTimer();

	ForwardTimer = -1;
	BumpTimer    =  0;
	AbortTimer   = -1;
	BreatheTimer =  0;
}

function ResetLeaderTimer()
{
	LeaderTimer = FRand()*10.0+5;
}

function ResetForwardTimer()
{
	ForwardTimer = FRand()*10.0+2;
}

function bool IsNearHome(vector position)
{
	local bool          bNear;
	local HXPawnGenerator genOwner;

	bNear = true;
	if (bUseHome)
	{
		genOwner = HXPawnGenerator(Owner);
		if (genOwner == None)
		{
			if (VSize(HomeLoc-((position-Location)+genOwner.FlockCenter)) > HomeExtent)
				bNear = false;
		}
		else
		{
			if (VSize(HomeLoc-position) > HomeExtent)
				bNear = false;
		}
	}

	return bNear;
}


function ReactToInjury(Pawn instigatedBy, Name damageType, EHitLocation hitPos) {}

state Wandering
{
	event HitWall(vector HitNormal, actor HitWall)
	{
		local rotator dir;
		local float   elasticity;
		local float   minVel, maxHVel;
		local vector  tempVect;

		if (Physics == PHYS_Swimming)
		{
			if (BumpTimer > 0)
				return;
			BumpTimer = 0.5;

			if (bStayHorizontal)
				HitNormal = Normal(HitNormal*vect(1,1,0));
			elasticity = 1.0;
			Velocity = elasticity*((Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity);
			dir = Rotator(Velocity);
			if (bStayHorizontal)
				dir.Pitch = 0;
			SetRotation(dir);
			DesiredRotation = dir;
			Acceleration = Vector(dir)*AccelRate;
		}
		else
		{
			elasticity = 0.3;
			Velocity = elasticity*((Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity);
			minVel  = 100;
			maxHVel = 20;
			Velocity += VRand()*5 * vect(1,1,0);
			tempVect = Velocity * vect(1,1,0);
			if (VSize(tempVect) > maxHVel)
				Velocity = Normal(tempVect)*maxHVel + vect(0,0,1)*Velocity.Z;
			if (VSize(Velocity) < minVel)
				Velocity = Normal(Velocity)*minVel*(FRand()*0.2+1);
			dir = Rotator(VRand());
			SetRotation(dir);
			DesiredRotation = dir;
		}
		ForwardTimer = -1;
		GotoState('Wandering', 'Moving');
	}

	function FootZoneChange(ZoneInfo newZone)
	{
		local Rotator newRotation;
		if (newZone.bWaterZone && !FootRegion.Zone.bWaterZone)
		{
			if (!bStayHorizontal)
			{
				newRotation = Rotation;
				newRotation.Pitch = -1500;
				SetRotation(newRotation);
				DesiredRotation = newRotation;
				LeaderTimer = 1.0;
				GotoState('Wandering', 'Moving');
			}
		}
		Super.ZoneChange(newZone);
	}

	function Tick(float deltatime)
	{
		Super.Tick(deltatime);
		LeaderTimer  -= deltaTime;
		ForwardTimer -= deltaTime;
		BumpTimer    -= deltaTime;
		if (LeaderTimer < -2.0)
			ResetLeaderTimer();
		if (BumpTimer < 0)
			BumpTimer = 0;
		if (AbortTimer >= 0)
			AbortTimer += deltaTime;
		if (AbortTimer > 8.0)
		{
			AbortTimer = -1;
			GotoState('Wandering', 'Moving');
		}
		if (Region.Zone.bWaterZone)
			BreatheTimer = 0;
		else
		{
			BreatheTimer += deltaTime;
			if (BreatheTimer > 8)
			{
				TakeDamage(5, None, Location, vect(0,0,0), 'Drowned');
				BreatheTimer = 6;
			}
		}
	}

	function vector PickDirection(bool bForward)
	{
		local Actor         nearbyActor;
		local HXFishes        nearbyFish;
		local HXPawnGenerator genOwner;
		local vector        cumVector;
		local rotator       rot;
		local float         dist;
		local vector        centerVector;

		if (bForward || IsNearHome(Location))
			cumVector = Velocity;
		else
			cumVector = (homeLoc - Location)*20;
		if ((LeaderTimer > 0) && !bForward && bFlock)
		{
			genOwner = HXPawnGenerator(Owner);
			if (genOwner == None)
			{
				foreach RadiusActors(Class, nearbyActor, 300)
				{
					nearbyFish = HXFishes(nearbyActor);
					if ((nearbyFish != None) && (nearbyFish != self) && nearbyFish.bFlock &&
					    (HXPawnGenerator(nearbyFish.Owner) == None))
						cumVector += nearbyFish.Velocity;
				}
			}
			else
			{
				cumVector += genOwner.SumVelocities - Velocity;
				centerVector = (genOwner.FlockCenter - Location);
				dist = VSize(centerVector);
				if ((dist > genOwner.Radius) && (dist < genOwner.Radius*4))
					cumVector += centerVector*2;
			}
		}
		if (cumVector == vect(0,0,0))
			cumVector = Vector(Rotation);
		rot = Rotator(cumVector);
		if (bStayHorizontal)
			rot.Pitch = 0;
		if (!bForward)
		{
			if ((LeaderTimer > 1.2) && bFlock)
			{
				rot.Yaw += Rand(8192)-4096;
				if (!bStayHorizontal)
					rot.Pitch += Rand(3000)-1500;
			}
			return vector(rot)*200+Location;
		}
		else
			return vector(rot)*50+Location;
	}

	function BeginState()
	{
		Super.BeginState();
		BlockReactions();
		AbortTimer = -1;
	}

	function EndState()
	{
		Super.EndState();
		bBounce = False;
	}

Begin:
	bBounce = True;
	destPoint = None;
	MoveTo(Location+Vector(Rotation)*(CollisionRadius+5), 1);

Init:
	bAcceptBump = false;
	TweenToWalking(0.15);
	WaitForLanding();
	FinishAnim();

Wander:
	PlayWalking();

Moving:
	AbortTimer = 0;
	if (ForwardTimer < 0)
	{
		MoveTo(PickDirection(true), 1);
		ResetForwardTimer();
	}
	else
		TurnTo(PickDirection(false));
	AbortTimer = -1;
	Sleep(0.0);
	Goto('Moving');

ContinueWander:
ContinueFromDoor:
	PlayWalking();
	Goto('Wander');
}


function PlayWalking()
{
	LoopAnimPivot('Swim');
}
function TweenToWalking(float tweentime)
{
	TweenAnimPivot('Swim', tweentime);
}


// Approximately five million stubbed out functions...
function PlayRunningAndFiring() {}
function TweenToShoot(float tweentime) {}
function PlayShoot() {}
function TweenToAttack(float tweentime) {}
function PlayAttack() {}
function PlayPanicRunning() {}
function PlaySittingDown() {}
function PlaySitting() {}
function PlayStandingUp() {}
function PlayRubbingEyesStart() {}
function PlayRubbingEyes() {}
function PlayRubbingEyesEnd() {}
function PlayStunned() {}
function PlayFalling() {}
function PlayLanded(float impactVel) {}
function PlayDuck() {}
function PlayRising() {}
function PlayCrawling() {}
function PlayPushing() {}
function PlayFiring() {}
function PlayTakingHit(EHitLocation hitPos) {}

function PlayTurning() {}
function TweenToRunning(float tweentime) {}
function PlayRunning() {}
function TweenToWaiting(float tweentime) {}
simulated function PlayWaiting() {}
function TweenToSwimming(float tweentime) {}
function PlaySwimming() {}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	AttitudeToPlayer=ATTITUDE_Ignore
	bFlock=True
	WalkingSpeed=1.0
	bHasShadow=False
	bHighlight=False
	bSpawnBubbles=False
	bCanWalk=False
	bCanSwim=True
	GroundSpeed=100.0
	AirSpeed=144.0
	AccelRate=500.0
	MaxStepHeight=1.0
	MinHitWall=0.0
	BaseEyeHeight=1.0
	UnderWaterTime=99999.0
	Physics=PHYS_Swimming
	DrawType=DT_Mesh
	bBlockActors=False
	bBlockPlayers=False
	bBounce=True
	Mass=1.0
	Buoyancy=1.0
	RotationRate=(Pitch=6000,Yaw=25000)
	BindName="Fishes"
}
