//=============================================================================
// HXFlagPole.
//=============================================================================
class HXFlagPole extends HXDecoration;

enum ESkinColor
{
	SC_China,
	SC_France,
	SC_President,
	SC_UNATCO,
	SC_USA
};

var() travel ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		SetSkin();
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local FlagPole OtherFlagPole;

	// Call Super.
	Super.Succeeds( Other );

	// Special FlagPole Init.
	OtherFlagPole = FlagPole(Other);
	if ( OtherFlagPole!=None )
	{
		SetPropertyText( "SkinColor", OtherFlagPole.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------------

function TravelPostAccept()
{
	Super.TravelPostAccept();

	SetSkin();
}

// ----------------------------------------------------------------------------
// SetSkin()
// ----------------------------------------------------------------------------

function SetSkin()
{
	switch ( SkinColor )
	{
		case SC_China:
			Skin = Texture'FlagPoleTex1';
			break;
		case SC_France:
			Skin = Texture'FlagPoleTex2';
			break;
		case SC_President:
			Skin = Texture'FlagPoleTex3';
			break;
		case SC_UNATCO:
			Skin = Texture'FlagPoleTex4';
			break;
		case SC_USA:
			Skin = Texture'FlagPoleTex5';
			break;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FragType=WoodFragment
	ItemName="Flag Pole"
	Mesh=FlagPole
	Skin=FlagPoleTex5
	CollisionRadius=17.00
	//CollisionHeight=56.39
	CollisionHeight=54.64
	Mass=40.0
	Buoyancy=30.0
	bFlammable=True
}
