//=============================================================================
// HXFlagReplicationInfo.
//=============================================================================
class HXFlagReplicationInfo extends ReplicationInfo
	native
	noexport;

// If you change those values, make sure the cpp code matches!
struct FlagCollection
{
	var int FlagHashes[16];
	var int FlagValues;
};

var int FlagCollections0[9];
var int FlagCollections1[9];
var int FlagCollections2[9];
var int FlagCollections3[9];
var int FlagCollections4[9];
var int FlagCollections5[9];
var int FlagCollections6[9];
var int FlagCollections7[9];

var int FlagCollections8[9];
var int FlagCollections9[9];
var int FlagCollections10[9];
var int FlagCollections11[9];
var int FlagCollections12[9];
var int FlagCollections13[9];
var int FlagCollections14[9];
var int FlagCollections15[9];

var FlagCollection ClientFlagCollections[16];

// CPP optimized
native(3410) final function bool GetBoolFlagCPP( Name FlagName, optional bool bSkipClientFlags );
native(3411) final function bool SetBoolFlagByStringCPP( String FlagName, int Value );
native(3412) final function bool SetClientBoolFlagByStringCPP( String FlagName, int Value );

// ----------------------------------------------------------------------
// replication
// ----------------------------------------------------------------------

replication
{
	reliable if ( Role==ROLE_Authority )		
		FlagCollections0, FlagCollections1, FlagCollections2, FlagCollections3,
		FlagCollections4, FlagCollections5, FlagCollections6, FlagCollections7;

	reliable if ( Role==ROLE_Authority )		
		FlagCollections8, FlagCollections9, FlagCollections10, FlagCollections11,
		FlagCollections12, FlagCollections13, FlagCollections14, FlagCollections15;
}

// ----------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------

//simulated function PostNetBeginPlay()
//{
	//local int i;

	//Super.PostNetBeginPlay();

	//Log( Self $ ".PostNetBeginPlay() called." );
//}

// ----------------------------------------------------------------------
// SetBoolFlag()
// ----------------------------------------------------------------------

function bool SetBoolFlag( Name FlagName, coerce int Value )
{
	local bool b;

	b = SetBoolFlagByString( FlagName $ "", Value );

	// TODO Verify
	
	return b;
}

// ----------------------------------------------------------------------
// SetBoolFlagByString()
// ----------------------------------------------------------------------

function bool SetBoolFlagByString( String FlagName, coerce int Value )
{
	return  SetBoolFlagByStringCPP( FlagName, Value );
/*
	local int h;
	local int i, j;
	local bool OldValue, NewValue;

	h = Hash( FlagName );

	Log( Self $ ".SetBoolFlag( " $ FlagName $ ", " $ Value $ " ) Hash is " $ h );

	NewValue = Value != 0;

	//
	// check if flag was set
	//
	for ( i = 0; i < ArrayCount( FlagCollections ); i++ )
	{
		for ( j = 0; j < ArrayCount( FlagCollections[i].FlagHashes ); j++ )
		{
			if ( FlagCollections[i].FlagHashes[j] == h )
			{
				OldValue = ( FlagCollections[i].FlagValues & ( 1 << j )) != 0;

				if ( OldValue == NewValue )
				{
					Log( Self $ ".SetBoolFlagByString( " $ FlagName $ ", " $ Value $ " ) found at FlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Keeping OldValue = " $ OldValue $ " NewValue = " $ NewValue );
					return true;
				}
				if ( !OldValue && NewValue )
				{
					// Set flag
					Log( Self $ ".SetBoolFlagByString( " $ FlagName $ ", " $ Value $ " ) found at FlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Updating OldValue = " $ OldValue $ " NewValue = " $ NewValue );

					FlagCollections[i].FlagValues = FlagCollections[i].FlagValues | ( 1 << j );

					// Network hints
					return true;
				}
				else // ( OldValue && !NewValue )
				{
					// Clear Flag
					Log( Self $ ".SetBoolFlagByString( " $ FlagName $ ", " $ Value $ " ) found at FlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Updating OldValue = " $ OldValue $ " NewValue = " $ NewValue );

					FlagCollections[i].FlagValues = FlagCollections[i].FlagValues & ( ~( 1 << j ) );
					return true;
				}
			}
		}
	}

	//
	// find an empty slot
	//
	for ( i = 0; i < ArrayCount( FlagCollections ); i++ )
	{
		for ( j = 0; j < ArrayCount( FlagCollections[i].FlagHashes ); j++ )
		{
			if ( FlagCollections[i].FlagHashes[j] == 0 )
			{
				FlagCollections[i].FlagHashes[j] = h;

				if ( NewValue )
				{
					FlagCollections[i].FlagValues = FlagCollections[i].FlagValues | ( 1 << j );
				}
				else
				{
					FlagCollections[i].FlagValues = FlagCollections[i].FlagValues & ( ~( 1 << j ) );
				}

				return true;
			}
		}
	}

	// FAIL :(
	Log( "!!!!! ERROR: NO EMPTY FLAG SLOT IN FLAGREPLICATIONINFO !!!!! REPORT THIS AS A BUG !!!!!" );

	return false;
*/
}


// ----------------------------------------------------------------------
// SetClientBoolFlag()
// ----------------------------------------------------------------------

function bool SetClientBoolFlag( Name FlagName, coerce int Value )
{
	local bool b;

	b = SetClientBoolFlagByString( FlagName $ "", Value );

	// TODO Verify
	
	return b;
}

// ----------------------------------------------------------------------
// SetClientBoolFlagByString()
// ----------------------------------------------------------------------

function bool SetClientBoolFlagByString( String FlagName, coerce int Value )
{
	return SetClientBoolFlagByStringCPP( FlagName, Value );
/*
	local int h;
	local int i, j;
	local bool OldValue, NewValue;

	h = class'HXActor'.static.Strihash( FlagName );

	Log( Self $ ".SetClientBoolFlagByString( " $ FlagName $ ", " $ Value $ " ) Hash is " $ h );

	NewValue = Value != 0;

	//
	// check if flag was set
	//
	for ( i = 0; i < ArrayCount( ClientFlagCollections ); i++ )
	{
		for ( j = 0; j < ArrayCount( ClientFlagCollections[i].FlagHashes ); j++ )
		{
			if ( ClientFlagCollections[i].FlagHashes[j] == h )
			{
				OldValue = ( ClientFlagCollections[i].FlagValues & ( 1 << j )) != 0;

				if ( OldValue == NewValue )
				{
					Log( Self $ ".SetBoolFlagByString( " $ FlagName $ ", " $ Value $ " ) found at ClientFlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Keeping OldValue = " $ OldValue $ " NewValue = " $ NewValue );
					return true;
				}
				if ( !OldValue && NewValue )
				{
					// Set flag
					Log( Self $ ".SetBoolFlagByString( " $ FlagName $ ", " $ Value $ " ) found at ClientFlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Updating OldValue = " $ OldValue $ " NewValue = " $ NewValue );

					ClientFlagCollections[i].FlagValues = ClientFlagCollections[i].FlagValues | ( 1 << j );
					return true;
				}
				else // ( OldValue && !NewValue )
				{
					// Clear Flag
					Log( Self $ ".SetBoolFlagByString( " $ FlagName $ ", " $ Value $ " ) found at ClientFlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Updating OldValue = " $ OldValue $ " NewValue = " $ NewValue );

					ClientFlagCollections[i].FlagValues = ClientFlagCollections[i].FlagValues & ( ~( 1 << j ) );
					return true;
				}
			}
		}
	}

	//
	// find an empty slot
	//
	for ( i = 0; i < ArrayCount( ClientFlagCollections ); i++ )
	{
		for ( j = 0; j < ArrayCount( ClientFlagCollections[i].FlagHashes ); j++ )
		{
			if ( ClientFlagCollections[i].FlagHashes[j] == 0 )
			{
				ClientFlagCollections[i].FlagHashes[j] = h;

				if ( NewValue )
				{
					ClientFlagCollections[i].FlagValues = ClientFlagCollections[i].FlagValues | ( 1 << j );
				}
				else
				{
					ClientFlagCollections[i].FlagValues = ClientFlagCollections[i].FlagValues & ( ~( 1 << j ) );
				}

				return true;
			}
		}
	}

	Log( "!!!!! ERROR: NO EMPTY FLAG SLOT IN (CLIENT) FLAGREPLICATIONINFO !!!!! REPORT THIS AS A BUG !!!!!" );

	return false;
*/
}


// ----------------------------------------------------------------------
// GetBoolFlag()
// ----------------------------------------------------------------------

simulated function bool GetBoolFlag( Name FlagName, optional bool bSkipClientFlags )
{
	return GetBoolFlagCPP( FlagName, bSkipClientFlags );

/*
	local int i, j, h;
	local bool Value;
	local int NonEmpty;

	h = Hash( FlagName $ "" );

	Log( Self $ ".GetBoolFlag( " $ FlagName $ " ) called. Hash is " $ h );

	NonEmpty = 0;

	// Prefer server flags collection
	for ( i = 0; i < ArrayCount( FlagCollections ); i++ )
	{
		for ( j = 0; j < ArrayCount( FlagCollections[i].FlagHashes ); j++ )
		{
			if ( FlagCollections[i].FlagHashes[j] != 0 )
				NonEmpty++;

			if ( FlagCollections[i].FlagHashes[j] == h )
			{
				Value = ( FlagCollections[i].FlagValues & ( 1 << j ) ) != 0;
				Log( Self $ ".GetBoolFlag( " $ FlagName $ " ) found at FlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Value = " $ Value );
				return Value;
			}
		}
	}

	if ( !bSkipClientFlags )
	{
		// Check client flags collection
		for ( i = 0; i < ArrayCount( ClientFlagCollections ); i++ )
		{
			for ( j = 0; j < ArrayCount( ClientFlagCollections[i].FlagHashes ); j++ )
			{
				if ( ClientFlagCollections[i].FlagHashes[j] != 0 )
					NonEmpty++;

				if ( ClientFlagCollections[i].FlagHashes[j] == h )
				{
					Value = ( ClientFlagCollections[i].FlagValues & ( 1 << j ) ) != 0;
					Log( Self $ ".GetBoolFlag( " $ FlagName $ " ) found at ClientFlagCollections[" $ i $ "].FlagHashes[" $ j $ "] Value = " $ Value );
					return Value;
				}
			}
		}
	}
	// i hope this is the right behaviour
	Log( Self $ ".GetBoolFlag( " $ FlagName $ " ) Flag not found, returning False. NonEmpty = " $ NonEmpty );

	return false;
*/
}

// ----------------------------------------------------------------------------
// PruneCurrent()
//
// Called before current map progress is saved just before switching level.
// Out parameter can be used to flag or unflag actor as transient.
//
// Be aware that this can break linked lists such as Level.PawnList.
// ----------------------------------------------------------------------------

simulated event PruneCurrent( out byte bTransient )
{
	bTransient = 1;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	RemoteRole=ROLE_SimulatedProxy
	NetUpdateFrequency=100.000000
	NetPriority=2.000000
}
