//=============================================================================
// HXFlagTrigger.
//=============================================================================
class HXFlagTrigger extends HXTrigger;

var() Name FlagName;
var() bool FlagValue;
var() bool bSetFlag;
var() bool bTrigger;
var() bool bWhileStandingOnly;
var() int  FlagExpiration;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local FlagTrigger OtherFlagTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special FlagTrigger Init.
	OtherFlagTrigger = FlagTrigger(Other);
	if ( OtherFlagTrigger!=None )
	{
		FlagName           = OtherFlagTrigger.FlagName;
		FlagValue          = OtherFlagTrigger.FlagValue;
		bSetFlag           = OtherFlagTrigger.bSetFlag;
		bTrigger           = OtherFlagTrigger.bTrigger;
		bWhileStandingOnly = OtherFlagTrigger.bWhileStandingOnly;
		FlagExpiration     = OtherFlagTrigger.FlagExpiration;
	}
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	if ( !IsRelevant(Other) )
		return;

	if ( bSetFlag )
	{
		if (FlagExpiration == -1)
			Game.Steve.FlagBase.SetBool( FlagName, FlagValue );
		else
			Game.Steve.FlagBase.SetBool( FlagName, FlagValue,, FlagExpiration );

		Game.FlagReplicationInfo.SetBoolFlag( FlagName, int(FlagValue) );
	}

	if ( bTrigger )
		if ( Game.Steve.FlagBase.GetBool(FlagName)==FlagValue )
			Super.Touch(Other);
}

// ----------------------------------------------------------------------------
// UnTouch()
// ----------------------------------------------------------------------------

function UnTouch( Actor Other )
{
	if ( !bWhileStandingOnly )
		return;

	if ( !IsRelevant(Other) )
		return;

	if ( bTrigger )
		if ( Game.Steve.FlagBase.GetBool(FlagName)==FlagValue )
			Super.UnTouch( Other );

	if ( bSetFlag )
	{
		if ( FlagExpiration==-1 )
			Game.Steve.FlagBase.SetBool( FlagName, !FlagValue );
		else
			Game.Steve.FlagBase.SetBool( FlagName, !FlagValue,, FlagExpiration );

		Game.FlagReplicationInfo.SetBoolFlag( FlagName, int(!FlagValue) );
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	local Actor A;

	if ( bSetFlag )
	{
		if ( FlagExpiration==-1 )
			Game.Steve.FlagBase.SetBool( FlagName, FlagValue );
		else
			Game.Steve.FlagBase.SetBool( FlagName, FlagValue,, FlagExpiration );

		Game.FlagReplicationInfo.SetBoolFlag( FlagName, int(FlagValue) );
	}

	if ( bTrigger )
	{
		if ( Game.Steve.FlagBase.GetBool(FlagName)==FlagValue )
		{
			if ( Event!='' )
			{
				foreach AllActors( class 'Actor', A, Event )
				{
					// Now called with Other instead of GetPlayerPawn().
					//A.Trigger( Player, Instigator );
					A.Trigger( Other, Instigator );

					Log( Self $ ".Trigger(): called " $ A $ ".Trigger( " $ Other $", "$ Instigator $ " ) (check for bugs)" );
				}
			}

			Super.Trigger( Other, Instigator );
		}
	}
}

// ----------------------------------------------------------------------------
// UnTrigger()
// ----------------------------------------------------------------------------

function UnTrigger( Actor Other, Pawn Instigator )
{
	local Actor A;

	// Does it really make sense here? --han
	if ( !bWhileStandingOnly )
		return;

	if ( bTrigger )
	{
		if ( Game.Steve.FlagBase.GetBool(FlagName)==FlagValue )
		{
			if ( Event!='' )
			{
				foreach AllActors(class 'Actor', A, Event)
				{
					// Now called with Other instead of GetPlayerPawn().
					//A.Trigger( Player, Instigator );
					A.UnTrigger( Other, Instigator );

					Log( Self $ ".UnTrigger(): called" $ A $ ".UnTrigger( " $ Other $", "$ Instigator $ " ) (check for bugs)" );
				}
			}

			Super.UnTrigger(Other, Instigator);
		}
	}

	if ( bSetFlag )
	{
		if ( FlagExpiration==-1 )
			Game.Steve.FlagBase.SetBool(FlagName, !FlagValue );
		else
			Game.Steve.FlagBase.SetBool(FlagName, !FlagValue,, FlagExpiration );

		Game.FlagReplicationInfo.SetBoolFlag( FlagName, int(!FlagValue) );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FlagValue=True
	bSetFlag=True
	FlagExpiration=-1
	bTriggerOnceOnly=True
	CollisionRadius=96.0
}
