//=============================================================================
// HXFlare.
//=============================================================================
class HXFlare extends HXInstantUsePickup;

// ----------------------------------------------------------------------------
// InstantUse()
// ----------------------------------------------------------------------------

function InstantUse( Pawn OwnerPawn, Actor FrobTarget )
{
	local HXFlareProjectile FlareProjectile;
	local Vector X, Y, Z, DropVect;
	local Pawn P;

	// Create a FlareProjectile and toss it away.
	GetAxes( OwnerPawn.ViewRotation, X, Y, Z );
	DropVect = OwnerPawn.Location + 0.8 * OwnerPawn.CollisionRadius * X;
	DropVect.Z += OwnerPawn.BaseEyeHeight;

	FlareProjectile = Spawn( class'HXFlareProjectile',,,DropVect );
	if ( FlareProjectile!=None )
	{
		FlareProjectile.Velocity = Vector(OwnerPawn.ViewRotation) * 500.0 + vect(0,0,220);
		FlareProjectile.RotationRate = RotRand( false );

		// Increase our collision height so we light up the ground better.
		//SetCollisionSize(CollisionRadius, CollisionHeight*2);
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	M_Activated=""
	MsgActivated="You lit a flare"
	MsgTooMany="You can't carry any more flares"
	MaxCopies=50
	bCanHaveMultipleCopies=True
	bActivatable=True
	ItemName="Flare"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=Flare
	PickupViewMesh=Flare
	ThirdPersonMesh=Flare
	Icon=BeltIconFlare
	LargeIcon=LargeIconFlare
	LargeIconWidth=42
	LargeIconHeight=43
	Description="A flare."
	BeltDescription="FLARE"
	Mesh=Flare
	CollisionRadius=6.20
	//CollisionHeight=1.20
	CollisionHeight=0.45
	Mass=2.0
	Buoyancy=1.0
}
