//=============================================================================
// HXFlareProjectile.
//=============================================================================
class HXFlareProjectile extends HXProjectile;

var() localized String ExpireMessage; 

var HXFlareParticleGenerator SmokeGen;

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated function Spawned()
{
	Super.Spawned();

	if ( Level.NetMode!=NM_Client )
	{
		// SmokeGen will die down after about 30 seconds.
		SmokeGen = Spawn(class'HXFlareParticleGenerator', Self,, Location, rot(16384,0,0));
		if ( SmokeGen!=None )
		{
			SmokeGen.SetBase( Self );
			SmokeGen.LifeSpan = class'HXActor'.static.TPDFShape( FRand(), 25.0, 30.0, 35.0 );

			SetTimer( SmokeGen.LifeSpan, false );
		}
		else
		{
			SetTimer( 30.0, false );
		}

		LifeSpan = class'HXActor'.static.TPDFShape( FRand(), 60.0, 90.0, 120 );
	}
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

function Timer()
{
	Extinguish();
}

// ----------------------------------------------------------------------------
// Extinguish()
// ----------------------------------------------------------------------------

function Extinguish()
{
	bUnlit       = false;
	LightType    = LT_None;
	AmbientSound = None;

	// Darken a bit.
	ScaleGlow    = 0.5;

	if ( SmokeGen!=None )
		SmokeGen.DelayedDestroy();
}

// ----------------------------------------------------------------------------
// auto state Pickup.
// ----------------------------------------------------------------------------

auto state Flare
{
	function ZoneChange( ZoneInfo InZone )
	{
		// I'm quite sure those keep on burning in water, but i would need a burning bubbles textures. --han
		if ( InZone.bWaterZone )
			Extinguish();
	}
}

// Stub out most of Projectile events.
function Tick( float DeltaTime );
function Touch( Actor Other );
function HitWall( Vector HitNormal, Actor Wall );

// ----------------------------------------------------------------------------
// Frob()
//
// Don't frob with us!
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	if ( Frobber.bIsPawn )
		Pawn(Frobber).ClientMessage( ExpireMessage );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ExpireMessage="It's already been used"
	ItemName="Used Flare"
	bHighlight=True
	Mesh=Flare
	AmbientSound=Flare
	SoundRadius=16
	SoundVolume=96
	CollisionRadius=6.20
	//CollisionHeight=1.20
	// Increase our collision height so we light up the ground better.
	//CollisionHeight=0.45
	CollisionHeight=0.9
	bUnlit=True
	LightType=LT_Steady;
	LightEffect=LE_TorchWaver
	LightBrightness=255
	LightHue=16
	LightSaturation=96
	LightRadius=8
	Mass=2.0
	Buoyancy=1.0
	bFixedRotationDir=True
	Physics=PHYS_Falling
	RemoteRole=ROLE_DumbProxy
	NetPriority=2.5
	bCollideWorld=True
	bIgnoresNanoDefense=True
}
