//=============================================================================
// HXGMTrenchPlayer.
//
// DO NOT USE THIS AS A BASECLASS IF YOU ARE DOING GAMEPLAY MODIFICATIONS.
//
// See HXStockPlayerPawn for a detaile explanation.
//
// MultiSkins:
//  0: Hands and Face.
//  1: Cape top.
//  2: Pants and boots.
//  3: Appears unused, is set to the same as hands and face.
//  4: Shirt.
//  5: Cape bottom and collar.
//  6: Frames (modulated).
//  7: Lenses.
//=============================================================================
class HXGMTrenchPlayer extends HXStockPlayerPawn
	abstract;

// ----------------------------------------------------------------------------
// UpdateTranslucencyDispay()
//
// This function is a pure hack to work around broken rendering for modulated
// faces with DrawType==STY_Translucent and/or ScaleGlow<1.0.
//
// This hack will be removed in the future, and Render/RenderDevice will be
// assumed to handle this correctly on their own.
// ----------------------------------------------------------------------------

function UpdateTranslucencyDispay( bool bMakeTranslucent )
{
	if ( bMakeTranslucent!=bCloakOn )
	{
		if ( bMakeTranslucent )
		{
			MultiSkins[6] = Texture'BlackMaskTex'; // Frames.
			MultiSkins[7] = Texture'BlackMaskTex'; // Lenses. This is needed because it would otherwise look off.
		}
		else
		{
			MultiSkins[6] = default.MultiSkins[6];
			MultiSkins[7] = default.MultiSkins[7];
		}
	}

	Super.UpdateTranslucencyDispay( bMakeTranslucent );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	JumpSound=MaleJump
	HitSound1=MalePainSmall
	HitSound2=MalePainMedium
	Land=MaleLand
	Die=MaleDeath
	Mesh=GM_Trench
	CollisionRadius=20.0
	//CollisionHeight=47.5
	CollisionHeight=43.0
}
