//=============================================================================
// HXGameInfo.
//=============================================================================
class HXGameInfo extends GameInfo
	config;

var const localized String TooManyPlayers;
var const localized String KnockedOutString, KillsString, DeathsString, PlayerString;

// Death messages.
var const localized String DeathFell;
var const localized String DeathDrowned;
var const localized String DeathExploded;
var const localized String DeathExplodedSelf;
var const localized String DeathBurned;
var const localized String DeathHeliblade;
var const localized String DeathAutoTurret;
var const localized String DeathStomped;
var const localized String DeathSuicide;
var const localized String DeathCoughingNails;
var const localized String DeathPlague;

var const localized String AddedToDatavaultLabel;

var const localized String MsgSkillPointsAward;
var const localized String MsgSkillPointsAwardDetail;
var const localized String MsgNoteAdded;
var const localized String MsgGoalAdded;
var const localized String MsgPrimaryGoalCompleted;
var const localized String MsgSecondaryGoalCompleted;

var() globalconfig float FriendlyFire;	// Friendly fire multiplier
var() globalconfig int   StartingSkillPointsBonus;
var() globalconfig int   StartingAugUpgradesBonus;
var() globalconfig int   StartingAugBonus;
var() globalconfig float SkillPointPenalty;
var() globalconfig float SkilledToolPenalty;
var() globalconfig bool  bJCDentonMode;

var() bool bSpawnEffects; // whether or not to spawn things like shell casings and blood (Unsure..)
var() bool bAugsAllowed; //whether or not players have augmentations (I can use this setting later on for UNATCO, NSF style campaigns).

var bool bCustomizable; //Whether or not the gametype is customizable through the menu interface

struct ScoreElement
{
	var String	PlayerName;
	var float	Score;
	var float	Deaths;
	var float	Streak;
	var int		Team;
	var int		PlayerID;
};

var ScoreElement		ScoreArray[32];	// Array to store the scores
var int							ScorePlayers;		// Number of players in the current scoreArray

var color						WhiteColor, SilverColor, RedColor, GreenColor, GoldColor;

const PlayerX	= 0.17;		// Multiplier of screenWidth
const KillsX	= 0.55;		
const DeathsX	= 0.65;		
const StreakX	= 0.75;		
const PlayerY	= 0.25;
const WinY		= 0.15;		// Mutliplier of screenHeight
const FireContY = 0.80;

// Mutator related variables.
var() class<HXMutator> TailMutatorClass; // Class for TailMutator. Mod authors typically want to keep this unchanged.
var HXMutator HXBaseMutator; // BaseMutator casted to HXMutator.

//var bool bInCoopTravel;

// Note Tracking
var DeusExNote FirstNote;
var DeusExNote LastNote;

// Log Messages
var DeusExLog FirstLog;
var DeusExLog LastLog;

// CombatDifficulty
var float CombatDifficulty;

// Conversation Invocation Methods
enum EInvokeMethod
{
	IM_Bump,
	IM_Frob,
	IM_Sight,
	IM_Radius,
	IM_Named,
	IM_Other
};

var HXConPlay ConPlay; // Conversation
var HXDataLinkDryRunner DataLinkPlay;				// Used for DataLinks

// Conversation Manager Classes.
var Class<HXDataLinkManager> DataLinkManagerClass;
var Class<HXBarkManager>     BarkManagerClass;

// Conversation Managers.
var HXDataLinkManager DataLinkManager;
var HXBarkManager     BarkManager;

// conversation info
//var Actor ConversationActor;
//var Actor lastThirdPersonConvoActor;
//var float lastThirdPersonConvoTime;
var Actor LastFirstPersonConvoActor;
var float LastFirstPersonConvoTime;

var() globalconfig bool bCheatsEnabled; // put on server
var bool bSubtitles;

var int CurrentPlayingSoundID; // handle to speech

var GeneratorScout Scout;

var HXSteve Steve;
//var bool bSteveSkillPointsSet;

//var bool bPlayersCleaned;

var HXFlagReplicationInfo FlagReplicationInfo;
var HXImageReplicationInfo ImageReplicationInfo;
var HXNanoKeyReplicationInfo NanoKeyReplicationInfo;

var DeusExLevelInfo DeusExLevelInfo; // Reference to DeusExLevelInfo on this map.

// TODO: Hook these proper in.
var Class<HXMissionScript> MissionScriptClass;
var HXMissionScript        MissionScript;

var bool bShowStartupMessage; // Whether to show the location and stuff.

enum ECommandType
{
	CMDTYPE_None,           // Unspeficied commandtype.
	CMDTYPE_Broadcast,      // Say, TeamSay, ... Could be used to allow moderators to mute other players?
	CMDTYPE_CustomCommand,  // CustomCommand interface.
	CMDTYPE_MapChange,      // Mapchange commands, such as SwitchCoopLevel.
	CMDTYPE_User,           // Free to use for mods and server admins.
	CMDTYPE_User2,          // Free to use for mods and server admins.
	CMDTYPE_User3,          // Free to use for mods and server admins.
	CMDTYPE_User4,          // Free to use for mods and server admins.
	CMDTYPE_CheatDebug,     // Can have nasty stuff as SetState, but otherwise boring cheats.
	CMDTYPE_CheatDebugInfo, // Cheats which have no effect, but expose information (GetState, GetPhysics, ...)
	CMDTYPE_CheatSummon,    // Summon, SpawnMass, All* kind of cheats.
	CMDTYPE_CheatMisc,      // Any other kind of cheats?
	CMDTYPE_Pwn,            // Pwn your server kind of shit..
};

// ----------------------------------------------------------------------------
// Network replication.
// (Note: DX Stores GameInfo on Player.DXGame)
// ----------------------------------------------------------------------------

/*replication
{
	// Server to client
	reliable if ( Role==ROLE_Authority )
		;
}*/

// ----------------------------------------------------------------------------
// InitGame()
// ----------------------------------------------------------------------------

event InitGame( String Options, out String Error )
{
	local Class<MissionScript> NewMissionScriptClass;
	local Name FlagName;

	// Find DeusExLevelInfo.
	foreach AllActors( Class'DeusExLevelInfo', DeusExLevelInfo )
		break;

	// Find Steve.
	foreach AllActors( Class'HXSteve', Steve )
		break;

	// Helpful info about sth. gone wrong.
	Log( "DeusExLevelInfo is" @ DeusExLevelInfo, 'InitGame' );
	Log( "Steve is" @ Steve, 'InitGame' );

	// Figure out if we have been before on this map.
	bShowStartupMessage = true;
	if ( DeusExLevelInfo!=None && Steve!=None )
	{
		FlagName = StringToName( "M"$Caps(DeusExLevelInfo.MapName)$"_StartupText" );
		if ( !Steve.FlagBase.GetBool(FlagName) /*&& DeusExLevelInfo.StartupMessage[0]!=""*/ )
		{
			Steve.FlagBase.SetBool( FlagName, True, True, 1 );
		}
		else
		{
			bShowStartupMessage = false;
		}
	}

	// Make sure MutatorClass is a HXMutator.
	if ( MutatorClass==None )
	{
		MutatorClass = class'HXMutator';
	}
	else if ( !ClassIsChildOf(MutatorClass,class'HXMutator') )
	{
		Warn( "Rejected non HX MutatorClass"@MutatorClass );

		MutatorClass = class'HXMutator';
	}

	// Call Super.
	Super.InitGame( Options, Error );

	// Set HXBaseMutator variable.
	HXBaseMutator = HXMutator(BaseMutator);

	// Spawn TailMutator.
	if ( TailMutatorClass!=None )
		HXBaseMutator.AddMutator( Spawn(TailMutatorClass) );

	// Figure out which MissionScript class to use.
	if ( DeusExLevelInfo!=None )
		NewMissionScriptClass = DeusExLevelInfo.Script;

	// Let Mutators handle MissionScript.
	ModifyMissionScriptClass( NewMissionScriptClass, Level.Outer.Name );

	// Reject any non HXMissionScripts and put a warning about rejected non HX MissionScripts.
	MissionScriptClass = Class<HXMissionScript>(NewMissionScriptClass);
	if ( MissionScriptClass==None && NewMissionScriptClass!=None )
		Warn( "Rejected non HX MissionScriptClass" @ NewMissionScriptClass );

	// Spawn MissionScript here to preempt DeusExLevelInfo from spawning it later on.
	if ( MissionScriptClass!=None )
	{
		MissionScript = Spawn( MissionScriptClass );

		Log( "Spawned MissionScript '"$MissionScript.Name $"'", 'DevMissionScript' );
	}
	else
	{
		Log( "Spawned no MissionScript for " $ Level.Outer.Name $ ".", 'DevMissionScript' );
	}

	// Handle event randomization and flag expiration.
	if ( Steve!=None && Steve.FlagBase!=None && DeusExLevelInfo!=None )
	{
		// Randomize events. Do this before expired flags get deleted.
		if ( MissionScript!=None )
		{		
			if ( !Steve.FlagBase.GetBool('MS_EventsRandomized') )
			{
				if ( MissionScriptClass.default.PrevMissionScript!=None )
					MissionScriptClass.default.PrevMissionScript.Static.RandomizeEvents( Self, Steve, DeusExLevelInfo.MissionNumber, DeusExLevelInfo.MapName );
				Steve.FlagBase.SetBool( 'MS_EventsRandomized', true, true, 0 );
			}
		}

		// Handle flag expiration before they end up in FlagReplicationInfo.
		Steve.Flagbase.DeleteExpiredFlags( DeusExLevelInfo.MissionNumber );
		Steve.Flagbase.SetDefaultExpiration( DeusExLevelInfo.MissionNumber+1 );
	}

	// Init SkillPoints for Steve.
	if ( Steve!=None && MissionScript!=None )
		MissionScript.InitSkillPoints( Self, Steve );

	// Init DataLinkManager.
	DataLinkManager = Spawn( DataLinkManagerClass, None );
	DataLinkManager.Init( Self );
	Log( "DataLinkManager is" @ DataLinkManager, 'InitGame' );

	// Init BarkManager.
	BarkManager = Spawn( BarkManagerClass, None );
	BarkManager.Init( Self );
	Log( "BarkManager is" @ BarkManager, 'InitGame' );

	// Use sth. more decent as i scale the accuracy
	switch ( Difficulty )
	{
		// easy
		case 0:
			CombatDifficulty = 1.0;
			break;
		// medium
		case 1:
			CombatDifficulty = 1.5;
			break;
		// hard
		case 2:
			CombatDifficulty = 2.0;
			break;
		// unreal
		case 3:
			CombatDifficulty = 2.5;
			break;

		// default (error)
		default:
			CombatDifficulty = 1.0;
			break;
	}

	Log( "Difficulty is " $ GetDifficultyName(Difficulty), 'InitGame' );

	// Init EventManager.
	Level.InitEventManager();
}


// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	//Log( Self $ ".PreBeginPlay() called" );

	//ChangeMovers();

	// Super.PreBeginPlay();
	StartTime = 0;
	SetGameSpeed(GameSpeed); // !! Starts a timer which resets spamming limit for messages.
	Level.bNoCheating = bNoCheating;
	Level.bAllowFOV = bAllowFOV;
	
	if ( GameReplicationInfo == None )
	{
		if (GameReplicationInfoClass != None)
			GameReplicationInfo = Spawn(GameReplicationInfoClass);
		else
			GameReplicationInfo = Spawn(class'HXGameReplicationInfo');
	}

	InitGameReplicationInfo();
	// END

	// split replication stuff
	if ( FlagReplicationInfo == None )
	{
		FlagReplicationInfo = Spawn( class'HXFlagReplicationInfo' );
	}
	InitFlagReplicationInfo();

	if ( ImageReplicationInfo == None )
	{
		ImageReplicationInfo = Spawn( class'HXImageReplicationInfo' );
	}
	InitImageReplicationInfo();

	if ( NanoKeyReplicationInfo == None )
	{
		NanoKeyReplicationInfo = Spawn( class'HXNanoKeyReplicationInfo' );
	}
	InitNanoKeyReplicationInfo();

	ResetNonCustomizableOptions();
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

function BeginPlay()
{
	//Log( Self $ ".BeginPlay() called" );

	Super.BeginPlay();
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

function PostBeginPlay()
{
	//Log( Self $ ".PostBeginPlay() called" );

	Super.PostBeginPlay();
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------------

function PostPostBeginPlay()
{
	//local GameReplicationInfo LGRI;

	//Log( Self $ ".PostPostBeginPlay() called" );

	Super.PostPostBeginPlay();

	// since PostPostBeginPlay() seams to be called even after 
	// loading a savegame, put this stuff here
	//bInCoopTravel	= false;	// let us travel again
	//NumPlayers		= 0;			// reset player count

	//Log( "HXGameInfo.PostPostBeginPlay() NumPlayers is " $ NumPlayers );
}

// ----------------------------------------------------------------------------
// GetDifficultyName() -- LOCALIZE !!!
// ----------------------------------------------------------------------------

simulated function String GetDifficultyName( int IntDifficulty )
{
	switch ( IntDifficulty )
	{
		case 0:
			return "Easy";
		case 1:
			return "Medium";
		case 2:
			return "Hard";
		case 3:
			return "DeusEx";
	}
}

// ----------------------------------------------------------------------------
// InitGameReplicationInfo() - Called during PreBeginPlay().
// ----------------------------------------------------------------------------

function InitGameReplicationInfo()
{
	local HXGameReplicationInfo HXGameReplicationInfo;
	local Name FlagName;

	// Parent creates a new gamereplicationinfo.
	Super.InitGameReplicationInfo();

	// Check if we have a HXGameReplicationInfo, if not return.
	HXGameReplicationInfo = HXGameReplicationInfo(GameReplicationInfo);
	if ( HXGameReplicationInfo==None )
		return;

	// Init variables.
	HXGameReplicationInfo.SkilledToolPenalty  = SkilledToolPenalty;
	HXGameReplicationInfo.bShowStartupMessage = bShowStartupMessage;
}

// ----------------------------------------------------------------------------
// InitImageReplicationInfo().
// ----------------------------------------------------------------------------

function InitImageReplicationInfo()
{
	local int i;

	// Sanity check.
	if ( ImageReplicationInfo==None || Steve==None )
		return;

	// Add all images Steve has to ImageReplicationInfo.
	for ( i=0; i<ArrayCount(Steve.DataVaultImages); i++ )
		if ( Steve.DataVaultImages[i]!=None )
			ImageReplicationInfo.AddImage( Steve.DataVaultImages[i] );
}

// ----------------------------------------------------------------------------
// InitFlagReplicationInfo().
// ----------------------------------------------------------------------------

function InitFlagReplicationInfo()
{
	local int FlagCount;
	local int FlagIterator;
	local Name FlagName;

	//Log( Self $ ".InitFlagReplicationInfo() for " $ FlagReplicationInfo );

	if ( FlagReplicationInfo != None && Steve != None )
	{
		// PopulateFlags
		FlagIterator = Steve.FlagBase.CreateIterator();

		while ( Steve.FlagBase.GetNextFlagName( FlagIterator, FlagName ) )
		{
			if ( Steve.FlagBase.CheckFlag( FlagName, FLAG_Bool ) )
			{
				FlagReplicationInfo.SetBoolFlag( FlagName, Steve.FlagBase.GetBool( FlagName ) );
				FlagCount++;
			}
		}

		Steve.FlagBase.DestroyIterator(flagIterator);

		//Log( "FlagReplicationInfo: FlagCount = " $ FlagCount );
	}
}

// ----------------------------------------------------------------------------
// InitNanoKeyReplicationInfo().
// ----------------------------------------------------------------------------

function InitNanoKeyReplicationInfo()
{
	local HXNanoKeyInfo CurrentKey;

	//Log( Self $ ".InitNanoKeyReplicationInfo() for " $ NanoKeyReplicationInfo );

	if ( NanoKeyReplicationInfo != None && Steve != None )
	{
		CurrentKey = Steve.KeyList;

		while ( CurrentKey != None )
		{
			NanoKeyReplicationInfo.AddNanoKey( CurrentKey.Description );

			CurrentKey = CurrentKey.NextKey;
		}
	}
}

// ----------------------------------------------------------------------------
// IsRelevant().
//
// Return whether an actor should be destroyed in this type of game.
// ----------------------------------------------------------------------------

function bool IsRelevant( Actor Other )
{
	local bool bResult;

	//
	// Setting state of GameInfo enables Actors to check if their current run
	// of *BeginPlay() events is caused during a Spawn() inside the Mutator.
	//
	// For game startup the *BeginPlay() events are run twice.
	//
	GotoState( 'InIsRelevant' );
	bResult = Super.IsRelevant( Other );
	GotoState( '' );

	return bResult;
}
state InIsRelevant {}

// ----------------------------------------------------------------------------
// PreLogin()
// ----------------------------------------------------------------------------

event PreLogin( String Options, String Address, out String Error, out String FailCode )
{
	Super.PreLogin( Options, Address, Error, FailCode );

	if ( MaxPlayers>0 && NumPlayers>=MaxPlayers )
		Error = TooManyPlayers;
}

// ----------------------------------------------------------------------------
// Login()
// ----------------------------------------------------------------------------

event PlayerPawn Login( string Portal, string Options, out string Error, class<PlayerPawn> SpawnClass )
{
	local PlayerPawn NewPlayer, TestPlayer;
	local HXPlayerPawn CoopPlayer;
	local Actor StartSpot;
	local Pawn PawnLink;
	local Vector SpawnLocation;
	local Rotator SpawnRotation;
	local String InName, InPassword, InSkin, InFace, InChecksum;
	local byte InTeam;

	// Set Portal (Maybe i can just use Portal and not Steve.Portal direct).
	if ( Steve!=None )
		Portal = Steve.Portal;
	else
		Portal = "";

	// Make sure there is capacity. (This might have changed since the PreLogin call).
	if ( Level.NetMode!=NM_Standalone )
	{
		/*if ( ClassIsChildOf(SpawnClass,Class'Spectator') )
		{
			if ( NumSpectators>=MaxSpectators && (Level.NetMode!=NM_ListenServer || NumPlayers>0) )
			{
				Error = MaxedOutMessage;
				return None;
			}
		}		
		else */if ( MaxPlayers>0 && NumPlayers>=MaxPlayers )
		{
			Error = MaxedOutMessage;
			return None;
		}
	}

	// Give GameInfos or Mutators a chance to change SpawnClass.
	// ApproveClass is still called later on, so GameInfo can always
	// check on what Mutators did if desired.
	ModifyLogin( SpawnClass, Portal, Options );

	// Get URL options.
	InName     = Left(ParseOption ( Options, "Name"), 20);
	InTeam     = GetIntOption( Options, "Team", 0 ); // default to "no team"
	InPassword = ParseOption ( Options, "Password" );
	InSkin	   = ParseOption ( Options, "Skin"    );
	InFace     = ParseOption ( Options, "Face"    );
	InChecksum = ParseOption ( Options, "Checksum" );

	// No Teamgames in HX..
	InTeam = 0;

	Log( "Login:" @ InName );
	if( InPassword != "" )
		Log( "Password"@InPassword );

	// Try to match up to existing unoccupied player in level for singleplayer savegames.
	if ( Level.NetMode==NM_Standalone )
	{
		for ( PawnLink=Level.PawnList; PawnLink!=None; PawnLink=PawnLink.NextPawn )
		{
			TestPlayer = PlayerPawn(PawnLink);
			if ( TestPlayer!=None && !TestPlayer.bDeleteMe && TestPlayer.Player==None && TestPlayer.PlayerReplicationInfo!=None && TestPlayer.bIsPlayer /*&& TestPlayer.PlayerReplicationInfo.PlayerName!=Class'PlayerReplicationInfo'.Default.PlayerName*/ )
			{
				if ( ApproveClass(TestPlayer.Class) )
				{
					// Found matching unoccupied player, so use this one.
					NewPlayer = TestPlayer;
					break;
				}
			}
		}
	}

	// Find a start spot.
	StartSpot = FindCoopPlayerStart( NewPlayer, SpawnLocation, SpawnRotation, InTeam, Portal );
	if( StartSpot==None )
	{
		Error = FailedPlaceMessage;
		return None;
	}

	// Create NewPlayer if needed.
	if ( NewPlayer==None )
	{
		// Make sure this kind of player is allowed.
		if ( !ApproveClass(SpawnClass) )
			SpawnClass = DefaultPlayerClass;

		// Try to Spawn a new Player.
		NewPlayer = Spawn( SpawnClass, , , SpawnLocation, SpawnRotation );

		// Check if Spawn failed, if so, retry with default Teleporters/PlayerStarts.
		if ( NewPlayer==None )
		{
			Log( "Couldn't spawn player at " $ StartSpot $ ". Retrying.." );
			StartSpot = FindPlayerStart( None, InTeam, Portal );
			if( StartSpot==None )
			{
				Error = FailedPlaceMessage;
				return None;
			}
			SpawnLocation = StartSpot.Location;
			SpawnRotation = StartSpot.Rotation;
			NewPlayer = Spawn( SpawnClass, , , SpawnLocation, SpawnRotation );
		}

		// Set initial ViewRotation.
		if( NewPlayer!=None )
		{
			NewPlayer.ViewRotation = SpawnRotation;
		}
	}
	// Already existing player. So probably a SinglePlayer Savegame, so no need to move Player to Spawnpoint.
	//else
	//{
	//}

	// Handle spawn failure.
	if( NewPlayer==None )
	{
		Log( "Couldn't spawn player at " $ StartSpot );
		Error = FailedSpawnMessage;
		return None;
	}

	// Set multiskin.
	NewPlayer.static.SetMultiSkin( NewPlayer, InSkin, InFace, InTeam );

	// Set the player's ID.
	NewPlayer.PlayerReplicationInfo.PlayerID = CurrentID++;

	// Init player's information.
	NewPlayer.ClientSetRotation( NewPlayer.Rotation );

	// Handle players name.
	// TODO: Force rename or reject players with default or dublicated names!
	if( InName=="" || InStr(InName,"__INTERNAL_Steve_")!=-1 )
		InName = DefaultPlayerName;
	if( Level.NetMode!=NM_Standalone || NewPlayer.PlayerReplicationInfo.PlayerName==DefaultPlayerName )
		ChangeName( NewPlayer, InName, False );

	// Change player's team.
	if ( !ChangeTeam(NewPlayer,InTeam) )
	{
		Error = FailedTeamMessage;
		return None;
	}

	// Update Spectator count.
	if( NewPlayer.IsA('Spectator') && (Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer) )
		NumSpectators++;

	// Init player's administrative privileges
	NewPlayer.Password = InPassword;

	// Use AdminLogin() since AdminPassword is private but basically does the same.
	AdminLogin( NewPlayer, InPassword );

	// Init player's replication info.
	NewPlayer.GameReplicationInfo = GameReplicationInfo;

	// If we are a server, broadcast a welcome message.
	if( Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer )
		BroadcastMessage( NewPlayer.PlayerReplicationInfo.PlayerName$EnteredMessage, False );

	// Teleport-in effect.
	//StartSpot.PlayTeleportEffect( NewPlayer, True );

	// Log it.
	if ( LocalLog != None )
		LocalLog.LogPlayerConnect(NewPlayer);
	if ( WorldLog != None )
		WorldLog.LogPlayerConnect(NewPlayer, InChecksum);

	// Update Player Count.
	if ( !NewPlayer.IsA('Spectator') )
		NumPlayers++;

	// Init HX specific stuff.
	CoopPlayer = HXPlayerPawn(NewPlayer);
	if ( CoopPlayer!=None )
	{
		// CoopSpecific replication infos.
		CoopPlayer.FlagReplicationInfo		= FlagReplicationInfo;
		CoopPlayer.ImageReplicationInfo		= ImageReplicationInfo;
		CoopPlayer.NanoKeyReplicationInfo	= NanoKeyReplicationInfo;

		// Not sure what it does.
		CoopPlayer.bAutoActivate = True;

		// Crap shit.
		CoopPlayer.bInThirdPersonCameraOverride = False;
	}

	return NewPlayer;
}

// ---------------------------------------------------------------------
// PostLogin()
// ---------------------------------------------------------------------

event PostLogin(playerpawn NewPlayer)
{
	local HXPlayerPawn DXPlayer;
	local HXMissionScript Scr;
	local Pawn Pawn;

	DXPlayer = HXPlayerPawn(NewPlayer);

	//log("class of new player is "$DXPlayer.Class$", class of game is "$Class$".");
	// DEUS_EX AMSD Setup abilities now called when server syncs up with options.
	//   SetupAbilities(DXPlayer);

	// MB I tried putting this in postbeginplay and postpostbeginplay, but PlayerIsListenClient failed to do the right thing at that point
	if ( DXPlayer.PlayerIsListenClient() )
	{
		DXPlayer.CreatePlayerTracker();

		if (DXPlayer.ThemeManager == NONE)
		{
			DXPlayer.CreateColorThemeManager();
			DXPlayer.ThemeManager.SetOwner( DXPlayer );
			DXPlayer.ThemeManager.SetCurrentHUDColorTheme(DXPlayer.ThemeManager.GetFirstTheme(1));		
			DXPlayer.ThemeManager.SetCurrentMenuColorTheme(DXPlayer.ThemeManager.GetFirstTheme(0)); 
			DXPlayer.ThemeManager.SetMenuThemeByName(DXPlayer.MenuThemeName);
			DXPlayer.ThemeManager.SetHUDThemeByName(DXPlayer.HUDThemeName);

			HXRootWindow(DXPlayer.rootWindow).ChangeStyle();
		}

		DXPlayer.ReceiveFirstOptionSync(DXPlayer.AugPrefs[0], DXPlayer.AugPrefs[1], DXPlayer.AugPrefs[2], DXPlayer.AugPrefs[3], DXPlayer.AugPrefs[4]);
		DXPlayer.ReceiveSecondOptionSync(DXPlayer.AugPrefs[5], DXPlayer.AugPrefs[6], DXPlayer.AugPrefs[7], DXPlayer.AugPrefs[8]);
		DXPlayer.ReceiveThirdOptionSync(DXPlayer.AugUpPrefs[0], DXPlayer.AugUpPrefs[1], DXPlayer.AugUpPrefs[2], DXPlayer.AugUpPrefs[3], DXPlayer.AugUpPrefs[4]);
		DXPlayer.ReceiveForthOptionSync(DXPlayer.AugUpPrefs[5], DXPlayer.AugUpPrefs[6], DXPlayer.AugUpPrefs[7], DXPlayer.AugUpPrefs[8]);

		DXPlayer.ShieldStatus = SS_Off;
	}

	// Start player's music.
	NewPlayer.ClientSetMusic( Level.Song, Level.SongSection, Level.CdTrack, MTRAN_Fade );

	// Not sure if we need that later for on. But if it should replicate the other multiskins too.
	if  ( Level.NetMode!=NM_Standalone )
	{
		// Replicate skins
		for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
		{
			if ( Pawn.bIsPlayer && Pawn!=NewPlayer )
			{
				if ( Pawn.bIsMultiSkinned )
				{
					NewPlayer.ClientReplicateSkins( Pawn.MultiSkins[0], Pawn.MultiSkins[1], Pawn.MultiSkins[2], Pawn.MultiSkins[3] );
					NewPlayer.ClientReplicateSkins( Pawn.MultiSkins[4], Pawn.MultiSkins[5], Pawn.MultiSkins[6], Pawn.MultiSkins[7] );
				}
				else
					NewPlayer.ClientReplicateSkins( Pawn.Skin );	
					
				if ( Pawn.PlayerReplicationInfo!=None && Pawn.PlayerReplicationInfo.bWaitingPlayer && Pawn.IsA('PlayerPawn') )
				{
					if ( NewPlayer.bIsMultiSkinned )
					{
						PlayerPawn(Pawn).ClientReplicateSkins( NewPlayer.MultiSkins[0], NewPlayer.MultiSkins[1], NewPlayer.MultiSkins[2], NewPlayer.MultiSkins[3] );
						PlayerPawn(Pawn).ClientReplicateSkins( NewPlayer.MultiSkins[4], NewPlayer.MultiSkins[5], NewPlayer.MultiSkins[6], NewPlayer.MultiSkins[7] );
					}
					else
						PlayerPawn(Pawn).ClientReplicateSkins( NewPlayer.Skin );	
				}						
			}
		}
	}

	DXPlayer.bPostLoginRun = True;

	foreach AllActors( class'HXMissionScript', Scr )
		break;

	if ( Scr != None )
	{
		if ( Scr.bCinematicMap )
		{
			// HX_NOTE: Do things here
			DXPlayer.bOnCinematicMap = True;
			//DXPlayer.ClientCreateConWinThird( True );
			//DXPlayer.bInThirdPersonCameraOverride = True;
			DXPlayer.SetCollision( False, False, False );
			DXPlayer.RelevantRadius = 800;
			
			//DXPlayer.GotoState('Conversation');
			//DXPlayer.NextState = 'Conversation';
		}

		//Scr.NotifyPlayerUp( DXPlayer );
	}
}

// ----------------------------------------------------------------------------
// ModifyLogin()
//
// Called off GameInfo's Login. If override this function, it is recommended
// to still call into Mutators PreModifyLogin and PostModifyLogin methods.
// ----------------------------------------------------------------------------

function ModifyLogin( out class<PlayerPawn> SpawnClass, out string Portal, out string Options )
{
	local byte bSuperRelevant;

	// Let Mutators try their thing first.
	if ( HXBaseMutator!=None )
		HXBaseMutator.ModifyLogin( SpawnClass, Portal, Options, bSuperRelevant );

	// Mutator wants to override any logic in here.
	if ( bSuperRelevant!=0 ) 
		return;

	// Enforce Dentons if desired.
	if ( bJCDentonMode && !IsJCDentonPlayerClass(SpawnClass) )
	{
		// Use hashing to get select an input dependend class replacement.
		switch ( int(float(class'HXActor'.static.Strihash(SpawnClass.Name)&0x7fffffff)/float(0x7fffffff)*5.0) )
		{
			case 0:  SpawnClass = class'HXJCDentonPlayer' ; break;
			case 1:  SpawnClass = class'HXJCDenton2Player'; break;
			case 2:  SpawnClass = class'HXJCDenton3Player'; break;
			case 3:  SpawnClass = class'HXJCDenton4Player'; break;
			default: SpawnClass = class'HXJCDenton5Player'; break;
		}
	}
	// Otherwise accept any HXStockPlayerPawn.
	// The idea here is that if everyone aggrees that HXStockPlayerPawn
	// subclasses are only used for cosmetic changes, this can be kept
	// open to PlayerClasses which only do cosmetic changes, this would be
	// neat. If this won't work I do have to whitelist only the PlayerClasses
	// shipping with HX here. So be warned.
	else if ( ClassIsChildOf(SpawnClass,class'HXStockPlayerPawn') )
	{
		// Accepted.
	}
	// Currently no Spectator support.
	//if ( ClassIsChildOf(PlayerClass,class'Spectator') )
	//{
		//return true;
	//}
	// Otherwise enforce default class.
	else
	{
		SpawnClass = DefaultPlayerClass;	
	}
}

// ----------------------------------------------------------------------------
// ApproveClass()
//
// It is recommended to use the superior ModifyLogin interface now.
// ----------------------------------------------------------------------------

function bool ApproveClass( class<PlayerPawn> PlayerClass )
{
	return true;
}

// ----------------------------------------------------------------------------
// IsJCDentonPlayerClass()
//
// Whether this class is associated for a true JC Denton by this gametype.
// This is used to enfore JC Denton only mode.
// ----------------------------------------------------------------------------

function bool IsJCDentonPlayerClass( class<PlayerPawn> PlayerClass )
{
	switch ( PlayerClass )
	{
		case class'HXJCDentonPlayer':
		case class'HXJCDenton2Player':
		case class'HXJCDenton3Player':
		case class'HXJCDenton4Player':
		case class'HXJCDenton5Player':
			return true;
			break;

		default:
			return false;
			break;
	}
}

// ----------------------------------------------------------------------------
// IsDentonPlayerClass()
//
// Whether this class is associated to be a Denton by this gametype.
// This is used to enfore JC Denton only mode.
// ----------------------------------------------------------------------------

function bool IsDentonPlayerClass( class<PlayerPawn> PlayerClass )
{
	switch ( PlayerClass )
	{
		case class'HXPaulDentonPlayer':
		case class'HXPaulDenton2Player':
		case class'HXPaulDenton3Player':
		case class'HXPaulDenton4Player':
		case class'HXPaulDenton5Player':
			return true;
			break;

		default:
			return IsJCDentonPlayerClass(PlayerClass);
			break;
	}
}

// ----------------------------------------------------------------------------
// IsAugmentedPlayerClass()
//
// Whether this class is associated to be a augmented agent like the Dentons.
//
// Could be used by gamemodes to turn off aug for non augmented classes.
// ----------------------------------------------------------------------------

function bool IsAugmentedPlayerClass( class<PlayerPawn> PlayerClass )
{
	switch ( PlayerClass )
	{
		case class'HXWaltonSimonsPlayer':
			return true;
			break;

		default:
			return IsDentonPlayerClass(PlayerClass);
			break;
	}
}

// ----------------------------------------------------------------------------
// DiscardInventory()
// ----------------------------------------------------------------------------

function DiscardInventory( Pawn Other )
{
	// do nothing
}

// ----------------------------------------------------------------------------
// Logout()
//
// Pawn exits.
// ----------------------------------------------------------------------------

function Logout( Pawn Exiting )
{
	local HXPlayerPawn ExitingPlayer;
	local HXScriptedPawn PawnActor;
	local HXComputers CompActor;
	local bool bMessage;

	ExitingPlayer = HXPlayerPawn(Exiting);

	Log( "Logout:"@Exiting );

	if ( ExitingPlayer!=None )
	{
		ExitingPlayer.HXCloseThisComputer( ExitingPlayer.HXActiveComputer );
		ExitingPlayer.CloseThisPawn( ExitingPlayer.ActivePawn );

		ExitingPlayer.HXActiveComputer = None;
		ExitingPlayer.ActivePawn = None;

		foreach AllActors(class'HXComputers',CompActor)
		{
			if ((CompActor.CurFrobber != None) && (CompActor.CurFrobber == ExitingPlayer))
			{
				log("====>Player logged out while logged in, forcing computer closed");
				ExitingPlayer.HXCloseComputerScreen(CompActor);
			}
		}

		foreach AllActors(class'HXScriptedPawn',PawnActor)
		{
			if ((PawnActor.CurFrobber != None) && (PawnActor.CurFrobber == ExitingPlayer))
			{
				log("====>Player logged out while using pawn, forcing pawn closed");
				ExitingPlayer.ClosePawn(PawnActor);
			}
		}

		// Played was destroyed, so notify ConPlay
		if ( ConPlay!=None )
			ConPlay.ActorDestroyed( ExitingPlayer );
	}

	// Modified GameInfo.Logout starts here.
	bMessage = true;
	if ( Exiting.IsA('PlayerPawn') )
	{
		if ( Exiting.IsA('Spectator') )
		{
			bMessage = false;
			if ( Level.NetMode == NM_DedicatedServer )
				NumSpectators--;
		}
		else
		{
			NumPlayers--;
		}
	}
	if ( bMessage && Exiting.PlayerReplicationInfo!=None && (Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer) )
		BroadcastMessage( Exiting.PlayerReplicationInfo.PlayerName$LeftMessage, false );

	//if ( LocalLog != None )
		//LocalLog.LogPlayerDisconnect(Exiting);
	//if ( WorldLog != None )
		//WorldLog.LogPlayerDisconnect(Exiting);
}

// ---------------------------------------------------------------------
// RestartPlayer()
//
// Keep Augmentations, Skills, Credits, Logs, Images and similar,
// but remove inventory.
// ---------------------------------------------------------------------

function bool RestartPlayer( Pawn PlayerToRestart )	
{
	local HXPlayerPawn Player;
	local Actor StartSpot;
	local Rotator SpawnRotation;
	local Vector SpawnLocation;
	local String Portal;

	Log( "DeusEx Coop Game restart player." );

	Player = HXPlayerPawn(PlayerToRestart);
	if ( Player==None)
	{
		Log( "Trying to restart non HX player!" );
		return False;
	}

	if ( Steve!=None )
		Portal = Steve.Portal;

	//Restore HUD    
	Player.ShowHud( True );

	// Deactivate all Augs.
	HXAugmentationManager(Player.AugmentationSystem).ForceDeactivateAll();
	Player.StopNanoVirusInfection();
	Player.RemoveAllInventory();

	// Restore Healh and Energy.
	Player.RestoreAllHealth();
	Player.Energy = Player.Default.Energy;

	// Empty Hands.
	Player.SetInHandPending( None );
	Player.SetInHand( None );
	Player.bInHandTransition = False;

	// Reinitialize all subsystems we've just nuked.
	Player.InitializeSubSystems();

	// Reset Killer.
	Player.MyProjKiller = None;

	// Give starting inventory.
  //if ( Level.Netmode!=NM_Standalone )
	//{
		//Player.NintendoImmunityEffect( True );
		Player.GiveInitialInventory();
	//}

	// Note: Probably unify with GiveInitialInventory.
	AddDefaultInventory( Player );

	// HX_HAN -- Probably not needed for HX.
	if( bRestartLevel && Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
		return True;

	StartSpot = FindCoopPlayerStart( Player, SpawnLocation, SpawnRotation, 0, Portal );
	if( StartSpot==None )
	{
		// FindCoopPlayerStart tries Teleporters/PlayerStarts as fallbacks, so we can return here
		// as a further FindPlayerStart() will yield nothing too.
		Log( " CoopStart not found!!!" );
		return False;
	}

	// Try override Location.
	if ( Player.SetLocation(SpawnLocation) )
	{
		//StartSpot.PlayTeleportEffect( Player, True );
		Player.SetRotation( SpawnRotation );
		Player.ViewRotation = Player.Rotation;
		Player.Acceleration = vect(0,0,0);
		Player.Velocity = vect(0,0,0);
		Player.Health = Player.Default.Health;
		Player.SetCollision( True, True, True );
		Player.ClientSetLocation( SpawnLocation, SpawnRotation );
		Player.bHidden = False;
		Player.DamageScaling = Player.Default.DamageScaling;
		Player.SoundDampening = Player.Default.SoundDampening;
		return True;
	}

	// Override Location went bad.
	Log( "Modified " $ StartSpot $" CoopStart not useable!!!" );

	// Retry Location the StartSpot has.
	if ( Player.SetLocation(StartSpot.Location) )
	{
		//StartSpot.PlayTeleportEffect( Player, True );
		Player.SetRotation( StartSpot.Rotation );
		Player.ViewRotation = Player.Rotation;
		Player.Acceleration = vect(0,0,0);
		Player.Velocity = vect(0,0,0);
		Player.Health = Player.Default.Health;
		Player.SetCollision( True, True, True );
		Player.ClientSetLocation( StartSpot.Location, StartSpot.Rotation );
		Player.bHidden = False;
		Player.DamageScaling = Player.Default.DamageScaling;
		Player.SoundDampening = Player.Default.SoundDampening;
		return True;
	}

	// Still went bad.
	Log( StartSpot$" CoopStart not useable!!!" );

	// Last Resort: Try old singleplayer Teleporters/SpawnPoints.
	StartSpot = FindPlayerStart( Player, 0, Portal );
	if( StartSpot==None )
	{
		Log( " PlayerStart not found!!!" );
		return False;
	}
	if ( Player.SetLocation(StartSpot.Location) )
	{
		//StartSpot.PlayTeleportEffect( Player, True );
		Player.SetRotation( StartSpot.Rotation );
		Player.ViewRotation = Player.Rotation;
		Player.Acceleration = vect(0,0,0);
		Player.Velocity = vect(0,0,0);
		Player.Health = Player.Default.Health;
		Player.SetCollision( True, True, True );
		Player.ClientSetLocation( StartSpot.Location, StartSpot.Rotation );
		Player.bHidden = False;
		Player.DamageScaling = Player.Default.DamageScaling;
		Player.SoundDampening = Player.Default.SoundDampening;
		return True;
	}

	// Still went bad.
	Log( StartSpot$" PlayerStart not useable!!!" );

	return False;
}

// ----------------------------------------------------------------------------
// SetupAbilities()
// ----------------------------------------------------------------------------

function SetupAbilities( HXPlayerPawn Player )
{
	if ( Player==None || Player.bAugsGranted )
		return;

	GrantAugs( Player, StartingAugBonus );
	GrantAugUpgrades( Player, StartingAugUpgradesBonus  );

	Player.bAugsGranted = True;
}

// ----------------------------------------------------------------------------
// FindPlayerStart()
// ----------------------------------------------------------------------------

function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string IncomingName )
{
	local PlayerStart Dest;
	local Teleporter Tel;

	// If we have IncomingName, try teleporters.
	if( IncomingName!="" )
		foreach AllActors( Class 'Teleporter', Tel )
			if( String(Tel.Tag)~=IncomingName )
				return Tel;

	// Now try PlayerStarts.
	foreach AllActors( Class'PlayerStart', Dest )
		if( Dest.bSinglePlayerStart && Dest.bEnabled )
			return Dest;

	// If none, check for any that aren't enabled.
	Log( "WARNING: All single player starts were disabled - picking one anyway!" );
	foreach AllActors( Class'PlayerStart', Dest )
		if( Dest.bSinglePlayerStart )
			return Dest;

	Log( "No single player start found" );
	return None;
}

// ----------------------------------------------------------------------------
// FindCoopPlayerStart()
//
// Assume CoopStars collision to be of player size.
// ----------------------------------------------------------------------------

function Actor FindCoopPlayerStart( Pawn Player, out Vector SpawnLocation, out Rotator SpawnRotation, optional byte InTeam, optional String IncomingName )
{
	local HXCoopStart Candidates[32], CoopStart, Best;
	local NavigationPoint Fallback;
	local Pawn Pawn;
	local Vector Dist;
	local float Scores[32], BestScore;
	local int Num, i;
	local float PlayerCollisionHeight;
	local float PlayerCollisionRadius;

	// Initialize PlayerCollisionHeight/PlayerCollisionRadius check width based on Player if existing and otherwise on HXCoopStart default values.
	if ( Player!=None )
	{
		PlayerCollisionHeight = Player.CollisionHeight;
		PlayerCollisionRadius = Player.CollisionRadius;
	}
	else
	{
		PlayerCollisionHeight = class'HXCoopStart'.default.CollisionHeight;
		PlayerCollisionRadius = class'HXCoopStart'.default.CollisionRadius;
	}

	// Find all CoopStarts.
	Num = 0;
	foreach AllActors( class'HXCoopStart', CoopStart )
	{
		if ( Num<ArrayCount(Candidates) )
		{
			// Just consider spawnpoints with matching Tag or if IncomingName is
			// empty use spawnpoints with default tag. (e.g. Tag==Class.Name) or with bDefaultStart set.
			if ( CoopStart.bEnabled && ((IncomingName=="" && (CoopStart.bDefaultStart || CoopStart.Tag==CoopStart.Class.Name)) || IncomingName~=String(CoopStart.Tag)) )
			{
				Candidates[Num] = CoopStart;
				Scores[Num]     = CoopStart.Priority;
				Num++;
			}
		}
		else
		{
			// We can't add any more Candidates.
			break;
		}
	}

	// We have at least one dedicated CoopStart.
	if ( Num>0 )
	{
		// Recommanded Priority Range of CoopStart.Priority property is 0..1000 and steps between 100-250.

		// Randomize priority a bit.
		for ( i=0; i<Num; i++ )
			Scores[i] += 90 * (FRand()-0.5); // [-45,45]

		// NOTE: Maybe use Level.PawnList/accout for non players. But these should add a lesser penalty.
		//foreach AllActors( Class'Pawn', Pawn )
		for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
		{
			// Check for players occupying the CoopStart.
			if ( Pawn.bIsPlayer && Pawn!=Player )
			{
				for ( i=0; i<Num; i++ )
				{
					Dist = Pawn.Location-Candidates[i].Location;

					// Make height difference check conservative as there shouldn't be any CoopStarts placed that close above each other if at all.
					if ( Abs(Dist.Z)<2.0*(PlayerCollisionHeight+Pawn.CollisionHeight) )
					{
						// Zero Dist.Z so VSize(Dist) is horizontal distance.
						Dist.Z = 0.0;

						// Avoid telefragging by applying a huge penalty.
						if ( VSize(Dist)<1.15*(PlayerCollisionRadius+Pawn.CollisionRadius) )
							Scores[i] -= 1000000.0;
					}
				}
			}
		}

		BestScore = Scores[0];
		Best = Candidates[0];
		for ( i=0; i<Num; i++ )
		{
			if ( Scores[i]>BestScore )
			{
				BestScore = Scores[i];
				Best = Candidates[i];
			}
		}			

		SpawnLocation = Best.Location;
		SpawnRotation = Best.Rotation;	
		return Best;
	}

	// We have no dedicated CoopStarts, now fall back to Teleporters and PlayerStarts.
	Fallback = FindPlayerStart( Player, InTeam, IncomingName );
	if ( FallBack!=None )
	{
		Log( "Using fallback playerstart." );

		// Randomly select a location around SpawnPoint which the Scout regards as reliable.
		// Didn't work really great, and will never, mostly because of map design.
		// Also there is nothing better then a handcrafted list of SpawnPoints.
		// Might be of some (limited) use for initial support of non DeusEx maps.
		//SpawnLocation = Fallback.Location;
		//SpawnRotation = Fallback.Rotation;
		//if ( RandomizePlayerStart(Player,Fallback,SpawnLocation,SpawnRotation) )
			//return FallBack;

		SpawnLocation = Fallback.Location;
		SpawnRotation = Fallback.Rotation;
		return FallBack;
	}

	// Login() really does not like this.
	return None;
}

// ----------------------------------------------------------------------------
// CheckStartLocation()
// ----------------------------------------------------------------------------

function bool CheckSpawnLocation( Vector SpawnLocation, Pawn Player )
{
	local Pawn CurPawn;
	local float SafeDist;

	// Make it slightly larger.
	SafeDist = 2.1 * Class'HXPlayerPawn'.Default.CollisionRadius;

	// check distance to other players, maybe to all pawns
	for ( CurPawn = Level.PawnList; CurPawn != None; CurPawn = CurPawn.NextPawn )
		if ( /*CurPawn.bIsPlayer &&*/ CurPawn!=Player )
			if ( VSize(CurPawn.Location-SpawnLocation)<(Player.CollisionRadius+CurPawn.CollisionRadius)*1.05 )
				return False;

	return True;
}

// ----------------------------------------------------------------------------
// RandomizePlayerStart()
// Cleaned up version of code used before handcrafted CoopStarts were
// available for HX. Was never really reliable (But only used one round
// instead of four).
// ----------------------------------------------------------------------------

function bool RandomizePlayerStart( Pawn Player, Actor PlayerStart, out vector SpawnLocation, out Rotator SpawnRotation )
{
	local Pawn MyScout;
	local float SafeDist;
	local int i;

	SpawnLocation = PlayerStart.Location;

	// First test if start spot is ok
	if ( CheckSpawnLocation( SpawnLocation, Player ) )
	{
		SpawnLocation = PlayerStart.Location;
		SpawnRotation = PlayerStart.Rotation;
		return True;
	}

	// Make SafeDist a bit larger then required.
	SafeDist = 2.1 * Class'HXPlayerPawn'.Default.CollisionRadius;

	// Now use scout to find a new location.
	MyScout = GetScout();

	// Four attempts.
	for ( i=0; i<4; i++ )
	{
		// Init.
		SpawnLocation = PlayerStart.Location;
		SpawnRotation = PlayerStart.Rotation;

		MyScout.SetLocation( SpawnLocation );
		MyScout.SetRotation( SpawnRotation );

		// Okay now lets try AIPickRandomDestination().
		if ( Scout.AIPickRandomDestination(SafeDist,SafeDist*4.0,SpawnRotation.Yaw,0.5,0,0,7,1.0,SpawnLocation) )
		{
			Log( "Scout found us a new Location!" );
			return True;
		}
	}
	return False;
}

// ----------------------------------------------------------------------------
// GetScout()
// ----------------------------------------------------------------------------

function GeneratorScout GetScout()
{
	// Try to find Scout by Tag.
	if ( Scout==None )
		foreach AllActors( Class'GeneratorScout', Scout, 'GameInfoScout' )
			break;

	// If Scout is still None spawn a new Scout.
	if ( Scout==None )
	{
		Scout = Spawn( Class'GeneratorScout', Self, 'GameInfoScout' , Location );
		if ( Scout!=None )
		{
			Scout.SetCollisionSize( Class'HXPlayerPawn'.Default.CollisionRadius, Class'HXPlayerPawn'.Default.CollisionHeight );
			Scout.SetCollision( False, False, False);
			Scout.SetPhysics( PHYS_Flying );
			Scout.Health = 100;
		}
	}
	return Scout;
}

// ----------------------------------------------------------------------------
// Killed()
// ----------------------------------------------------------------------------

function Killed( Pawn Killer, Pawn Other, name DamageType )
{
	local String Message;
	local Pawn CurPawn;

	if ( Other.bIsPlayer )
	{
		if ( Killer!=None && !Killer.bIsPlayer )
		{
			if ( Level.NetMode!=NM_Standalone )
			{
				Message = Other.PlayerReplicationInfo.PlayerName$Killer.KillMessage( DamageType, Other );
			}
		}

		if ( Killer==Other || Killer==None )
		{
			switch ( DamageType )
			{
				case 'Fell':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathFell;
					break;
				case 'Drowned':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathDrowned;
					break;
				case 'Exploded':
					if ( Killer==None )
						Message = Other.PlayerReplicationInfo.PlayerName @ DeathExploded;
					else
						Message = Other.PlayerReplicationInfo.PlayerName @ DeathExplodedSelf;
					break;
				case 'Burned':
				case 'Flamed':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathBurned;
					break;
				case 'HeliBlade':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathHeliblade;
					break;
				case 'AutoShot':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathAutoTurret;
					break;
				case 'Stomped':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathStomped;
					break;
				case 'CoughingNails':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathCoughingNails;
					break;
				case 'Plague':
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathPlague;
					break;

				default:
					Message = Other.PlayerReplicationInfo.PlayerName @ DeathSuicide;
					break;
			}
		}
		else
		{
			if ( Killer.bIsPlayer )
			{
				if ( HXPlayerPawn(Other).KillProfile.MethodStr~="None" )
					Message = Killer.PlayerReplicationInfo.PlayerName$" killed "$Other.PlayerReplicationInfo.PlayerName$".";
				else
					Message = Killer.PlayerReplicationInfo.PlayerName$" killed "$Other.PlayerReplicationInfo.PlayerName $ HXPlayerPawn(Other).KillProfile.MethodStr;
			}
		}
	}

	if ( Message!="" )
	{
		//Add to console log as well (with pri id) so that kick/kickban can work better.
		Log( Message );
		
		for ( CurPawn = Level.PawnList; CurPawn != None; CurPawn = CurPawn.NextPawn )
			if ( CurPawn.IsA('HXPlayerPawn') && HXPlayerPawn(CurPawn).bAdmin )
				HXPlayerPawn(CurPawn).LocalLog( Message );

		BroadCastMessage( Message, False, 'DeathMessage' );
	}

	//if ( Other.bIsPlayer )
		//HandleDeathNotification( Killer, Other );

	// death and streak counter
	Other.DieCount++;

	if ( Other.bIsPlayer )
	{
		Other.PlayerReplicationInfo.Deaths += 1;
	}

	// Suicide? (maybe killed by autoturret too).
	if ( Killer==Other || Killer==None )
	{
		if ( Other.isA('HXPlayerPawn') )
		{
			// Don't dock them if it nano exploded in their face
			if ( !(HXProjectile(HXPlayerPawn(Other).MyProjKiller)!=None && HXProjectile(HXPlayerPawn(Other).MyProjKiller).bAggressiveExploded ))
				Other.PlayerReplicationInfo.Score -= 1;
		}
	}
	// Player killed Player.
	else if ( Killer!=None && Other!=None && Killer.bIsPlayer && Other.bIsPlayer )
	{
		Killer.KillCount--;

		if ( Killer.PlayerReplicationInfo!=None )
		{
			Killer.PlayerReplicationInfo.Score -= 1;
		}
	}
	// Scriptedpawn killed ( or maybe even player by scripted pawn).
	else if ( Killer!=None )
	{
		if ( DamageType=='KnockedOut' || DamageType=='Stunned' )
		{
			if ( Killer.PlayerReplicationInfo!=None )	
				Killer.PlayerReplicationInfo.Streak += 1; // Streak is used for knocked out.
		}
		else
		{
			Killer.KillCount++;
			if ( Killer.PlayerReplicationInfo!=None )
				Killer.PlayerReplicationInfo.Score += 1;
		}
	}

	ScoreKill( Killer, Other );
}

// ----------------------------------------------------------------------------
// ScoreKill()
// ----------------------------------------------------------------------------

function ScoreKill( Pawn Killer, Pawn Other )
{
	BaseMutator.ScoreKill( Killer, Other );
}

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

function Tick( float DeltaTime )
{
	Super.Tick( DeltaTime );
}

// ----------------------------------------------------------------------------
// GrantAugs()
// ----------------------------------------------------------------------------

function GrantAugs( HXPlayerPawn Player, int MissionLevel )
{
	Player.GrantAugs( MissionLevel );
}

// ----------------------------------------------------------------------------
// GrantAugUpgrades()
// ----------------------------------------------------------------------------

function GrantAugUpgrades( HXPlayerPawn Player, int NumAugUps )
{
	Player.GrantAugUpgrades( NumAugUps );
}

// ----------------------------------------------------------------------------
// RefreshScoreArray()
// ----------------------------------------------------------------------------

simulated function RefreshScoreArray( HXPlayerPawn Player )
{
	local PlayerReplicationInfo lpri;
	local PlayerPawn pp;
	local int i;

	pp = player.GetPlayerPawn();
	if ( pp == None )
		return;

	scorePlayers = 0;

	for ( i = 0; i < 32; i++ )
	{
		if ( pp.GameReplicationInfo.PRIArray[i] != None )
		{
			lpri = pp.GameReplicationInfo.PRIArray[i];
			if ( !lpri.bIsSpectator || lpri.bWaitingPlayer )
			{
				scoreArray[scorePlayers].PlayerName = lpri.PlayerName;
				scoreArray[scorePlayers].score = lpri.Score;
				scoreArray[scorePlayers].deaths = lpri.Deaths;
				scoreArray[scorePlayers].streak = lpri.Streak;
				scoreArray[scorePlayers].team = lpri.Team;
				scoreArray[scorePlayers].PlayerID = lpri.PlayerID;
				scorePlayers += 1;
				if ( scorePlayers == ArrayCount(scoreArray) )
					break;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// SortScores()
// ----------------------------------------------------------------------------

simulated function SortScores()
{
	local PlayerReplicationInfo tmpri;
	local int i, j, max;
	local ScoreElement tmpSE;
	
	for ( i = 0; i < scorePlayers-1; i++ )
	{
		max = i;
		for ( j = i+1; j < scorePlayers; j++ )
		{
			if ( scoreArray[j].score > scoreArray[max].score )
				max = j;
			else if (( scoreArray[j].score == scoreArray[max].score) && (scoreArray[j].deaths < scoreArray[max].deaths))
				max = j;
		}
		tmpSE = scoreArray[max];
		scoreArray[max] = scoreArray[i];
		scoreArray[i] = tmpSE;
	}
}

// ----------------------------------------------------------------------------
// DrawNameAndScore()
// ----------------------------------------------------------------------------

simulated function DrawNameAndScore( GC gc, ScoreElement se, float screenWidth, float yoffset )
{
	local float x, w, h, w2, xoffset, killcx, deathcx, streakcx;
	local String str;
	
	// Draw Name
	str = se.PlayerName;
	gc.GetTextExtent( 0, w, h, str );
	x = screenWidth * PlayerX;
	gc.DrawText( x, yoffset, w, h, str );

	// Draw Kills
	str = "00";
	gc.GetTextExtent( 0, w, h, KillsString );
	killcx = screenWidth * KillsX + w * 0.5;
	gc.GetTextExtent( 0, w, h, str );
	str = int(se.Score) $ "";
	gc.GetTextExtent( 0, w2, h, str );
	x = killcx + (w * 0.5) - w2;
	gc.DrawText( x, yoffset, w2, h, str );

	// Draw KnockedOut (Uses former position of deaths).
	gc.GetTextExtent( 0, w2, h, KnockedOutString );
	streakcx = screenWidth * DeathsX + w2 * 0.5;
	str = int(se.Streak) $ "";
	gc.GetTextExtent( 0, w2, h, str );
	x = streakcx + (w * 0.5) - w2;
	gc.DrawText( x, yoffset, w2, h, str );

	// Draw Deaths (Uses former position of streak).
	gc.GetTextExtent( 0, w2, h, DeathsString );
	deathcx = screenWidth * StreakX + w2 * 0.5;
	str = int(se.Deaths) $ "";
	gc.GetTextExtent( 0, w2, h, str );
	x = deathcx + (w * 0.5) - w2;
	gc.DrawText( x, yoffset, w2, h, str );
}

// ----------------------------------------------------------------------------
// DrawHeaders()
// ----------------------------------------------------------------------------

simulated function DrawHeaders( GC gc, float screenWidth, float yoffset )
{
	local float x, w, h, barLen;

	// Player header
	gc.GetTextExtent( 0, w, h, PlayerString );
	x = screenWidth * PlayerX;
	gc.DrawText( x, yoffset, w, h, PlayerString );

	// Kills header
	gc.GetTextExtent( 0, w, h, KillsString );
	x = screenWidth * KillsX;
	gc.DrawText( x, yoffset, w, h, KillsString );

	// KnockedOut header (Uses former position of deaths).
	gc.GetTextExtent( 0, w, h, KnockedOutString );
	x = screenWidth * DeathsX;
	gc.DrawText( x, yoffset, w, h, KnockedOutString );

	// Deaths header (Uses former position of streak).
	gc.GetTextExtent( 0, w, h, DeathsString );
	x = screenWidth * StreakX;
	gc.DrawText( x, yoffset, w, h, DeathsString );

	gc.SetTileColorRGB(255,255,255);
	gc.DrawBox( PlayerX * screenWidth, yoffset+h, (x + w)-(PlayerX*screenWidth), 1, 0, 0, 1, Texture'Solid');
}

// ----------------------------------------------------------------------------
// ShowScoreboard()
// ----------------------------------------------------------------------------

simulated function ShowScoreboard( HXPlayerPawn thisPlayer, GC gc, float screenWidth, float screenHeight )
{
	local float yoffset, ystart, xlen, ylen;
	local String str;
	local bool bLocalPlayer;
	local int i;

	if ( !thisPlayer.PlayerIsClient() )
		return;

	gc.SetFont(Font'FontMenuSmall');

	RefreshScoreArray( thisPlayer );

	SortScores();

	str = "TEST";
	gc.GetTextExtent( 0, xlen, ylen, str );

	ystart = screenHeight * PlayerY;
	yoffset = ystart;

	gc.SetTextColor( WhiteColor );
	yoffset += (ylen * 2.0);
	DrawHeaders( gc, screenWidth, yoffset );
	yoffset += (ylen * 1.5);

	for ( i = 0; i < scorePlayers; i++ )
	{
		bLocalPlayer = (scoreArray[i].PlayerID == thisPlayer.PlayerReplicationInfo.PlayerID);

		if ( bLocalPlayer )
			gc.SetTextColor( GoldColor );
		else
			gc.SetTextColor( WhiteColor );

		yoffset += ylen;
		DrawNameAndScore( gc, scoreArray[i], screenWidth, yoffset );
	}
}

// ----------------------------------------------------------------------------
// GetBeaconText()
//
// Return beacon text for server.
// ----------------------------------------------------------------------------

event string GetBeaconText()
{
	local string Result;
	Result = Super.GetBeaconText();
	Result = Result $ " (" $ NumPlayers $ "/" $ MaxPlayers $ ")";
	return Result;
}

// ---------------------------------------------------------------------
// GetInfo()
// ---------------------------------------------------------------------

function string GetInfo()
{
	return Super.GetInfo();
}

// ---------------------------------------------------------------------
// GetRules()
// ---------------------------------------------------------------------

function string GetRules()
{
	local String ResultSet;

	// Because GamePassword is private.
	ResultSet = Super.GetRules();
	
	// Friendly Fire.
	ResultSet = ResultSet $ "\\friendlyfire\\" $ RuleFloat(FriendlyFire);

	// Difficulty.
	ResultSet = ResultSet $ "\\Difficulty\\" $ GetDifficultyName(Difficulty);

	// Skill Point Penalty.
	ResultSet = ResultSet $ "\\SkillPointPenalty\\" $ RuleFloat(SkillPointPenalty);

	// Starting Augmentation level.
	ResultSet = ResultSet $ "\\StartingAugBonus\\" $ StartingAugBonus;

	// Starting Augmentation upgrades.
	ResultSet = ResultSet $ "\\StartingAugUpgradesBonus\\" $ StartingAugUpgradesBonus;

	// Starting Skill Points.
	if ( Steve!=None )
		ResultSet = ResultSet $ "\\SkillPointsTotal\\" $ Steve.SkillPointsTotal;

	return ResultSet;
}

// ---------------------------------------------------------------------
// RuleFloat()
// ---------------------------------------------------------------------

function String RuleFloat( float f )
{
	local String Result;
	
	Result = String(f);
	while ( Right(Result,1)=="0" )
		Result = Left(Result,Len(Result)-1);

	if ( Right(Result,1)=="." )
		Result = Result $ "0";

	return Result;
}

// ---------------------------------------------------------------------
// ResetNonCustomizableOptions()
// Stub for sub gametypes to keep people from changing things in the configs.
// ---------------------------------------------------------------------

function ResetNonCustomizableOptions()
{
}

// ----------------------------------------------------------------------
// ClientPlayerPossessed()
// ----------------------------------------------------------------------

function ClientPlayerPossessed(PlayerPawn CheckPlayer)
{
	CheckPlayerWindow(CheckPlayer);
	CheckPlayerConsole(CheckPlayer);
	CheckPlayerGameEngine(CheckPlayer);
}

// ----------------------------------------------------------------------
// CheckPlayerWindow()
// ----------------------------------------------------------------------

function CheckPlayerWindow(PlayerPawn CheckPlayer)
{
	if (HXPlayerPawn(CheckPlayer) != None)
		HXPlayerPawn(CheckPlayer).VerifyRootWindow( Class'HX.HXRootWindow' );
}

// ----------------------------------------------------------------------
// CheckPlayerConsole()
// ----------------------------------------------------------------------
function CheckPlayerConsole(PlayerPawn CheckPlayer)
{
	if (HXPlayerPawn(CheckPlayer) != None)
		HXPlayerPawn(CheckPlayer).VerifyConsole(Class'HX.HXConsole');
}

// ----------------------------------------------------------------------
// CheckPlayerEngine()
// ----------------------------------------------------------------------

function CheckPlayerGameEngine(PlayerPawn CheckPlayer)
{ 
	if (HXPlayerPawn(CheckPlayer) != None)
		HXPlayerPawn(CheckPlayer).VerifyGameEngine( "HX.HXGameEngine" );
}

// ----------------------------------------------------------------------
// FailRootWindowCheck()
// ----------------------------------------------------------------------

function FailRootWindowCheck(PlayerPawn FailPlayer)
{
	if (HXPlayerPawn(FailPlayer) != None)
		HXPlayerPawn(FailPlayer).ForceDisconnect("Invalid RootWindow class, disconnecting");
}

// ----------------------------------------------------------------------
// FailConsoleCheck()
// ----------------------------------------------------------------------

function FailConsoleCheck(PlayerPawn FailPlayer)
{
	if (HXPlayerPawn(FailPlayer) != None)
		HXPlayerPawn(FailPlayer).ForceDisconnect("Invalid Console class, disconnecting");
}

// ----------------------------------------------------------------------
// FailGameEngineCheck()
// ----------------------------------------------------------------------

function FailGameEngineCheck(PlayerPawn FailPlayer)
{
	if (HXPlayerPawn(FailPlayer) != None)
		HXPlayerPawn(FailPlayer).ForceDisconnect( "Invalid GameEngine class, disconnecting" );
}

// ---------------------------------------------------------------------
// ChangeTeam()
// ---------------------------------------------------------------------

function bool ChangeTeam( Pawn PawnToChange, int NewTeam )
{
	return Super.ChangeTeam(PawnToChange,NewTeam);
}

// ---------------------------------------------------------------------
// CanSpectate()
// ---------------------------------------------------------------------

function bool CanSpectate( pawn Viewer, actor ViewTarget )
{
	return False;
}

// ----------------------------------------------------------------------------
// ProcessServerTravel().
//
// Optional handling of ServerTravel for network games.
// ----------------------------------------------------------------------------

function ProcessServerTravel( string URL, bool bItems )
{
	local HXComputers comp;
	local HXScriptedPawn pawn;
	local playerpawn P, LocalPlayer;
	local HXMissionScript Scr;

	// Close out any computer screens
	foreach AllActors( class'HXComputers', comp )
	{
		if ((comp != None ) && ( comp.curFrobber != None ))
		{
			// This is for the client
			comp.curFrobber.HXCloseThisComputer( comp );
			// This is for the server
			comp.curFrobber.HXCloseComputerScreen( comp );
		}
	}

	// Close out any scriptedpawns
	foreach AllActors( class'HXScriptedPawn', pawn )
	{
		if ((pawn != None ) && ( pawn.curFrobber != None ))
		{
			// This is for the client
			pawn.curFrobber.CloseThisPawn( pawn );
			// This is for the server
			pawn.curFrobber.ClosePawn( pawn );
		}
	}

	//Super.ProcessServerTravel( URL, bItems );

	//if (LocalLog != None)
	//{
		//LocalLog.LogGameEnd("mapchange");
		//LocalLog.StopLog();
		//LocalLog.Destroy();
		//LocalLog = None;
	//}

	//if (WorldLog != None)
	//{
		//WorldLog.LogGameEnd("mapchange");
		//WorldLog.StopLog();
		//WorldLog.Destroy();
		//WorldLog = None;
	//}

	// Notify clients we're switching level and give them time to receive.
	// We call PreClientTravel directly on any local PlayerPawns (ie listen server)
	Log("ProcessServerTravel:"@URL);

	// also sets Scr.flags = none
	//foreach AllActors(class'HXMissionScript', Scr)
		//Scr.PreTravel(); 

	if ( MissionScript!=None )
		MissionScript.PreTravel();

	foreach AllActors( class'PlayerPawn', P )
	{
		if ( P.IsA('HXPlayerPawn') )
			HXPlayerPawn(P).PutInHand(None);

		if( NetConnection(P.Player)!=None )
		{
			P.ClientTravel( URL, TRAVEL_Relative, bItems );
		}
		else
		{	
			LocalPlayer = P;
			P.PreClientTravel(); // Uhm, shouldn't ClientTravel() do that?
		}
	}

	if ( (Level.NetMode == NM_ListenServer) && (LocalPlayer != None) )
		Level.NextURL = Level.NextURL
					 //$"?Skin="$LocalPlayer.GetDefaultURL("Skin")
					 //$"?Face="$LocalPlayer.GetDefaultURL("Face")
					 //$"?Team="$LocalPlayer.GetDefaultURL("Team")
					 $"?Name="$LocalPlayer.GetDefaultURL("Name")
					 $"?Class="$LocalPlayer.GetDefaultURL("Class");

	// Switch immediately if not networking.
	if( Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
		Level.NextSwitchCountdown = 0.0;

	FirstNote = None;
	LastNote = None;
}



//
// Examine the passed player's inventory, and accept or discard each item.
// AcceptInventory needs to gracefully handle the case of some inventory
// being accepted but other inventory not being accepted (such as the default
// weapon).  There are several things that can go wrong: A weapon's
// AmmoType not being accepted but the weapon being accepted -- the weapon
// should be killed off. Or the player's selected inventory item, active
// weapon, etc. not being accepted, leaving the player weaponless or leaving
// the HUD inventory rendering messed up (AcceptInventory should pick another
// applicable weapon/item as current).
//
event AcceptInventory(pawn PlayerPawn)
{
	local HXPlayerPawn Human;
	local HXNanoKeyInfo aKey;
	local int PointsSpent;
	local class<HXMissionScript> HXScript;
	local Inventory Inv;

	// First remark all inventory spaces as occupied,
	// skip sanity checks for now
	for ( Inv = HXPlayerPawn(PlayerPawn).Inventory; Inv != None; Inv = Inv.Inventory )
		if ( Inv.bDisplayableInv )
			HXPlayerPawn(PlayerPawn).MarkSpace( Inv.invPosX, Inv.invPosY, Inv.invSlotsX, Inv.invSlotsY, Inv );

	//default accept all inventory except default weapon (spawned explicitly)
	//local inventory inv;
	// Initialize the inventory.
	//AddDefaultInventory( PlayerPawn );
	//log( "All inventory from" @ PlayerPawn.PlayerReplicationInfo.PlayerName @ "is accepted" );

	Human = HXPlayerPawn(PlayerPawn);

	if ( Human == None )
		return;

	if ( Human.HXKeyRing != None )
	{
		Log( "KeyRing found! Not adding default equipment for" $ PlayerPawn, 'DevInventory' );
	
		if ( MissionScript!=None && DeusExLevelInfo!=None )
			MissionScript.AcceptInventory( HXPlayerPawn(PlayerPawn), Steve.Portal, Caps(DeusExLevelInfo.MapName) );

		Human.InitializeSubSystems();
	}
	else
	{
		Log( "KeyRing not found! Adding default equipment for " $ PlayerPawn, 'DevInventory' );

		// Other defaults
		Human.Credits = Human.Default.Credits;
		Human.Energy  = Human.Default.Energy;

		Human.SetInHandPending(None);
		Human.SetInHand(None);

		Human.bInHandTransition = False;

		Human.RestoreAllHealth();

		// Reinitialize all subsystems we've just nuked
		Human.InitializeSubSystems();

		// Give starting inventory.
		//if (Level.Netmode != NM_Standalone)
		//{
			//NintendoImmunityEffect( True );
			Human.GiveInitialInventory();
		//}
	}

	PointsSpent = HXSkillManager(Human.SkillSystem).CalculateSpentSkillPoints();
	
	if ( PointsSpent > Steve.SkillPointsTotal )
	{
		if ( DeusExLevelInfo!= None && Caps(DeusExLevelInfo.MapName)=="00_TRAININGFINAL" )
		{
			// HACK: ignore for training to keep rifle skill at master at 00_TrainingFinal
		}
		else
		{
			Log( Human $ " has " $ PointsSpent $ " SkillPoints spent, but only " $ Steve.SkillPointsTotal $ " are available, resetting Skills." );
			Human.SkillSystem.ResetSkills();
		}
	}

	Human.SkillPointsTotal = Steve.SkillPointsTotal;
	Human.SkillPointsAvail = Steve.SkillPointsTotal - PointsSpent;

	// TODO replicated notes, etc.
}

// ------------------------------------------------------------------------
// GiveInitialInventory()
//
// Reroute to GameInfo.
// ------------------------------------------------------------------------

function GiveInitialInventory( HXPlayerPawn Player )
{
	if ( MissionScript!=None )
		MissionScript.GiveInitialInventory( Player, Steve.Portal, Caps(Level.Outer) );
}

// ----------------------------------------------------------------------------
// ShouldRespawn()
// ----------------------------------------------------------------------------

function bool ShouldRespawn( Actor Other )
{
	return false; // Where I want to go.
	//return true; // Where I'm stuck because of replication issues.
}

// ----------------------------------------------------------------------------
// ModityInventoryClass()
// ----------------------------------------------------------------------------

function ModifyInventoryClass( out Class<Inventory> InventoryClass )
{
	HXBaseMutator.ModifyInventoryClass( InventoryClass );
}

// ----------------------------------------------------------------------------
// ModifyMissionScriptClass()
// ----------------------------------------------------------------------------

function ModifyMissionScriptClass( out Class<MissionScript> MissionScriptClass, Name LevelName )
{
	HXBaseMutator.ModifyMissionScriptClass( MissionScriptClass, LevelName );
}

// ----------------------------------------------------------------------------
// ModifyActorClass()
// ----------------------------------------------------------------------------

function ModifyActorClass( out Class<Actor> ActorClass )
{
	HXBaseMutator.ModifyActorClass( ActorClass );
}

// ----------------------------------------------------------------------------
// CheckCustomCommand()
//
// Interface for handling GameInfo/Mutator specific, but PlayerPawn independent
// commands received from client players.
//
// May not get called, because Mutators have blocked further processing.
// In case you need to handle the command first, override CustomCommand.
//
// Should return whenever this command was handle, so subclases can tell
// whether the parent has handled this command or not.
// ----------------------------------------------------------------------------

function bool CheckCustomCommand( HXPlayerPawn PlayerPawn, string Command )
{
	return false;
}

// ----------------------------------------------------------------------------
// CustomCommand()
//
// Interface for handling GameInfo/Mutator specific, but PlayerPawn independent
// commands received from client players.
//
// Dispatches custom commands to Mutator logic and CheckCustomCommand.
//
// It is recommended to handle your GameInfo specific commands inside
// CheckCustomCommand.
//
// You only should override this function in case you need to handle commands 
// before Mutators or prevents them from handling them.
// ----------------------------------------------------------------------------

function CustomCommand( HXPlayerPawn PlayerPawn, string Command )
{
	local byte bSuperRelevant;

	// Handled by Mutator.
	if ( HXBaseMutator.CustomCommand(PlayerPawn,Command) )
		return;

	CheckCustomCommand( PlayerPawn, Command );
}

// ----------------------------------------------------------------------
// SkillPointsAdd()
// ----------------------------------------------------------------------

function SkillPointsAdd( int NumPoints, String Detail )
{
	local HXPlayerPawn Player;
	local Pawn Pawn;

	// Apply penalty.
	NumPoints *= (1.0-SkillPointPenalty);

	if ( NumPoints>0 )
	{
		Steve.SkillPointsTotal += NumPoints;

		// Grant them every player.
		for( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
		{
			if( Pawn.bIsPlayer )
			{
				Player = HXPlayerPawn(Pawn);
				if ( Player!=None )
				{
					Player.SkillPointsAvail += NumPoints;
					Player.SkillPointsTotal += NumPoints;

					if ( Detail=="" )
						Player.ClientMessage( Sprintf(MsgSkillPointsAward,NumPoints), 'SkillPoints', true );
					else
						Player.ClientMessage( Sprintf(MsgSkillPointsAwardDetail,NumPoints,Detail), 'SkillPoints', true );

					Player.UpdateClientSkillPoints( Player.SkillPointsAvail, Player.SkillPointsTotal );
				}
			}
		}
	}
}

// ----------------------------------------------------------------------
// CreateHXNanoKeyInfo()
// ----------------------------------------------------------------------

function HXNanoKeyInfo CreateHXNanoKeyInfo()
{
	local HXNanoKeyInfo newKey;

	newKey = new(Self) Class'HXNanoKeyInfo';

	return newKey;
}

// ----------------------------------------------------------------------
// PickupNanoKey()
// ----------------------------------------------------------------------

function bool PickupNanoKey(HXNanoKey newKey)
{
	local Pawn P;

	if ( HasKey( newKey.KeyID ) )
		return false;

	GiveKey(newKey.KeyID, newKey.Description);

	return true;
}

// ----------------------------------------------------------------------
// HasKey()
//
// Checks to see if we have the keyname passed in
// ----------------------------------------------------------------------

function bool HasKey(Name KeyToLookFor)
{
	local HXNanoKeyInfo aKey;

	aKey = Steve.KeyList;

	// Loop through all the keys and see if one exists
	while(aKey != None)
	{
		if (aKey.KeyID == KeyToLookFor)
			return true;

		aKey = aKey.NextKey;
	}

	return false;
}

// ----------------------------------------------------------------------
// GiveKey()
//
// Adds a key to our array
// ----------------------------------------------------------------------

function GiveKey( Name newKeyID, String newDescription, optional bool bSilent )
{
	local HXNanoKeyInfo aKey;

	if ( newKeyID=='' )
	{
		Warn( Sprintf("Empty KeyID (KeyDescription=\"%s\",bSilent=%b).",newDescription,bSilent) );
		return;
	}
	if ( newDescription=="" )
	{
		Warn( Sprintf("Empty KeyDescription (KeyID=\"%s\",bSilent=%b).",newKeyID,bSilent) );
	}

	// First check to see if the player already has this key
	if (HasKey(newKeyID))
		return;

	// Spawn a key
	aKey = CreateHXNanoKeyInfo();

	// Set the appropriate fields and 
	// add to the beginning of our list
	aKey.KeyID       = newKeyID;
	aKey.Description = newDescription;
	aKey.NextKey     = Steve.KeyList;
	Steve.KeyList   = aKey;

	if ( NanoKeyReplicationInfo!=None )
		NanoKeyReplicationInfo.AddNanoKey( newDescription );

	if ( !bSilent )
		BroadcastMessage( Sprintf( Class'HXPlayerPawn'.default.AddedNanoKey, newDescription ) );
}

// ----------------------------------------------------------------------
// RemoveKey()
// ----------------------------------------------------------------------

function RemoveKey(Name KeyToRemove)
{
	local HXNanoKeyInfo aKey;
	local HXNanoKeyInfo lastKey;

	aKey = Steve.KeyList;
		
	// Loop through all the keys and see if one exists
	while(aKey != None)
	{
		if (aKey.KeyID == KeyToRemove)
		{
			if (lastKey != None)
				lastKey.NextKey = aKey.NextKey;

			if (Steve.KeyList == aKey)
				Steve.KeyList = aKey.NextKey;

			NanoKeyReplicationInfo.RemoveNanoKey( aKey.Description );
			CriticalDelete(aKey);
			aKey = None;

			break;
		}
		
		lastKey = aKey;
		aKey    = aKey.NextKey;
	}
}

// ----------------------------------------------------------------------
// RemoveAllKeys()
// ----------------------------------------------------------------------

function RemoveAllKeys()
{
	local HXNanoKeyInfo aKey;
	local HXNanoKeyInfo deadKey;
	
	aKey = Steve.KeyList;

	// Loop through all the keys and see if one exists
	while(aKey != None)
	{
		deadKey = aKey;

		CriticalDelete(aKey);
		aKey = None;

		aKey = deadKey.NextKey;
	}

	Steve.KeyList = None;
}


// ----------------------------------------------------------------------
// AddNote()
//
// Adds a new note to the list of notes the player is carrying around.
// ----------------------------------------------------------------------

function AddNote( optional String strNote, optional Bool bUserNote, optional bool bShowInLog, optional Name textTag )
{
	local DeusExNote newNote;
	local HXPlayerPawn PlayerPawn;
	local Pawn Pawn;
	
	// Only add TextTag'ed notes once.
	if ( TextTag!='' && GetNote(TextTag)!=None )
		return;

	// None as Outer creates it under GObjTransientPkg.
	newNote = new(None,'',RF_Transient) Class'DeusExNote';

	newNote.text = strNote;
	newNote.SetUserNote( bUserNote );
	newNote.SetTextTag(textTag);

	//Log( "AddNote() stats:" );
	//Log( "Len( strNote ) =" $ Len( strNote ) );
	//Log( "Len( textTag ) =" $ Len( textTag ) );

	// Insert this new note at the top of the notes list
	if (FirstNote == None)
		LastNote  = newNote;
	else
		newNote.next = FirstNote;

	FirstNote = newNote;

	// Propagate to clients.
	for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
	{
		if ( !Pawn.bIsPlayer )
			continue;
		
		PlayerPawn = HXPlayerPawn(Pawn);
		if ( PlayerPawn==None )
			continue;

		if ( bShowInLog )
			PlayerPawn.ClientMessage( MsgNoteAdded, 'NoteAdded', true );
		PlayerPawn.ClientAddNote( StrNote, bUserNote, TextTag );
	}
}

// ----------------------------------------------------------------------
// GetNote()
//
// Loops through the notes and searches for the TextTag passed in
// ----------------------------------------------------------------------

function DeusExNote GetNote(Name textTag)
{
	local DeusExNote note;

	note = FirstNote;
		
	while( note != None )
	{
		if (note.textTag == textTag)
			break;

		note = note.next;
	}

	return note;
}

// ----------------------------------------------------------------------
// DeleteNote()
//
// Deletes the specified note
// Returns True if the note successfully deleted
// ----------------------------------------------------------------------

function Bool DeleteNote( DeusExNote noteToDelete )
{
	local DeusExNote note;
	local DeusExNote previousNote;
	local Bool bNoteDeleted;

	bNoteDeleted = False;
	note = FirstNote;
	previousNote = None;

	while( note != None )
	{
		if ( note == noteToDelete )
		{
			if ( note == FirstNote )
				FirstNote = note.next;

			if ( note == LastNote )
				LastNote = previousNote;

			if ( previousNote != None )
				previousNote.next = note.next;

			note = None;
						
			bNoteDeleted = True;	
			break;
		}
		previousNote = note;
		note = note.next;
	}

	return bNoteDeleted;
}

// ----------------------------------------------------------------------
// DeleteAllNotes()
//
// Deletes *ALL* Notes
// ----------------------------------------------------------------------

function DeleteAllNotes()
{
	local DeusExNote note;
	local DeusExNote noteNext;
	local Pawn P;

	note = FirstNote;

	while( note != None )
	{
		noteNext = note.next;
		DeleteNote(note);
		note = noteNext;
	}

	FirstNote = None;
	LastNote = None;

	// propagate
	for( P = Level.PawnList; P != None; P = P.nextPawn )
	{
		if( P.bIsPlayer && P.isA('HXPlayerPawn') )
		{
			HXPlayerPawn(P).ClientDeleteAllNotes();
		}
	}
}

// ----------------------------------------------------------------------------
// AddGoal()
//
// Adds a new goal to the list of goals the player is carrying around.
// ----------------------------------------------------------------------------

function AddGoal( Name goalName, bool bPrimaryGoal, string goalText )
{	
	local HXPlayerPawn PlayerPawn;
	local Pawn Pawn;
	local HXGoal newGoal;

	//Log( Self $ ".AddGoal( " $ goalName $ ", " $ bPrimaryGoal $ ", " $ goalText $ " ) ");

	// First check to see if this goal already exists.  If so, we'll just
	// return it.  Otherwise create a new goal

	newGoal = FindGoal( goalName );

	if ( newGoal == None )
	{
		newGoal = new(Self) Class'HXGoal';
		newGoal.SetName( goalName );

		// Insert goal at the Top so goals are displayed in 
		// Newest order first.
		newGoal.next = Steve.FirstGoal;

		Steve.FirstGoal    = newGoal;

		newGoal.SetPrimaryGoal( bPrimaryGoal );
		newGoal.SetText( goalText );
		newGoal.bCompleted = false;
	}

	// Propagate to clients.
	for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
	{
		if ( !Pawn.bIsPlayer )
			continue;
		
		PlayerPawn = HXPlayerPawn(Pawn);
		if ( PlayerPawn==None )
			continue;

		PlayerPawn.ClientMessage( MsgGoalAdded, 'GoalAdded', true );
		PlayerPawn.ClientAddGoal( GoalName, bPrimaryGoal, GoalText, false );
	}
}

// ----------------------------------------------------------------------------
// FindGoal()
// ----------------------------------------------------------------------------

function HXGoal FindGoal( Name goalName )
{
	local HXGoal goal;

	goal = Steve.FirstGoal;

	while( goal != None )
	{
		if ( goalName == goal.goalName )
			break;

		goal = goal.next;
	}

	return goal;
}

// ----------------------------------------------------------------------------
// GoalCompleted()
//
// Looks up the goal and marks it as completed.
// ----------------------------------------------------------------------------

function GoalCompleted( Name GoalName )
{
	local HXGoal Goal;
	local HXPlayerPawn PlayerPawn;
	local Pawn Pawn;

	Log( Sprintf("GameInfo: GoalCompleted (Name=%s).",GoalName), 'DevGoals' );

	Goal = FindGoal( goalName );

	if ( Goal==None )
		return;

	// Do all the notify logic once.
	if ( Goal.IsCompleted() )
		return;

	// Prevent ever getting notified about this goal again.
	Goal.SetCompleted();

	// Propagate to clients.
	for ( Pawn=Level.PawnList; Pawn!=None; Pawn=Pawn.NextPawn )
	{
		if ( !Pawn.bIsPlayer )
			continue;
		
		PlayerPawn = HXPlayerPawn(Pawn);
		if ( PlayerPawn==None )
			continue;

		if ( Goal.bPrimaryGoal )
			PlayerPawn.ClientMessage( MsgPrimaryGoalCompleted, 'GoalCompleted', true );
		else
			PlayerPawn.ClientMessage( MsgSecondaryGoalCompleted, 'GoalCompleted', true );

		PlayerPawn.ClientGoalCompleted( GoalName );
	}
}

// ----------------------------------------------------------------------------
// IsGoalCompleted()
//
// Looks up the goal check whether it's completed.
// ----------------------------------------------------------------------------

function bool IsGoalCompleted( name GoalName, optional out byte bFound )
{
	local HXGoal Goal;
	local Pawn P;

	//Log( Self $ ".GoalCompleted( " $ goalName $ " )" );

	// Loop through all the goals until we hit the one we're 
	// looking for.
	Goal = FindGoal( GoalName );

	if ( Goal!=None )
	{
		bFound = 1;
		return Goal.IsCompleted();
	}
	else
	{
		bFound = 0;
		return false;
	}
}

// ----------------------------------------------------------------------------
// DeleteGoal()
//
// Deletes the specified goal. Returns True if found and deleted.
// ----------------------------------------------------------------------------

function bool DeleteGoal( HXGoal DeleteGoal )
{
	local HXGoal Goal, PrevGoal;

	PrevGoal = None;
	Goal     = Steve.FirstGoal;

	while ( Goal!=None )
	{
		if ( Goal==DeleteGoal )
		{
			if ( Goal==Steve.FirstGoal )
				Steve.FirstGoal = Goal.Next;
			if ( PrevGoal!=None )
				PrevGoal.Next = Goal.Next;

			Goal.Next = None;
			return true;
		}

		PrevGoal = Goal;
		Goal     = Goal.Next;
	}

	return false;
}

// ----------------------------------------------------------------------------
// DeleteGoalByName()
//
// Deletes the specified goal by name. Returns True if found and deleted.
// ----------------------------------------------------------------------------

function bool DeleteGoalByName( name DeleteGoalName )
{
	local HXGoal Goal, PrevGoal;
	local Pawn P;

	// Propagate.
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && P.isA('HXPlayerPawn') )
			HXPlayerPawn(P).ClientDeleteGoalByName( DeleteGoalName );

	PrevGoal = None;
	Goal     = Steve.FirstGoal;

	while ( Goal!=None )
	{
		if ( Goal.GoalName==DeleteGoalName )
		{
			if ( Goal==Steve.FirstGoal )
				Steve.FirstGoal = Goal.Next;
			if ( PrevGoal!=None )
				PrevGoal.Next = Goal.Next;

			Goal.Next = None;
			return true;
		}

		PrevGoal = Goal;
		Goal     = Goal.Next;
	}

	return false;
}

// ----------------------------------------------------------------------------
// DeleteAllGoals()
//
// Deletes *ALL* Goals
// ----------------------------------------------------------------------------

function DeleteAllGoals()
{
	local HXGoal goal;
	local HXGoal goalNext;
	local Pawn P;

	goal = Steve.FirstGoal;

	while( goal != None )
	{
		goalNext = goal.next;
		DeleteGoal(goal);
		goal = goalNext;
	}

	Steve.FirstGoal = None;

	// Propagate.
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && P.isA('HXPlayerPawn') )
			HXPlayerPawn(P).ClientDeleteAllGoals();
}

// ----------------------------------------------------------------------------
// ResetGoals()
// 
// Called when progressing to the next mission.  Deletes all 
// completed Primary Goals as well as *ALL* Secondary Goals 
// (regardless of status)
// ----------------------------------------------------------------------------

function ResetGoals()
{
	local HXGoal goal;
	local HXGoal goalNext;
	local Pawn P;

	goal = Steve.FirstGoal;

	while( goal != None )
	{
		goalNext = goal.next;

		// Delete:
		// 1) Completed Primary Goals
		// 2) ALL Secondary Goals

		if ((!goal.IsPrimaryGoal()) || (goal.IsPrimaryGoal() && goal.IsCompleted()))
			DeleteGoal(goal);

		goal = goalNext;
	}

	// Propagate.
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && P.isA('HXPlayerPawn') )
			HXPlayerPawn(P).ClientResetGoals();
}

// ----------------------------------------------------------------------
// AddImageClass()
// ----------------------------------------------------------------------

function bool AddImage( class<DataVaultImage> ImageClass, optional bool bAnnotate )
{
	local int i;

	if ( ImageClass==None )
		return False;

	// Return false if we already have this image.
	for ( i=0; i<ArrayCount(Steve.DataVaultImages); i++ )
		if ( ImageClass==Steve.DataVaultImages[i] )
			return False;

	// Put it in the first free slot.
	for ( i=0; i<ArrayCount(Steve.DataVaultImages); i++ )
	{
		if ( Steve.DataVaultImages[i]==None )
		{
			Steve.DataVaultImages[i] = ImageClass;
			break;
		}
	}
	if ( i==ArrayCount(Steve.DataVaultImages) )
		Warn( "Failed to add DataVaultImage because Steve.DataVaultImages is full." );

	// Notify clients of new image.
	if ( bAnnotate )
		BroadcastMessage( Sprintf(AddedToDatavaultLabel,ImageClass.Default.ImageDescription) );

	// Add image to ImageReplicationInfo.
	if ( ImageReplicationInfo!=None )
		ImageReplicationInfo.AddImage( ImageClass );

	return True;
}

// ----------------------------------------------------------------------
// CreateLogObject()
//
// Hope i don't miss anything
// ----------------------------------------------------------------------

function DeusExLog CreateLogObject()
{
	local DeusExLog newLog;

	//Log("HXGameInfo.CreateLogObject() called");

	// None as Outer creates it under GObjTransientPkg.
	newLog = new(None,'',RF_Transient) Class'DeusExLog';

	return newLog;
}

// ----------------------------------------------------------------------
// AddLog()
//
// Adds a log message to our FirstLog linked list
// ----------------------------------------------------------------------

function AddLog(String logText)
{
	local DeusExLog newLog;
	local Pawn P;

	newLog = CreateLogObject();
	newLog.SetLogText(logText);

	// Add this Note to the list of player Notes
	if ( FirstLog != None )
		LastLog.next = newLog;
	else
		FirstLog = newLog;

	LastLog = newLog;

	// propagate
	for( P = Level.PawnList; P != None; P = P.nextPawn )
	{
		if( P.bIsPlayer && P.isA('HXPlayerPawn') )
		{
			HXPlayerPawn(P).ClientAddLog( logText );
		}
	}
}

// ----------------------------------------------------------------------
// ClearLog()
//
// Removes log objects
// ----------------------------------------------------------------------

function ClearLog()
{
	local DeusExLog log;
	local DeusExLog nextLog;
	local Pawn P;

	log = FirstLog;

	while( log != None )
	{
		nextLog = log.next;
		log.next = None; // Just to be safe.
		CriticalDelete(log);
		log = nextLog;
	}

	FirstLog = None;
	LastLog  = None;

	// propagate
	for( P = Level.PawnList; P != None; P = P.nextPawn )
	{
		if( P.bIsPlayer && P.isA('HXPlayerPawn') )
		{
			HXPlayerPawn(P).ClientClearLog();
		}
	}
}

// ----------------------------------------------------------------------
// HasAIBarkConversation()
//
// Checks for a Bark Conversation, so this ScriptedPawn can cache and 
// avoid trying to play Barks which aren't available anyway.
// ----------------------------------------------------------------------

function bool HasAIBarkConversation( HXScriptedPawn ConOwner, EBarkModes BarkMode )
{
	//Log( "HasAIBarkConversation() called" );
	return BarkManager.HasBark( ConOwner, BarkMode );
}

// ----------------------------------------------------------------------
// StartAIBarkConversation()
//
// Starts an AI Bark conversation, which really isn't a conversation as much as a simple bark.  
// ----------------------------------------------------------------------

function bool StartAIBarkConversation( HXScriptedPawn ConOwner, EBarkModes BarkMode )
{
	local Name ConFutzName;
	//Log( "StartAIBarkConversation() called" );

	if ( ConOwner==None || ConOwner.ConListItems==None ||	(ConPlay!=None && ConPlay.Con!=None && !ConPlay.Con.bFirstPerson) )
		return False;

	// Sort of nasty, but better here than inside HXScriptedPawn.
	if ( BarkMode==BM_Futz )
	{
		ConFutzName = BarkManager.BuildBarkName( ConOwner, BM_Futz );
		return StartConversationByName( None, ConFutzName, ConOwner, !ConOwner.bInterruptState );
	}

	return BarkManager.StartBark( ConOwner, BarkMode );
}

// ----------------------------------------------------------------------
// AbortConversation()
// ----------------------------------------------------------------------

function AbortConversation( optional bool bNoPlayedFlag )
{
	if ( ConPlay!=None )
		ConPlay.TerminateConversation( False, bNoPlayedFlag );
}

// ----------------------------------------------------------------------
// StartConversationByName()
//
// Starts a conversation by looking for the name passed in.  
//
// Calls StartConversation() if a match is found.
// ----------------------------------------------------------------------

function bool StartConversationByName(
	HXPlayerPawn PassedInPlayer,
	Name conName, 
	Actor conOwner, 
	optional bool bAvoidState, 
	optional bool bForcePlay
	)
{
	local ConListItem conListItem;
	local Conversation con;
	local float  dist, TempDist;
	local Bool bConversationStarted;
	local Pawn  P;

	bConversationStarted = False;

	if (conOwner == None)
		return False;

	conListItem = ConListItem(conOwner.conListItems);

	while( conListItem != None )
	{
		if ( conListItem.con.conName == conName )
		{
			con = conListItem.con;			
			break;
		}

		conListItem = conListItem.next;
	}

	// Now check to see that we're in a respectable radius.
	if (con != None)
	{
		if ( PassedInPlayer != None )
		{
			dist = VSize(PassedInPlayer.Location - conOwner.Location);

			// 800 = default sound radius, from unscript.cpp
			// 
			// If "bForcePlay" is set, then force the conversation
			// to play!

			if ((dist <= 800.0) || (bForcePlay))
				bConversationStarted = StartConversation( PassedInPlayer, conOwner, IM_Named, con, bAvoidState, bForcePlay );
		}
		else
		{
			// HX: Try finding a player where we could start the conversation
			for( P = Level.PawnList; P != None; P = P.nextPawn )
			{
				if( P.bIsPlayer && P.IsA('HXPlayerPawn') )
				{
					dist = VSize( P.Location - conOwner.Location );

					if ((dist <= 800.0) || (bForcePlay))
						bConversationStarted = StartConversation( HXPlayerPawn(P), conOwner, IM_Named, con, bAvoidState, bForcePlay );

					if ( bConversationStarted )
						break;
				}
			}
		}
	}

	return bConversationStarted;
}

// ----------------------------------------------------------------------
// StartCinematic()
//
// Starts a cinematic conversation
// ----------------------------------------------------------------------

function bool StartCinematicByName( Name conName, Actor conOwner )
{
	local ConListItem conListItem;
	local Conversation con;

	if (conOwner == None)
		return False;

	conListItem = ConListItem(conOwner.conListItems);

	while( conListItem != None )
	{
		if ( conListItem.con.conName == conName )
		{
			con = conListItem.con;			
			break;
		}

		conListItem = conListItem.next;
	}

	if (con != None)
		return StartCinematic( conOwner, con );
	else
		return false;
}


// ----------------------------------------------------------------------
// StartCinematic()
// 
// Checks to see if a valid conversation exists for this moment in time
// between the ScriptedPawn and the PC.  If so, then it triggers the 
// conversation system and returns TRUE when finished.
// ----------------------------------------------------------------------

function bool StartCinematic( Actor invokeActor, optional Conversation con )
{
	local HXPlayerPawn PassedInPlayer;
	local bool bAvoidState;
	local bool bForcePlay;
	local EInvokeMethod invokeMethod;

	bAvoidState = False;
	bForcePlay = True;
	invokeMethod = IM_Named;

	Log( "=========================================================================" );
	Log( Self $ ".StartCinematic( " $ invokeActor $ ", " $ con $ " ) called." );
	Log( "=========================================================================" );

	//if ((!bForcePlay) && ((invokeActor.conListItems == None) || (!CanGameStartConversation())))
	if ( invokeActor.conListItems == None )
		return False;

	Log( "Passed: if ( invokeActor.conListItems == None )" );

	if ( con == None )
		con = GetActiveConversation( PassedInPlayer, invokeActor, invokeMethod );

	Log( "con = " $ con );

	// If we have a conversation, put the actor into "Conversation Mode".
	// Otherwise just return false.
	//
	// TODO: Scan through the conversation and put *ALL* actors involved
	//       in the conversation into the "Conversation" state??

	if ( con != None )
	{
		// Check to see if this conversation is already playing.  If so,
		// then don't start it again.  This prevents a multi-bark conversation
		// from being abused.
		if ((conPlay != None) && (conPlay.con == con))
			return False;

		// Found an active conversation, so start it
		conPlay = Spawn(class'HXCinematicPlay');
		conPlay.SetStartActor( invokeActor );
		conPlay.SetConversation( con );
		conPlay.SetForcePlay( True );

		// hopefully this is huge enough
		conPlay.SetInitialRadius( 20000.0 );
		conPlay.SetOriginalRadius(con.radiusDistance);
		con.radiusDistance = 20000.0;

		// If the invoking actor is a ScriptedPawn, then force this person 
		// into the conversation state
		if ((!bForcePlay) && (ScriptedPawn(invokeActor) != None ))
			ScriptedPawn(invokeActor).EnterConversationState(con.bFirstPerson, bAvoidState);

		// Do the same if this is a HXDecoration
		if ((!bForcePlay) && (HXDecoration(invokeActor) != None ))
			HXDecoration(invokeActor).EnterConversationState(con.bFirstPerson, bAvoidState);

		// If this is a third-person convo, we're pretty much going to 
		// pause the game.  If this is a first-person convo, then just 
		// keep on going..
		//
		// If this is a third-person convo *AND* 'bForcePlay' == True, 
		// then use first-person mode, as we're playing an intro/endgame
		// sequence and we can't have the player in the convo state (bad bad bad!)

		if ( !HXCinematicPlay(conPlay).StartCinematic(InvokeActor) )
		{
			AbortConversation(True);

			Log( "==============================  False  =================================" );

			return False;
		}
	}

	Log( "==============================  True  ==================================" );

	return True;
}

// ----------------------------------------------------------------------
// IsSpeakingActorByBindName()
//
// HX_NOTE: copied and modified from Conversation
//
// Looks to see if the actor passed in is even involved in this
// conversation.  Returns True if the actor has a speaking part.
// ----------------------------------------------------------------------

function Bool IsSpeakingActorByBindName(Conversation con, string speakingActorBindName)
{
	local bool bSpeaking;
	local ConEventSpeech eventSpeech;
	local ConEvent event;

	event = con.eventList;

	while(event != None)
	{
		eventSpeech = ConEventSpeech(event);
		if (eventSpeech != None)
		{
			if ((eventSpeech.speakerName == speakingActorBindName) || (eventSpeech.speakingToName == speakingActorBindName))
			{
				bSpeaking = True;
				break;
			}
		}
		event = event.nextEvent;
	}

	return bSpeaking;
}

// ----------------------------------------------------------------------
// StartConversation()
// 
// Checks to see if a valid conversation exists for this moment in time
// between the ScriptedPawn and the PC.  If so, then it triggers the 
// conversation system and returns TRUE when finished.
// ----------------------------------------------------------------------

function bool StartConversation(
	HXPlayerPawn PassedInPlayer,
	Actor invokeActor, 
	EInvokeMethod invokeMethod, 
	optional Conversation con,
	optional bool bAvoidState,
	optional bool bForcePlay
	)
{
//	local HXRootWindow root;
//	root = HXRootWindow(rootWindow);

	//Log( "=========================================================================", 'DevConPlay' );
	//Log( Self $ ".StartConversation( " $ PassedInPlayer $ ", " $ invokeActor $ ", " $ invokeMethod $ ", " $ con $ ", " $ bAvoidState $ ", " $ bForcePlay $ " ) called.", 'DevConPlay' );
	//Log( "=========================================================================", 'DevConPlay' );

	// First check to see the actor has any conversations or if for some
	// other reason we're unable to start a conversation (typically if 
	// we're alread in a conversation or there's a UI screen visible)

//	if ((!bForcePlay) && ((invokeActor.conListItems == None) || (!CanStartConversation())))
//		return False;

	// Make sure the other actor can converse
//	if ((!bForcePlay) && ((ScriptedPawn(invokeActor) != None) && (!ScriptedPawn(invokeActor).CanConverse())))
//		return False;

	if ((!bForcePlay) && ((invokeActor.conListItems == None) || (!CanGameStartConversation())))
		return False;

	//Log( "Passed: if ((!bForcePlay) && ((invokeActor.conListItems == None) || (!CanGameStartConversation())))", 'DevConPlay' );

	// see if passed in player is ok
	if ( PassedInPlayer != None && !CanPlayerStartConversation( PassedInPlayer ) )
		return False;

	//Log( "Passed: if ( PassedInPlayer != None && !CanPlayerStartConversation( PassedInPlayer ) )", 'DevConPlay' );

	// !!!!  TODO CanPlayerStartConversation !!!! 

	// Make sure the other actor can converse
	if ((!bForcePlay) && ((ScriptedPawn(invokeActor) != None) && (!ScriptedPawn(invokeActor).CanConverse())))
		return False;

	//Log( "Passed: if ((!bForcePlay) && ((ScriptedPawn(invokeActor) != None) && (!ScriptedPawn(invokeActor).CanConverse())))", 'DevConPlay' );

	// If we have a conversation passed in, use it.  Otherwise check to see
	// if the passed in actor actually has a valid conversation that can be
	// started.

	if ( con == None )
		con = GetActiveConversation( PassedInPlayer, invokeActor, invokeMethod );

	//Log( "con = " $ con, 'DevConPlay' );

	// If we have a conversation, put the actor into "Conversation Mode".
	// Otherwise just return false.
	//
	// TODO: Scan through the conversation and put *ALL* actors involved
	//       in the conversation into the "Conversation" state??

	if ( con != None )
	{
		// Check to see if this conversation is already playing.  If so,
		// then don't start it again.  This prevents a multi-bark conversation
		// from being abused.
		if ((conPlay != None) && (conPlay.con == con))
			return False;

		// Now check to see if there's a conversation playing that is owned
		// by the InvokeActor *and* the player has a speaking part *and*
		// it's a first-person convo, in which case we want to abort here.
		if (((conPlay != None) && (conPlay.invokeActor == invokeActor)) && 
		    (conPlay.con.bFirstPerson) &&
//			(conPlay.con.IsSpeakingActor(Self)))
				(IsSpeakingActorByBindName(conPlay.con, BindName)))
			return False;

		// Check if the person we're trying to start the conversation 
		// with is a Foe and this is a Third-Person conversation.  
		// If so, ABORT!
//		if ((!bForcePlay) && ((!con.bFirstPerson) && (ScriptedPawn(invokeActor) != None) && (ScriptedPawn(invokeActor).GetPawnAllianceType(Self) == ALLIANCE_Hostile)))
//			return False;

		if ( PassedInPlayer != None )
		{
			//if ((!bForcePlay) && ((!con.bFirstPerson) && (ScriptedPawn(invokeActor) != None) && (ScriptedPawn(invokeActor).GetPawnAllianceType(Self) == ALLIANCE_Hostile)))
			if ((!bForcePlay) && ((!con.bFirstPerson) && (ScriptedPawn(invokeActor) != None) && (ScriptedPawn(invokeActor).GetPawnAllianceType( PassedInPlayer ) == ALLIANCE_Hostile)))
				return False;
		}
		else
		{
			//if ((!bForcePlay) && ((!con.bFirstPerson) && (ScriptedPawn(invokeActor) != None) && (ScriptedPawn(invokeActor).GetPawnAllianceType(Self) == ALLIANCE_Hostile)))
			if ((!bForcePlay) && ((!con.bFirstPerson) && (ScriptedPawn(invokeActor) != None) && (ScriptedPawn(invokeActor).GetAllianceType( 'Player' ) == ALLIANCE_Hostile)))
				return False;
		}

		// If the player is involved in this conversation, make sure the 
		// scriptedpawn even WANTS to converse with the player.
		//
		// I have put a hack in here, if "con.bCanBeInterrupted" 
		// (which is no longer used as intended) is set, then don't 
		// call the ScriptedPawn::CanConverseWithPlayer() function

//		if ((!bForcePlay) && ((con.IsSpeakingActor(Self)) && (!con.bCanBeInterrupted) && (ScriptedPawn(invokeActor) != None) && (!ScriptedPawn(invokeActor).CanConverseWithPlayer(Self))))
//			return False;

		if ( PassedInPlayer != None )
		{
			if ((!bForcePlay) && ((con.IsSpeakingActor(Self)) && (!con.bCanBeInterrupted) && (ScriptedPawn(invokeActor) != None) && (!ScriptedPawn(invokeActor).CanConverseWithPlayer(PassedInPlayer))))
				return False;
		}
		else
		{
			if ((!bForcePlay) && ((con.IsSpeakingActor(Self)) && (!con.bCanBeInterrupted) && (ScriptedPawn(invokeActor) != None) && (!HXScriptedPawn(invokeActor).CanConverseWithPlayer2())))
				return False;
		}

		// Hack alert!  If this is a Bark conversation (as denoted by the 
		// conversation name, since we don't have a field in ConEdit), 
		// then force this conversation to be first-person
		if (Left(con.conName, Len(con.conOwnerName) + 5) == (con.conOwnerName $ "_Bark"))
			con.bFirstPerson = True;

		// Make sure the player isn't ducking.  If the player can't rise
		// to start a third-person conversation (blocked by geometry) then 
		// immediately abort the conversation, as this can create all 
		// sorts of complications (such as the player standing through
		// geometry!!)

//		if ((!con.bFirstPerson) && (ResetBasedPawnSize() == False))
//			return False;

		if ( !con.bFirstPerson )
		{
			if ( PassedInPlayer == None )
			{
				Log( "No PassedInPlayer for 3rd person conversation... aborting..", 'DevConPlay' );
				return false;
			}
			else if ( !PassedInPlayer.ResetBasedPawnSize() )
			{
				Log( "Failed to ResetBasedPawnSize() for " $ PassedInPlayer $ ".. aborting..", 'DevConPlay' );
				return false;
			}

			//Log( "con is not a firstperson con.. aborting.." );
			//return false;
		}

		// If ConPlay exists, end the current conversation playing
		if (conPlay != None)
		{
			// If we're already playing a third-person conversation, don't interrupt with
			// another *radius* induced conversation (frobbing is okay, though).
			if ((conPlay.con != None) && (conPlay.con.bFirstPerson) && (invokeMethod == IM_Radius))
				return False;

			conPlay.InterruptConversation();
			conPlay.TerminateConversation();
		}

		// If this is a first-person conversation _and_ a DataLink is already
		// playing, then abort.  We don't want to give the user any more 
		// distractions while a DL is playing, since they're pretty important.
		if ( dataLinkPlay != None )
		{
			if (con.bFirstPerson)
				return False;
			else
				dataLinkPlay.AbortAndSaveHistory();
		}

		// Found an active conversation, so start it
		conPlay = Spawn(class'HXConPlay');
		conPlay.SetStartActor(invokeActor);
		conPlay.SetConversation(con);
		conPlay.SetForcePlay(bForcePlay);

		if ( PassedInPlayer != None )
		{
			conPlay.SetInitialRadius(VSize(PassedInPlayer.Location - invokeActor.Location));
		}
		else
		{
			// hopefully this is huge enough
			conPlay.SetInitialRadius( 512.0 );
		}

		// If this conversation was invoked with IM_Named, then save away
		// the current radius so we don't abort until we get outside 
		// of this radius + 100.
		if (invokeMethod == IM_Frob)
		{
			conPlay.SetOriginalRadius(con.radiusDistance);
			con.radiusDistance = VSize(invokeActor.Location - PassedInPlayer.Location);
		}
		else if (invokeMethod == IM_Named)
		{
			conPlay.SetOriginalRadius(con.radiusDistance);

			if ( PassedInPlayer != None )
				con.radiusDistance = VSize(invokeActor.Location - PassedInPlayer.Location);
			else
			{
				Log( "WARNING! No PassedInPlayer for IM_Named Convo, setting con.radiusDistance to 512.0" );
				con.radiusDistance = 512.0;
			}
		}

		// If the invoking actor is a ScriptedPawn, then force this person 
		// into the conversation state
		if ((!bForcePlay) && (ScriptedPawn(invokeActor) != None ))
			ScriptedPawn(invokeActor).EnterConversationState(con.bFirstPerson, bAvoidState);

		// Do the same if this is a HXDecoration
		if ((!bForcePlay) && (HXDecoration(invokeActor) != None ))
			HXDecoration(invokeActor).EnterConversationState(con.bFirstPerson, bAvoidState);

		// If this is a third-person convo, we're pretty much going to 
		// pause the game.  If this is a first-person convo, then just 
		// keep on going..
		//
		// If this is a third-person convo *AND* 'bForcePlay' == True, 
		// then use first-person mode, as we're playing an intro/endgame
		// sequence and we can't have the player in the convo state (bad bad bad!)

		if ((!con.bFirstPerson) && (!bForcePlay))
		{
			PassedInPlayer.GotoState('Conversation');
		}
		else
		{
			if (!ConPlay.StartCoopConversation(InvokeActor, bForcePlay))
			{
				AbortConversation(True);
			}
		}

		//Log( "==============================  True  ==================================" );
		return True;
	}
	else
	{
		//Log( "==============================  False  =================================" );
		return False;
	}
}

// ----------------------------------------------------------------------
// GetActiveConversation()
//
// This routine searches all the conversations in this chain until it 
// finds one that is valid for this situation.  It returns the 
// conversation or None if none are found.
// ----------------------------------------------------------------------

function Conversation GetActiveConversation( HXPlayerPawn PassedInPlayer, Actor invokeActor, EInvokeMethod invokeMethod )
{
	local ConListItem conListItem;
	local Conversation con;
	local Name flagName;
	local bool bAbortConversation;

	//Log( Self $ ".GetActiveConversation( " $ PassedInPlayer $ ", " $ invokeActor $ ", " $ invokeMethod $ " ) called", 'DevConPlay' );

	// If we don't have a valid invokeActor or the flagbase
	// hasn't yet been initialized, immediately abort.
	if ((invokeActor == None) || (Steve == None) || (Steve.flagBase == None))
		return None;

	bAbortConversation = True;

	// Force there to be a one second minimum between conversations 
	// with the same NPC
	if ((invokeActor.LastConEndTime != 0) && 
		((Level.TimeSeconds - invokeActor.LastConEndTime) < 1.0))
		return None;

	// In a loop, go through the conversations, checking each.
	conListItem = ConListItem(invokeActor.ConListItems);

	while ( conListItem != None )
	{
		con = conListItem.con;

		bAbortConversation = False;

		// Ignore Bark conversations, as these are started manually
		// by the AI system.  Do this by checking to see if the first
		// part of the conversation name is in the form, 
		//
		// ConversationOwner_Bark

		if (Left(con.conName, Len(con.conOwnerName) + 5) == (con.conOwnerName $ "_Bark"))
			bAbortConversation = True;

		if (!bAbortConversation)
		{
			// Now check the invocation method to make sure
			// it matches what was passed in

			switch( invokeMethod )
			{
				// Removed Bump conversation starting functionality, all convos
				// must now be "Frobbed" to start (excepting Radius, of course).
				case IM_Bump:
				case IM_Frob:
					bAbortConversation = !(con.bInvokeFrob || con.bInvokeBump);
					break;

				case IM_Sight:
					bAbortConversation = !con.bInvokeSight;
					break;

				case IM_Radius:
					if ( con.bInvokeRadius )
					{
						// Calculate the distance between the player and the owner
						// and if the player is inside that radius, we've passed 
						// this check.

						bAbortConversation = !CheckConversationInvokeRadius( PassedInPlayer, invokeActor, con );

						// First check to make sure that at least 10 seconds have passed
						// before playing a radius-induced conversation after a letterbox
						// conversation with the player
						//
						// Check:
						//  
						// 1.  Player finished letterbox convo in last 10 seconds
						// 2.  Conversation was with this NPC
						// 3.  This new radius conversation is with same NPC.

						if ((!bAbortConversation) && 
						    ((Level.TimeSeconds - PassedInPlayer.lastThirdPersonConvoTime) < 10) && 
						    (PassedInPlayer.lastThirdPersonConvoActor == invokeActor))
							bAbortConversation = True;

						// Now check if this conversation ended in the last ten seconds or so
						// We want to prevent the user from getting trapped inside the same 
						// radius conversation 
						
						if ((!bAbortConversation) && (con.lastPlayedTime > 0))
							bAbortConversation = ((Level.TimeSeconds - con.lastPlayedTime) < 10);

						// Now check to see if the player just ended a radius, third-person
						// conversation with this NPC in the last 5 seconds.  If so, punt, 
						// because we don't want these to chain together too quickly.

						if ((!bAbortConversation) &&
						    ((Level.TimeSeconds - lastFirstPersonConvoTime) < 5) && 
							(lastFirstPersonConvoActor == invokeActor))
							bAbortConversation = True;
					}
					else
					{
						bAbortConversation = True;
					}
					break;

				case IM_Other:
				default:
					break;
			}
		}

		// Now check to see if these two actors are too far apart on their Z
		// axis so we don't get conversations triggered when someone jumps on
		// someone else, or when actors are on two different levels.

		if (!bAbortConversation)
		{
			bAbortConversation = !CheckConversationHeightDifference( PassedInPlayer, invokeActor, 20 );

			// If the height check failed, look to see if the actor has a LOS view
			// to the player in which case we'll allow the conversation to continue
			
			if (bAbortConversation)
				bAbortConversation = !CanActorSeePlayer( PassedInPlayer, invokeActor );
		}

		// Check if this conversation is only to be played once 
		if (( !bAbortConversation ) && ( con.bDisplayOnce ))
		{
			flagName = StringToName(con.conName $ "_Played");		
			bAbortConversation = (Steve.flagBase.GetBool(flagName) == True);
		}

		if ( !bAbortConversation )
		{
			// Then check to make sure all the flags that need to be
			// set are.

			bAbortConversation = !CheckFlagRefs(con.flagRefList);
		}

		if ( !bAbortConversation )
			break;
	
		conListItem = conListItem.next;
	}

	if (bAbortConversation)
		return None;
	else
		return con;
}

// ----------------------------------------------------------------------
// EndConversation()
//
// Called by ConPlay when a conversation has finished.
// ----------------------------------------------------------------------

function EndConversation()
{
	//local DeusExLevelInfo info;

	//Super.EndConversation();
	// was just this
	LastConEndTime = Level.TimeSeconds;

	// If we're in a bForcePlay (cinematic) conversation,
	// force the CinematicWindow to be displayd
//	if ((conPlay != None) && (conPlay.GetForcePlay()))
//	{
//		if (HXRootWindow(rootWindow) != None)
//			HXRootWindow(rootWindow).NewChild(class'CinematicWindow');
//	}

	conPlay = None;

	// Check to see if we need to resume any DataLinks that may have
	// been aborted when we started this conversation
	ResumeDataLinks();

//	StopBlendAnims();

	// We might already be dead at this point (someone drop a LAM before
	// entering the conversation?) so we want to make sure the player
	// doesn't suddenly jump into a non-DEATH state.
	//
	// Also make sure the player is actually in the Conversation state
	// before attempting to kick him out of it.

//	if ((Health > 0) && ((IsInState('Conversation')) || (IsInState('FirstPersonConversation')) || (NextState == 'Interpolating')))
//	{
//		if (NextState == '')
//			GotoState('PlayerWalking');
//		else
//			GotoState(NextState);
//	}
}

// ----------------------------------------------------------------------
// CheckConversationInvokeRadius()
//
// Returns True if this conversation can be invoked given the 
// invoking actor and the conversation passed in.
// ----------------------------------------------------------------------

function bool CheckConversationInvokeRadius( HXPlayerPawn PassedInPlayer, Actor invokeActor, Conversation con )
{
	local Int  invokeRadius;
	local Int  dist;

	dist = VSize(PassedInPlayer.Location - invokeActor.Location);

	invokeRadius = Max(16, con.radiusDistance);

	return (dist <= invokeRadius);
}

// ----------------------------------------------------------------------
// CheckConversationHeightDifference()
//
// Checks to make sure the player and the invokeActor are fairly close
// to each other on the Z Plane.  Returns True if they are an 
// acceptable distance, otherwise returns False.
// ----------------------------------------------------------------------

function bool CheckConversationHeightDifference( HXPlayerPawn PassedInPlayer, Actor invokeActor, int heightOffset )
{
	local Int dist;

	dist = Abs(PassedInPlayer.Location.Z - invokeActor.Location.Z) - Abs(PassedInPlayer.Default.CollisionHeight - PassedInPlayer.CollisionHeight);

	if (dist > (Abs(PassedInPlayer.CollisionHeight - invokeActor.CollisionHeight) + heightOffset))
		return False;
	else
		return True;
}
	
// ----------------------------------------------------------------------
// CanActorSeePlayer()
// ----------------------------------------------------------------------

function bool CanActorSeePlayer( HXPlayerPawn PassedInPlayer, Actor invokeActor)
{
	return PassedInPlayer.FastTrace(invokeActor.Location);
}

// ----------------------------------------------------------------------
// CheckActiveConversationRadius()
//
// If there's a first-person conversation active, checks to make sure 
// that the player has not walked far away from the conversation owner.
// If so, the conversation is aborted.
// ----------------------------------------------------------------------

function CheckActiveConversationRadius( HXPlayerPawn PassedInPlayer )
{
	local int checkRadius;

	// Ignore if conPlay.GetForcePlay() returns True

	if ((conPlay != None) && (!conPlay.GetForcePlay()) && (conPlay.ConversationStarted()) && (conPlay.displayMode == DM_FirstPerson) && (conPlay.StartActor != None))
	{
		// If this was invoked via a radius, then check to make sure the player doesn't 
		// exceed that radius plus 

		if (conPlay.con.bInvokeRadius) 
			checkRadius = conPlay.con.radiusDistance + 100;
		else
			checkRadius = 300;

		// Add the collisioncylinder since some objects are wider than others
		checkRadius += conPlay.StartActor.CollisionRadius;

		if (VSize(conPlay.startActor.Location - PassedInPlayer.Location) > checkRadius)
		{
			// Abort the conversation
			conPlay.TerminateConversation(True);
		}
	}
}

// ----------------------------------------------------------------------------
// CheckActorDistances()
//
// Checks to see how far all the actors are away from each other 
// to make sure the conversation should continue.
// ----------------------------------------------------------------------------

function CheckActorDistances( HXPlayerPawn PassedInPlayer )
{
	if ( ConPlay==None || ConPlay.GetForcePlay() || !ConPlay.ConversationStarted() || ConPlay.DisplayMode!=DM_ThirdPerson )
		return;

	if ( ConPlay.Player!=PassedInPlayer )
	{
		Warn( Self$".CheckActorDistances() found Player missmatch. Expected: "$ConPlay.Player$" Got: "$PassedInPlayer );
		return;
	}

	if ( !ConPlay.ConCheckActorDistances(ConPlay.Con) )
	{
		Log( Self$".CheckActorDistances( "$PassedInPlayer$" ) failed. Terminating Conversation.", 'DevConPlay' );
		ConPlay.TerminateConversation( true );
	}
}

// ----------------------------------------------------------------------------
// InConversation()
//
// Returns True if the player is currently engaged in conversation
// ----------------------------------------------------------------------------

function bool InConversation()
{
	if ( conPlay == None )
	{
		return False;
	}
	else
	{
		if (conPlay.con != None)
			return ((conPlay.con.bFirstPerson == False) && (!conPlay.GetForcePlay()));
		else
			return False;
	}
}

// ----------------------------------------------------------------------
// CanGameStartConversation()
//
// Returns true if we can start a conversation.  Basically this means 
// that 
//
// 1) If in conversation, bCannotBeInterrutped set to False
// 2) If in conversation, if we're not in a third-person convo
// 8) The game is in 'bPlayersOnly' mode
// ----------------------------------------------------------------------

function bool CanGameStartConversation()
{
	if ( ( (conPlay != None) && (conPlay.CanInterrupt() == False) )
		|| ( (conPlay != None) && (conPlay.con.bFirstPerson != True) )
		|| ( Level.bPlayersOnly ) )
		return False;
	else	
		return True;
}

// ----------------------------------------------------------------------
// CanPlayerStartConversation()
//
// Returns true if we can start a conversation.  Basically this means 
// that 
//
// 3) The player isn't in 'bForceDuck' mode
// 4) The player isn't DEAD!
// 5) The player isn't swimming
// 6) The player isn't CheatFlying (ghost)
// 7) The player isn't in PHYS_Falling
// ----------------------------------------------------------------------
// 8) We just had a converstation.
// ----------------------------------------------------------------------

// I should do the check function inside pp to override per state.
function bool CanPlayerStartConversation( HXPlayerPawn Player )
{
	// Old checks.
	if ( (Player.bForceDuck==True && (Player.HealthLegLeft>0 || Player.HealthLegRight>0 ) )
		|| Player.IsInState('Dying')
		|| Player.IsInState('PlayerSwimming')
		|| Player.IsInState('CheatFlying')
		|| Player.IsInState('CheatGhosting')
		|| Player.Physics == PHYS_Falling )
		return False;

	//
	// Delight slightly if player just had a conversation to quirk around missing
	// conversation display if we just had a conversation and another pawn is
	// waiting straight next to the player.
	//
	if ( LastConEndTime+1.0>Level.TimeSeconds )
		return False;

	// Passed.
	return True;
}

// ----------------------------------------------------------------------
// StartDataLinkTransmission()
//
// Locates and starts the DataLink passed in.
// ----------------------------------------------------------------------

function bool StartDataLinkTransmission( String DatalinkName, optional HXDataLinkTrigger DatalinkTrigger )
{
	local Conversation activeDataLink;
	local bool bDataLinkPlaySpawned;

	Log( Self $ ".StartDataLinkTransmission( " $ DatalinkName $ ", " $ DatalinkTrigger $ " ) called.", 'DevDataLinkPlay' );

	// Don't allow DataLinks to start if we're in PlayersOnly mode
	if ( Level.bPlayersOnly )
		return False;

	//return DataLinkManager.StartDataLink( DatalinkName, DatalinkTrigger );
	return DataLinkManager.StartDataLinkTransmission( DatalinkName, DatalinkTrigger );
}

// ----------------------------------------------------------------------
// ResumeDataLinks()
// ----------------------------------------------------------------------

function ResumeDataLinks()
{
	if ( dataLinkPlay != None )
		dataLinkPlay.ResumeDataLinks();
}

// ----------------------------------------------------------------------
// CheckFlagRefs()
//
// Loops through the flagrefs passed in and sees if the current flag
// settings in the game match this set of flags.  Returns True if so,
// otherwise False.
// ----------------------------------------------------------------------

function bool CheckFlagRefs( ConFlagRef FlagRef )
{
	local ConFlagRef Ref;

	// Loop through our list of FlagRef's, checking the value of each.
	// If we hit a bad match, then we'll stop right away since there's
	// no point of continuing.
	Ref = FlagRef;
	while( Ref!=None )
	{
		if ( Steve.FlagBase.GetBool(Ref.FlagName)!=Ref.Value )
			return False;
		Ref = Ref.NextFlagRef;
	}
	
	// If we made it this far, then the flags check out.
	return True;
}

// ----------------------------------------------------------------------
// BroadcastActorSpeech()
// ----------------------------------------------------------------------

function int BroadcastActorSpeech( string speechclassstr, Actor Speaker, float Radius )
{
	local Pawn curPawn;

	currentPlayingSoundID++;

	for ( CurPawn = Level.PawnList; CurPawn != None; CurPawn = CurPawn.NextPawn )
		if ( CurPawn.IsA('HXPlayerPawn') )
			HXPlayerPawn(CurPawn).ClientPlayActorSpeech( currentPlayingSoundID, speechclassstr, Speaker, Radius );

	return currentPlayingSoundID;
}

// ----------------------------------------------------------------------
// BroadcastActorCinematicSpeech()
// ----------------------------------------------------------------------

function int BroadcastActorCinematicSpeech( string speechclassstr, Actor Speaker, float Radius )
{
	local Pawn curPawn;

	currentPlayingSoundID++;

	for ( CurPawn = Level.PawnList; CurPawn != None; CurPawn = CurPawn.NextPawn )
		if ( CurPawn.IsA('HXPlayerPawn') )
			HXPlayerPawn(CurPawn).ClientPlayActorCinematicSpeech( currentPlayingSoundID, speechclassstr, Speaker, Radius );

	return currentPlayingSoundID;
}

// ----------------------------------------------------------------------
// BroadcastStopActorSpeech()
// ----------------------------------------------------------------------

function BroadcastActorStopSpeech( int serverSoundID )
{
	local Pawn curPawn;

	for ( CurPawn = Level.PawnList; CurPawn != None; CurPawn = CurPawn.NextPawn )
		if ( CurPawn.IsA('HXPlayerPawn') )
			HXPlayerPawn(CurPawn).ClientStopActorSpeech( serverSoundID );
}

// ----------------------------------------------------------------------
// GetDisplayName()
//
// Returns a name that can be displayed in the conversation.  
//
// The first time we speak to someone we'll use the Unfamiliar name.
// For subsequent conversations, use the Familiar name.  As a fallback,
// the BindName will be used if both of the other two fields
// are blank.
//
// If this is a HXDecoration and the Familiar/Unfamiliar names
// are blank, then use the decoration's ItemName instead.  This is 
// for use in the FrobDisplayWindow.
// ----------------------------------------------------------------------

function String GetDisplayName(Actor actor, optional Bool bUseFamiliar)
{
	local String displayName;

	// Sanity check
	if ((actor == None) /* || (player == None) || (rootWindow == None) */)
		return "";

	// Use player names
	if ( actor.IsA('PlayerPawn')
		&& PlayerPawn(actor).PlayerReplicationInfo != None
		&& PlayerPawn(actor).PlayerReplicationInfo.PlayerName != "" )
		return PlayerPawn(actor).PlayerReplicationInfo.PlayerName;

	// If we've spoken to this person already, use the 
	// Familiar Name
	if ((actor.FamiliarName != "") && ((actor.LastConEndTime > 0) || (bUseFamiliar)))
		displayName = actor.FamiliarName;

	if ((displayName == "") && (actor.UnfamiliarName != ""))
		displayName = actor.UnfamiliarName;

	if (displayName == "")
	{
		if (actor.IsA('HXDecoration'))
			displayName = HXDecoration(actor).itemName;
		else if (actor.IsA('DeusExDecoration'))
			displayName = DeusExDecoration(actor).itemName;
		else
			displayName = actor.BindName;
	}

	return displayName;
}

// ----------------------------------------------------------------------
// ScalePawnAccuracy() - Called by HXWeapon.CalculateAccuracy()
//
// 1.00 is unchanged accuracy, lower value is higher accuracy.
// ----------------------------------------------------------------------

function float ScalePawnAccuracy( Weapon Weapon, ScriptedPawn Pawn )
{
	local float Accuracy;

	Accuracy = 1.00;
/* Disabled for now. Should be part of a balancing mutator or gameinfo
	// Don't make overpowered sniper rifle too deadly
	if ( Weapon != None && Weapon.IsA('HXWeaponSniperRifle') )
	{
		switch ( Difficulty )
		{
			// easy
			case 0:
				Accuracy *= 1.00;
				break;
			// medium
			case 1:
				Accuracy *= 0.95;
				break;
			// hard
			case 2:
				Accuracy *= 0.90;
				break;
			// unreal
			case 3:
				Accuracy *= 0.75;
				break;

			// default (error)
			default:
				Accuracy *= 1.00;
				break;
		}
	}
	else
	{
		switch ( Difficulty )
		{
			// easy
			case 0:
				Accuracy *= 1.00;
				break;
			// medium
			case 1:
				Accuracy *= 0.75;
				break;
			// hard
			case 2:
				Accuracy *= 0.50;
				break;
			// unreal
			case 3:
				Accuracy *= 0.20;
				break;

			// default (error)
			default:
				Accuracy *= 1.00;
				break;
		}
	}
*/
	return Accuracy;
}

// ----------------------------------------------------------------------
// StringToName()
// ----------------------------------------------------------------------

function Name StringToName( string Str )
{
	return Class'HXMutator'.static.StringToName( Str );
}

// ----------------------------------------------------------------------
// PreventDeath()
// Used by training mission and mission 04 after hunt begins.
// ----------------------------------------------------------------------

function PreventDeath( Pawn Pawn )
{
	if ( MissionScript!=None )
		MissionScript.PreventDeath( Pawn );
}

// ----------------------------------------------------------------------------
// PruneCurrent()
//
// Called before current map progress is saved just before switching level.
// Out parameter can be used to flag or unflag actor as transient.
//
// Be aware that this can break linked lists such as Level.PawnList.
// ----------------------------------------------------------------------------

simulated event PruneCurrent( out byte bTransient )
{
	bTransient = 1;
}

// ----------------------------------------------------------------------------
// AllowCommand()
//
// Prototype API for finer grained command access on the server.
// ----------------------------------------------------------------------------

function bool AllowCommand( PlayerPawn PlayerPawn, name Command, ECommandType CommandType, optional int IntParm, optional float FloatParm, optional string StrParm )
{
	if ( PlayerPawn==None )
		return false;

	// Allow host.
	if ( PlayerPawn==GetPlayerPawn() )
		return true;

	// Allow admin.
	if ( PlayerPawn.bAdmin )
		return true;

	// Prefilter commands.
	switch ( Command )
	{
		case 'Admin':
			return PlayerPawn.bAdmin;
			break;

		// IntParm is the count of actors desired to be spawned.
		case 'SpawnMass':
			if ( IntParm>50 )
				return false;
			break;
	}

	// Prefilter commandtypes.
	switch ( CommandType )
	{
		// Say and TeamSay should use AllowsBroadcast system, which in turn uses us.
		case CMDTYPE_Broadcast:
			// IntParm is the MessageLength passed into AllowsBroadcast.
			if ( (SentText+IntParm)<260 || PlayerPawn.bAdmin )
			{
				SentText += IntParm;
				return true;
			}
			return false;
			break;
	}

	// Otherwise just make it based on whether cheats are enabled.
	return bCheatsEnabled;
}

// ----------------------------------------------------------------------------
// AllowsBroadcast()
//
// Whether players are allowed to broadcast messages now.
// ----------------------------------------------------------------------------

function bool AllowsBroadcast( Actor Broadcasting, int MessageLength )
{
	local PlayerPawn BroadcastingPlayerPawn;

	// Filter amount of messages sent and feed into AllowCommand system.
	BroadcastingPlayerPawn = PlayerPawn(Broadcasting);
	if ( BroadcastingPlayerPawn!=None )
		return AllowCommand( BroadcastingPlayerPawn, '', CMDTYPE_Broadcast, MessageLength );

	// Let any non player actors just tell their tale.
	return true;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	DeathFell="left a small crater"
	DeathDrowned="forgot to come up for air"
	DeathExploded="was blown up"
	DeathExplodedSelf="blew himself up"
	DeathBurned="was incinerated"
	DeathHeliblade="jumped into a helicopter blade"
	DeathAutoTurret="ran into an auto turret"
	DeathStomped="was crushed"
	DeathSuicide="had a sudden heart attack"
	DeathCoughingNails="just couldn't kick the habit"
	DeathPlague="made questionable choices in life"
	MsgNoteAdded="Note Received - Check DataVault For Details"
	MsgGoalAdded="Goal Received - Check DataVault For Details"
	MsgPrimaryGoalCompleted="Primary Goal Completed"
	MsgSecondaryGoalCompleted="Secondary Goal Completed"
	FriendlyFire=0.000000
	TooManyPlayers="Too many players"
	WhiteColor=(R=255,G=255,B=255)
	SilverColor=(R=138,G=164,B=166)
	RedColor=(R=255)
	GreenColor=(G=255)
	GoldColor=(R=255,G=255)
	MsgSkillPointsAward="%d skill points awarded"
	MsgSkillPointsAwardDetail="%d skill points awarded: %s"
	AddedToDatavaultLabel="Image %s added to DataVault"
	PlayerString="Name"
	KillsString="Kills"
	KnockedOutString="Knockouts"
	DeathsString="Deaths"
	PlayerString="Player"
	MutatorClass=HXDeusExCampaignMutator
	TailMutatorClass=HXTailMutator
	//bPlayersCleaned=False
	CurrentPlayingSoundID=0
	GameReplicationInfoClass=HXGameReplicationInfo
	DefaultPlayerClass=HXJCDentonPlayer
	CombatDifficulty=1.000000
	BindName="JCDenton"
	FamiliarName="JC Denton"
	UnfamiliarName="JC Denton"
	bCheatsEnabled=False
	bSubtitles=True
	MaxSpectators=0
	bAlwaysRelevant=True
	bMuteSpectators=True
	AutoAim=1.000000
	DataLinkManagerClass=HXDataLinkManager
	BarkManagerClass=HXBarkManager
	SkillPointPenalty=0.5
}
