//=============================================================================
// HXGameReplicationInfo.
//=============================================================================
class HXGameReplicationInfo extends GameReplicationInfo
	native;

var float SkilledToolPenalty;  // Required for correct display of number of multitools and lockpicks.
var bool  bShowStartupMessage; // Whether to show the startup messages.

// ----------------------------------------------------------------------------
// Network replication
// ----------------------------------------------------------------------------

replication
{
	reliable if ( Role==ROLE_Authority )
		SkilledToolPenalty, bShowStartupMessage;
}

// ----------------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	local HXRootWindow RootWindow;
	local HXPlayerPawn Player;
	local DeusExLevelInfo DeusExLevelInfo;
	local int i;

	Super.PostNetBeginPlay();

	//Log( Self $ ".PostNetBeginPlay()" );

	if ( Level.Netmode==NM_Client )
	{
		// Startup message.
		if ( bShowStartupMessage )
		{
			Player = HXPlayerPawn(GetPlayerPawn());
			if ( Player!=None )
				RootWindow = HXRootWindow(Player.RootWindow);

			if ( RootWindow!=None )
			{
				foreach AllActors( Class'DeusExLevelInfo', DeusExLevelInfo )
				{
					if ( DeusExLevelInfo.StartupMessage[0] == "" );
						break;

					// Display message.
					RootWindow.HUD.StartDisplay.Message = "";
					for ( i=0; i<ArrayCount(DeusExLevelInfo.StartupMessage); i++ )
						RootWindow.HUD.StartDisplay.AddMessage( DeusExLevelInfo.StartupMessage[i] );
					RootWindow.HUD.StartDisplay.StartMessage();
					break;
				}
			}
		}
	}
}

// ----------------------------------------------------------------------------
// PruneCurrent()
//
// Called before current map progress is saved just before switching level.
// Out parameter can be used to flag or unflag actor as transient.
//
// Be aware that this can break linked lists such as Level.PawnList.
// ----------------------------------------------------------------------------

simulated event PruneCurrent( out byte bTransient )
{
	bTransient = 1;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
}
