//=============================================================================
// HXGoalCompleteTrigger.
//
// Sets a goal as completed when touched or triggered
// Set bCollideActors to False to make it triggered
//=============================================================================
class HXGoalCompleteTrigger extends HXTrigger;

var() name GoalName;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local GoalCompleteTrigger OtherGoalCompleteTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special GoalCompleteTrigger Init.
	OtherGoalCompleteTrigger = GoalCompleteTrigger(Other);
	if ( OtherGoalCompleteTrigger!=None )
	{
		GoalName = OtherGoalCompleteTrigger.GoalName;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	// Call Super.
	Super.Trigger( Other, Instigator );

	Game.GoalCompleted( GoalName );
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

function Touch( Actor Other )
{
	// Call Super.
	Super.Touch(Other);

	if ( IsRelevant(Other) )
		Game.GoalCompleted( GoalName );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bTriggerOnceOnly=True
}
