//=============================================================================
// HXGreasel.
//=============================================================================
class HXGreasel extends HXAnimal;

var localized String CuddledWith;

function bool FilterDamageType(Pawn instigatedBy, Vector hitLocation,
                               Vector offset, Name damageType)
{
	if ((damageType == 'TearGas') || (damageType == 'HalonGas') || (damageType == 'PoisonGas'))
		return false;
	else
		return Super.FilterDamageType(instigatedBy, hitLocation, offset, damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	else if ((damageType == 'TearGas') || (damageType == 'HalonGas'))
		GotoNextState();
	else if (damageType == 'Stunned')
		GotoNextState();
	else if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

function vector GetSwimPivot()
{
	// THIS IS A HIDEOUS, UGLY, MASSIVELY EVIL HACK!!!!
	return (vect(0,0,1)*CollisionHeight);
}

function TweenToAttack(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
		TweenAnimPivot('Attack', tweentime);
}

function PlayAttack()
{
	PlayAnimPivot('Attack');
}

function PlayPanicRunning()
{
	PlayRunning();
}

function PlayTurning()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,, GetSwimPivot());
	else
		LoopAnimPivot('Walk', 0.1);
}

function TweenToWalking(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
		TweenAnimPivot('Walk', tweentime);
}

function PlayWalking()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',,,, GetSwimPivot());
	else
		LoopAnimPivot('Walk', , 0.15);
}

function TweenToRunning(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
		LoopAnimPivot('Run',, tweentime);
}

function PlayRunning()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		LoopAnimPivot('Run', 1.5);
}
function TweenToWaiting(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnimPivot('Tread', tweentime, GetSwimPivot());
	else
		TweenAnimPivot('BreatheLight', tweentime);
}
simulated function PlayWaiting()
{
	if (Region.Zone.bWaterZone)
		LoopAnimPivot('Tread',1.5,,, GetSwimPivot());
	else
		LoopAnimPivot('BreatheLight', , 0.3);
}

function PlayTakingHit(EHitLocation hitPos)
{
	local vector pivot;
	local name   animName;

	animName = '';
	if (!Region.Zone.bWaterZone)
	{
		switch (hitPos)
		{
			case HITLOC_HeadFront:
			case HITLOC_TorsoFront:
			case HITLOC_LeftArmFront:
			case HITLOC_RightArmFront:
			case HITLOC_LeftLegFront:
			case HITLOC_RightLegFront:
				animName = 'HitFront';
				break;

			case HITLOC_HeadBack:
			case HITLOC_TorsoBack:
			case HITLOC_LeftArmBack:
			case HITLOC_RightArmBack:
			case HITLOC_LeftLegBack:
			case HITLOC_RightLegBack:
				animName = 'HitBack';
				break;
		}
		pivot = vect(0,0,0);
	}

	if (animName != '')
		PlayAnimPivot(animName, , 0.1, pivot);

}

function vector GetChompPosition()
{
	return (Location+Vector(Rotation)*(CollisionRadius+10)+vect(0,0,-10));
}

function PlayEating()
{
	PlayAnimPivot('Eat', 2.0, 0.2);
}

function SpewBlood(vector Position)
{
	local float         size;
	local FleshFragment chunk;

	size = (CollisionRadius + CollisionHeight) / 2;  // yes, we *are* using the Greasel's size...  :)
	if ((FRand() < 0.5) && (size > 10.0))
	{
		chunk = spawn(class'FleshFragment', None,, Position);
		if (chunk != None)
		{
			chunk.DrawScale = size / 25;
			chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
			chunk.bFixedRotationDir = True;
			chunk.RotationRate = RotRand(False);
			chunk.Velocity = VRand()*100;
			chunk.Velocity.Z = chunk.Velocity.Z + 250;
		}
	}
	else
		Super.SpewBlood(Position);
}

// sound functions
function PlayEatingSound()
{
	PlaySound(sound'GreaselEat', SLOT_None,,, 384);
}

function PlayIdleSound()
{
	if (FRand() < 0.5)
		PlaySound(sound'GreaselIdle', SLOT_None);
	else
		PlaySound(sound'GreaselIdle2', SLOT_None);
}

function PlayScanningSound()
{
	if (FRand() < 0.3)
	{
		if (FRand() < 0.5)
			PlaySound(sound'GreaselIdle', SLOT_None);
		else
			PlaySound(sound'GreaselIdle2', SLOT_None);
	}
}

function PlayTargetAcquiredSound()
{
	PlaySound(sound'GreaselAlert', SLOT_None);
}

function PlayCriticalDamageSound()
{
	PlaySound(sound'GreaselFlee', SLOT_None);
}

// ----------------------------------------------------------------------------
// KillMessage()
// ----------------------------------------------------------------------------

function string KillMessage( Name DamageType, Pawn Other )
{
	return CuddledWith $ NameArticle $ UnfamiliarName $ ".";
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	CuddledWith=" cuddled with "
	bPlayDying=True
	FoodClass=DeusExCarcass
	FoodDamage=5
	FoodHealth=2
	bMessyEater=True
	MinHealth=20.0
	CarcassType=GreaselCarcass
	WalkingSpeed=0.08
	bCanBleed=True
	ShadowScale=1.0
	InitialAlliances(0)=(AllianceName=Karkian,AllianceLevel=1.0,bPermanent=True)
	InitialInventory(0)=(Inventory=Class'WeaponGreaselSpit')
	InitialInventory(1)=(Inventory=Class'AmmoGreaselSpit',Count=9999)
	WalkSound=GreaselFootstep
	bSpawnBubbles=False
	bCanSwim=True
	bCanGlide=False
	GroundSpeed=350.0
	WaterSpeed=50.0
	AirSpeed=144.0
	AccelRate=500.0
	BaseEyeHeight=12.5
	Health=100
	UnderWaterTime=99999.0
	AttitudeToPlayer=ATTITUDE_Ignore
	HitSound1=GreaselPainSmall
	HitSound2=GreaselPainLarge
	Die=GreaselDeath
	Alliance=Greasel
	DrawType=DT_Mesh
	Mesh=Greasel
	CollisionRadius=22.00
	//CollisionHeight=17.88
	CollisionHeight=13.38
	Mass=40.0
	Buoyancy=40.0
	BindName="Greasel"
	FamiliarName="Greasel"
	UnfamiliarName="Greasel"
}
