//=============================================================================
// HXGuntherHermann.
//
// Damage type table for Gunther Hermann:
//
// Shot			- 100%
// Sabot		- 100%
// Exploded		- 100%
// TearGas		- 10%
// PoisonGas	- 10%
// Poison		- 10%
// HalonGas		- 10%
// Radiation	- 10%
// Shocked		- 10%
// Stunned		- 0%
// KnockedOut   - 0%
// Flamed		- 0%
// Burned		- 0%
// NanoVirus	- 0%
// EMP			- 0%
//
//=============================================================================
class HXGuntherHermann extends HXHumanMilitary;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

// Copying CollisionSize is suspended for now, making this quirk obsolete.
/*
function Succeeds( Actor Other )
{
	local GuntherHermann OtherGuntherHermann;

	// Call Super.
	Super.Succeeds( Other );

	// Special GuntherHermann Init.
	OtherGuntherHermann = GuntherHermann(Other);
	if ( OtherGuntherHermann!=None )
	{
		// Original CollisionSize didn't match the other GM_Jump character.
		// In particular the CollisionHeight was too small, leading to GuntherHermanns feet
		// beeing inside the floor.
		if ( OtherGuntherHermann.CollisionHeight==(OtherGuntherHermann.default.CollisionHeight-4.5) && OtherGuntherHermann.CollisionRadius==OtherGuntherHermann.default.CollisionRadius ) 
		{
			SetCollisionSize( default.CollisionRadius, default.CollisionHeight );
		}
	}
}
*/

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'Flamed') || (damageType == 'Burned') || (damageType == 'Stunned') ||
	    (damageType == 'KnockedOut'))
		return 0.0;
	else if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas') ||
			(damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'Poison') ||
	        (damageType == 'PoisonEffect'))
		return 0.1;
	else
		return Super.ShieldDamage(damageType);
}

// ----------------------------------------------------------------------
// SpawnCarcass()
//
// Blow up instead of spawning a carcass
// ----------------------------------------------------------------------

function Carcass SpawnCarcass()
{
	if (bStunned)
		return Super.SpawnCarcass();

	Explode();

	return None;
}

function Explode()
{
	local HXSphereEffect sphere;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local float explosionDamage;
	local float explosionRadius;

	explosionDamage = 100;
	explosionRadius = 256;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'LargeExplosion1', SLOT_None,,, explosionRadius*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionLarge',,, Location + 2*VRand()*CollisionRadius);

	sphere = Spawn(class'HXSphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks and flesh fragments
	for (i=0; i<explosionDamage/6; i++)
	{
		if (FRand() < 0.3)
			spawn(class'Rockchip',,,Location);
		else
			spawn(class'FleshFragment',,,Location);
	}

	HurtRadius(explosionDamage, explosionRadius, 'Exploded', explosionDamage*100, Location);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

//
// special Gunther killswitch animation state
//
state KillswitchActivated
{
	function BeginState()
	{
		StandUp();
		LastPainTime = Level.TimeSeconds;
		LastPainAnim = AnimSequence;
		bInterruptState = false;
		BlockReactions();
		bCanConverse = False;
		bStasis = False;
		SetDistress(true);
		TakeHitTimer = 2.0;
		EnemyReadiness = 1.0;
		ReactionLevel  = 1.0;
		bInTransientState = true;
	}

Begin:
	FinishAnim();
	PlayAnim('HitTorso', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitHead', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitTorsoBack', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitHeadBack', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitHead', 3.0, 0.1);
	FinishAnim();
	PlayAnim('HitHeadBack', 3.0, 0.1);
	FinishAnim();
	PlayAnim('HitHead', 5.0, 0.1);
	FinishAnim();
	PlayAnim('HitHeadBack', 5.0, 0.1);
	FinishAnim();
	Explode();
	Destroy();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	CarcassType=GuntherHermannCarcass
	WalkingSpeed=0.35
	bImportant=True
	bInvincible=True
	CloseCombatMult=0.5
	InitialInventory(0)=(Inventory=Class'WeaponAssaultGun')
	InitialInventory(1)=(Inventory=Class'Ammo762mm',Count=12)
	InitialInventory(2)=(Inventory=Class'WeaponCombatKnife')
	InitialInventory(3)=(Inventory=Class'WeaponFlamethrower')
	InitialInventory(4)=(Inventory=Class'AmmoNapalm',Count=2)
	BurnPeriod=0.0
	WalkAnimMult=0.75
	GroundSpeed=210.0
	BaseEyeHeight=44.0
	Health=400
	HealthHead=600
	HealthTorso=400
	HealthLegLeft=400
	HealthLegRight=400
	HealthArmLeft=400
	HealthArmRight=400
	Texture=BlackMaskTex
	Mesh=GM_DressShirt_B
	DrawScale=1.1
	MultiSkins(0)=GuntherHermannTex1
	MultiSkins(1)=PantsTex9
	MultiSkins(2)=GuntherHermannTex0
	MultiSkins(3)=GuntherHermannTex0
	MultiSkins(4)=PinkMaskTex
	MultiSkins(5)=GrayMaskTex
	MultiSkins(6)=BlackMaskTex
	MultiSkins(7)=BlackMaskTex
	// Orignal too large CollisionSize.
	//CollisionRadius=24.20
	////CollisionHeight=55.66
	//CollisionHeight=51.16
	// Correct CollisionSize matching other GM_DressShirt_B characters.
	CollisionRadius=22.00
	//CollisionHeight=51.80
	CollisionHeight=47.30
	BindName="GuntherHermann"
	FamiliarName="Gunther Hermann"
	UnfamiliarName="Gunther Hermann"
}
