//=============================================================================
// HXHKHangingLantern2.
//=============================================================================
class HXHKHangingLantern2 extends HXHangingDecoration;

enum ESkinColor
{
	SC_RedGreen,
	SC_YellowBlue,
	SC_BluePurple
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_RedGreen:   Skin = Texture'HKHangingLantern2Tex1'; break;
			case SC_YellowBlue: Skin = Texture'HKHangingLantern2Tex2'; break;
			case SC_BluePurple: Skin = Texture'HKHangingLantern2Tex3'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local HKHangingLantern2 OtherHKHangingLantern2;

	// Call Super.
	Super.Succeeds( Other );

	// Special HKHangingLantern2 Init.
	OtherHKHangingLantern2 = HKHangingLantern2(Other);
	if ( OtherHKHangingLantern2!=None )
	{
		SetPropertyText( "SkinColor", OtherHKHangingLantern2.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FragType=PaperFragment
	ItemName="Paper Lantern"
	Mesh=HKHangingLantern2
	Skin=HKHangingLantern2Tex1
	PrePivot=(Z=11.0)
	CollisionRadius=7.00
	//CollisionHeight=11.00
	CollisionHeight=10.25
	Mass=20.0
	Buoyancy=5.0
}
