//=============================================================================
// HXHKHangingPig.
//=============================================================================
class HXHKHangingPig extends HXHangingDecoration;

function SpawnBlood(Vector HitLocation, float Damage)
{
	local int i;

	spawn(class'BloodSpurt',,,HitLocation);
	spawn(class'BloodDrop',,,HitLocation);
	for (i=0; i<int(Damage); i+=10)
		spawn(class'BloodDrop',,,HitLocation);
}

auto state Active
{
	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		Super.TakeDamage(Damage, EventInstigator, HitLocation, Momentum, DamageType);
		if ((DamageType == 'Shot') || (DamageType == 'Exploded'))
			SpawnBlood(HitLocation, Damage);
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	HitPoints=100
	FragType=FleshFragment
	ItemName="Slaughtered Pig"
	Mesh=HKHangingPig
	PrePivot=(Z=47.0)
	CollisionRadius=10.00
	//CollisionHeight=47.00
	CollisionHeight=46.25
	Mass=100.0
	Buoyancy=5.0
}
