//=============================================================================
// HXHKMarketTarp.
//=============================================================================
class HXHKMarketTarp extends HXHongKongDecoration;

var() bool bRandomize;
var bool bBlowing;

function BeginPlay()
{
	Super.BeginPlay();

	if (!bRandomize)
		LoopAnim('Blowing');
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local HKMarketTarp OtherHKMarketTarp;

	// Call Super.
	Super.Succeeds( Other );

	// Special HKMarketTarp Init.
	OtherHKMarketTarp = HKMarketTarp(Other);
	if ( OtherHKMarketTarp!=None )
	{
		bRandomize = OtherHKMarketTarp.bRandomize;
	}
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	if (!bRandomize)
		return;

	if (!bBlowing)
	{
		if (FRand() < 0.001)
		{
			LoopAnim('Blowing');
			bBlowing = True;
		}
	}
	else
	{
		if (FRand() < 0.001)
		{
			TweenAnim('Still', 0.1);
			bBlowing = False;
		}
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bRandomize=True
	FragType=PaperFragment
	ItemName="Canvas Tarp"
	bPushable=False
	Physics=PHYS_None
	Mesh=HKMarketTarp
	CollisionRadius=72.00
	//CollisionHeight=15.00
	CollisionHeight=14.25
	Mass=20.0
	Buoyancy=5.0
}
