//=============================================================================
// HXHUDActiveItemsBorder
//=============================================================================
class HXHUDActiveItemsBorder extends HUDActiveItemsBorder;

// ----------------------------------------------------------------------
// AddIcon()
// ----------------------------------------------------------------------

function AddIcon(Texture newIcon, Object saveObject)
{
	local HUDActiveItemBase activeItem;
	local HUDActiveItemBase iconWindow;

	// First make sure this object isn't already in the window
	iconWindow = HUDActiveItemBase(winIcons.GetTopChild());
	while(iconWindow != None)
	{
		// Abort if this object already exists!!
		if (iconWindow.GetClientObject() == saveObject)
			return;

		iconWindow = HUDActiveItemBase(iconWindow.GetLowerSibling());
	}

	// Hide if there are no icons visible
	if (++iconCount == 1)
		Show();

	if (saveObject.IsA('HXAugmentation'))
		activeItem = HUDActiveItemBase(winIcons.NewChild(Class'HUDActiveAug'));
	else
		activeItem = HUDActiveItemBase(winIcons.NewChild(Class'HXHUDActiveItem'));

	activeItem.SetIcon(newIcon);
	activeItem.SetClientObject(saveObject);
	activeItem.SetObject(saveObject);

	AskParentForReconfigure();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
