//=============================================================================
// HXHUDActiveItemsDisplay
//=============================================================================
class HXHUDActiveItemsDisplay extends HUDActiveItemsDisplay;

/*
enum ESchemeTypes
{
	ST_Menu,
	ST_HUD
};

var ESchemeTypes EditMode;
var int          ItemAugsOffsetX;
var int          ItemAugsOffsetY;

var HUDActiveAugsBorder  WinAugsContainer;
var HUDActiveItemsBorder WinItemsContainer;
*/

// ----------------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------------

event InitWindow()
{
	Super(HUDBaseWindow).InitWindow();

	CreateContainerWindows();

	UpdateVisibility();
}

// ----------------------------------------------------------------------------
// CreateContainerWindows()
// ----------------------------------------------------------------------------

function CreateContainerWindows()
{
	WinAugsContainer  = HUDActiveAugsBorder(NewChild(Class'HUDActiveAugsBorder'));
	WinItemsContainer = HXHUDActiveItemsBorder(NewChild(Class'HXHUDActiveItemsBorder'));
}

// ----------------------------------------------------------------------------
// AddIcon()
// ----------------------------------------------------------------------------

function AddIcon(Texture newIcon, Object saveObject)
{
	if (saveObject.IsA('HXAugmentation'))
		WinAugsContainer.AddIcon(newIcon, saveObject);
	else
		WinItemsContainer.AddIcon(newIcon, saveObject);

	//AskParentForReconfigure();
	UpdateVisibility();
}

// ----------------------------------------------------------------------------
// RemoveIcon()
// ----------------------------------------------------------------------------

function RemoveIcon(Object removeObject)
{
	if (removeObject.IsA('HXAugmentation'))
		WinAugsContainer.RemoveObject(removeObject);
	else
		WinItemsContainer.RemoveObject(removeObject);

	//AskParentForReconfigure();
	UpdateVisibility();
}

// ----------------------------------------------------------------------------
// UpdateAugIconStatus()
// ----------------------------------------------------------------------------

function UpdateAugIconStatus(Augmentation aug)
{
	WinAugsContainer.UpdateAugIconStatus(aug);

	UpdateVisibility(); // Wouldn't i want/need this?
}

// ----------------------------------------------------------------------------
// ClearAugmentationDisplay()
// ----------------------------------------------------------------------------

function ClearAugmentationDisplay()
{
	WinAugsContainer.ClearAugmentationDisplay();

	UpdateVisibility(); // Wouldn't i want/need this?
}

// ----------------------------------------------------------------------------
// UpdateVisibility()
//
// Only show if bAugDisplayVisible option is set and one or more icons are
// being displayed,
// ----------------------------------------------------------------------------

function UpdateVisibility()
{
	local HXPlayerPawn PlayerPawn;

	PlayerPawn = HXPlayerPawn(GetRootWindow().ParentPawn);
	if ( PlayerPawn==None || PlayerPawn.bAugDisplayVisible )
	{
		Show( WinAugsContainer.IconCount>0 || WinItemsContainer.IconCount>0 );

		//Log( Sprintf("WinAugsContainer.IconCount=%i",WinAugsContainer.IconCount) );
		//Log( Sprintf("WinItemsContainer.IconCount=%i",WinItemsContainer.IconCount) );
	}
	else
	{
		Hide();
	}

	AskParentForReconfigure();
}

// ----------------------------------------------------------------------------
// SetVisibility()
//
// Only show if one or more icons is being displayed.
// ----------------------------------------------------------------------------

function SetVisibility( bool bNewVisibility )
{
	Warn( "Called." );

	UpdateVisibility();

	//Show( bNewVisibility );
	//AskParentForReconfigure();
}

// ----------------------------------------------------------------------------
// AugsVisible()
// ----------------------------------------------------------------------------

function bool AugsVisible()
{
	return WinAugsContainer.IconCount>0;
}

// ----------------------------------------------------------------------------
// ItemsVisible()
// ----------------------------------------------------------------------------

function bool ItemsVisible()
{
	return WinItemsContainer.IconCount>0;
}

// ----------------------------------------------------------------------------
// ParentRequestedPreferredSize()
// ----------------------------------------------------------------------------

event ParentRequestedPreferredSize( bool bWidthSpecified, out float PreferredWidth, bool bHeightSpecified, out float PreferredHeight )
{
	local float AugsWidth, AugsHeight;
	local float ItemsWidth, ItemsHeight;

	// Augs and Items.
	if ( AugsVisible() && ItemsVisible() )
	{
		WinItemsContainer.QueryPreferredSize( ItemsWidth, ItemsHeight );
		WinAugsContainer.QueryPreferredSize( AugsWidth, AugsHeight );
		
		// Items left to Augs.
		if ( (ItemsHeight+AugsHeight)>PreferredHeight )
		{
			PreferredWidth  = ItemsWidth+AugsWidth;
			PreferredHeight = FMax( AugsHeight, ItemAugsOffsetY+ItemsHeight );
		}
		// Items below Augs.
		else
		{
			PreferredWidth  = FMax( AugsWidth, ItemAugsOffsetX+ItemsWidth );
			PreferredHeight = AugsHeight-2.0+ItemsHeight;
		}
	}
	// Only Augs.
	else if ( AugsVisible() ) // OK.
	{
		WinAugsContainer.QueryPreferredSize( AugsWidth, AugsHeight );

		PreferredWidth  = AugsWidth;
		PreferredHeight = AugsHeight;	
	}
	// Only Items.
	else if ( ItemsVisible() )
	{
		WinItemsContainer.QueryPreferredSize( ItemsWidth, ItemsHeight );

		PreferredWidth  = ItemsWidth+ItemAugsOffsetX;
		PreferredHeight = ItemsHeight;
	}
	// Nothing.
	else
	{
		PreferredWidth  = 0.0;
		PreferredHeight = 0.0;
	}
}

// ----------------------------------------------------------------------------
// ConfigurationChanged()
// ----------------------------------------------------------------------------

function ConfigurationChanged()
{
	local float AugsWidth, AugsHeight;
	local float ItemsWidth, ItemsHeight;
	local float AugOffsetX, ItemOffsetX;

	// Augs and Items.
	if ( AugsVisible() && ItemsVisible() )
	{
		WinItemsContainer.QueryPreferredSize( ItemsWidth, ItemsHeight );
		WinAugsContainer.QueryPreferredSize( AugsWidth, AugsHeight );
		
		// Items left to Augs.
		if ( (AugsHeight+ItemsHeight)>Height )
		{
			WinItemsContainer.ConfigureChild( ItemAugsOffsetX, ItemAugsOffsetY, ItemsWidth, ItemsHeight );
			WinAugsContainer.ConfigureChild( ItemsWidth, 0.0, AugsWidth, AugsHeight);
		}
		// Items below Augs.
		else
		{
			// Aug container is the largest.
			if ( AugsWidth>(ItemAugsOffsetX+ItemsWidth) )
			{
				AugOffsetX  = 0.0;;
				ItemOffsetX = AugsWidth-(ItemAugsOffsetX+ItemsWidth);
			}
			// Item container is the largest.
			else
			{
				AugOffsetX  = (ItemAugsOffsetX+ItemsWidth)-AugsWidth;
				ItemOffsetX = 0.0;
			}

			WinAugsContainer.ConfigureChild( AugOffsetX, 0.0, AugsWidth, AugsHeight );
			WinItemsContainer.ConfigureChild( ItemOffsetX+ItemAugsOffsetX, AugsHeight-2.0, ItemsWidth, ItemsHeight );
		}
	}
	// Only Augs.
	else if ( AugsVisible() )
	{
		WinAugsContainer.QueryPreferredSize( AugsWidth, AugsHeight );
		WinAugsContainer.ConfigureChild( 0.0, 0.0, AugsWidth, AugsHeight );
	}
	// Only Items.
	else if ( ItemsVisible() )
	{
		WinItemsContainer.QueryPreferredSize( ItemsWidth, ItemsHeight );
		WinItemsContainer.ConfigureChild( ItemAugsOffsetX, 0.0, ItemsWidth, ItemsHeight );
	}
}

// ----------------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------------

event bool ChildRequestedReconfiguration( Window ChildWindow )
{
	return false;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemAugsOffsetX=14
	ItemAugsOffsetY=6
}
