//=============================================================================
// HXHUDBarkDisplay
//=============================================================================
class HXHUDBarkDisplay expands HUDBarkDisplay;

// ----------------------------------------------------------------------
// AddBark2()
// ----------------------------------------------------------------------

function AddBark2(string text, float newDisplayTime, string speakingActorUnfamiliarName )
{
	local HXHUDBarkDisplayItem newBark;

	if (TrimSpaces(text) != "")
	{
		newBark = HXHUDBarkDisplayItem(winBarks.NewChild(Class'HXHUDBarkDisplayItem'));
		newBark.SetBarkSpeech(text, newDisplayTime, speakingActorUnfamiliarName );

		barkCount++;

		Show();

		AskParentForReconfigure();
	}
}

// ----------------------------------------------------------------------
// DescendantRemoved()
// ----------------------------------------------------------------------

event DescendantRemoved(Window descendant)
{
	if (descendant.IsA('HXHUDBarkDisplayItem'))
	{
		if (--barkCount == 0)
			Hide();

		AskParentForReconfigure();
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
