//=============================================================================
// HXHUDCompassDisplay
//=============================================================================
class HXHUDCompassDisplay expands HUDCompassDisplay;

var DeusExPlayer PlayerHX;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super(HUDBaseWindow).InitWindow();

	Hide();

	PlayerHX = DeusExPlayer(HXRootWindow(GetRootWindow()).parentPawn);
	//player = DeusExPlayer(GetPlayerPawn());

	SetSize(73, 40);

	clipWidthHalf = clipWidth / 2;

	GetMapTrueNorth();
	CreateCompassWindow();
}


// ----------------------------------------------------------------------
// Tick()
//
// Used to update the position of the compass based on the
// direction the player is facing.
// ----------------------------------------------------------------------

event Tick(float deltaSeconds)
{
	// Only continue if we moved
	if (lastPlayerYaw != PlayerHX.Rotation.Yaw)
	{
		lastPlayerYaw = PlayerHX.Rotation.Yaw;

		// Based on the player's rotation and the map's True North, calculate
		// where to draw the tick marks and letters
		drawPos = clipWidthHalf - (((lastPlayerYaw - mapNorth) & 65535) / UnitsPerPixel);

		// We have two tickmark windows to compensate what happens with
		// the wrap condition.

		if ((drawPos > 0) && (drawPos < clipWidth))
			wrapPos = drawPos - tickWidth;
		else if (drawPos - tickWidth < (clipWidthHalf))
			wrapPos = drawPos + tickWidth;
		else
			wrapPos = 100;

		winCompass1.SetPos(drawPos, 0);
		winCompass2.SetPos(wrapPos, 0);
	}
}

// ----------------------------------------------------------------------
// GetMapTrueNorth()
//
// Gets a pointer to the DeusExLevelInfo object and stores a local
// copy of the map rotation
// ----------------------------------------------------------------------

function GetMapTrueNorth()
{
	local DeusExLevelInfo info;

	// only set it for listen server
	// for clients it is set via GameReplicationInfo.PostNetBeginPlay()
	if ( PlayerHX != None ) 
	//if ( PlayerHX.Level.NetMode == NM_ListenServer )
	{
		info = PlayerHX.GetLevelInfo();

		//foreach player.AllActors(class'DeusExLevelInfo', info)
		//{
		//}

		if ( Info != None )
		{
			//Log( info.MapName );
			//Log( info.MapAuthor );
			//Log( info.MissionLocation );
			//Log( info.missionNumber );
			//Log( info.bMultiPlayerMap );
			//Log( info.Script );
			//Log( info.TrueNorth );
			//Log( info.startupMessage[0] );
			//Log( info.startupMessage[1] );
			//Log( info.startupMessage[2] );
			//Log( info.startupMessage[3] );
			//Log( info.ConversationPackage );

			mapNorth = info.TrueNorth;

			return;
		}
	}

	//Log( "Setting TrueNorth failed" );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	colTickMarks=(R=200,G=200,B=200)
	clipWidth=55
	tickWidth=240
	texBackground=Texture'DeusExUI.UserInterface.HUDCompassBackground_1'
	texBorder=Texture'DeusExUI.UserInterface.HUDCompassBorder_1'
	texTickBox=Texture'DeusExUI.UserInterface.HUDCompassTickBox'
}
