//=============================================================================
// HXHUDLogDisplay
//=============================================================================
class HXHUDLogDisplay extends HUDLogDisplay;

/*
// Windows.
var Window        WinIcon;
var HXTextLogWindow WinLog;

// defaults
var Font  FontLog;
var float LogMargin;
var int   MinLogLines; // !! Read directly off player?
var int   MaxLogLines; // !! Read directly off player?
*/

// ----------------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------------

event InitWindow()
{
	Super(HUDSharedBorderWindow).InitWindow();

	// Create Controls
	CreateControls();

	StyleChanged();
}

// ----------------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------------

function CreateControls()
{
	// Create the icon in the upper left corner
	WinIcon = NewChild(Class'Window');
	WinIcon.SetSize(32, 32);
	WinIcon.SetPos(LogMargin * 2, TopMargin + 5);
	WinIcon.SetBackgroundStyle(DSTY_Masked);
	WinIcon.SetBackground(Texture'LogIcon');

	// Create the text log
	WinLog = HXTextLogWindow(NewChild(Class'HXTextLogWindow'));
	WinLog.SetTextAlignments(HALIGN_Left, VALIGN_Top);
	WinLog.SetTextMargins(0, 0);
	WinLog.SetFont(FontLog);
	WinLog.SetLines(MinLogLines, MaxLogLines);
}

// ----------------------------------------------------------------------------
// ConfigurationChanged()
//
// Set the size of stuff and stuff.
// ----------------------------------------------------------------------------

function ConfigurationChanged()
{
	local float /*QueryWidth,*/ QueryHeight;
	local float WindowStart;

	WinIcon.QueryPreferredSize(WindowStart, QueryHeight);
	WindowStart += (LogMargin * 3);

	// Text Log
	QueryHeight = WinLog.QueryPreferredHeight(Width - WindowStart - LogMargin);
	WinLog.ConfigureChild(WindowStart, TopMargin, Width - WindowStart - LogMargin, QueryHeight);
}

// ----------------------------------------------------------------------------
// ParentRequestedPreferredSize() 
// ----------------------------------------------------------------------------

event ParentRequestedPreferredSize( bool bWidthSpecified, out float PreferredWidth, bool bHeightSpecified, out float PreferredHeight )
{
	//local float QueryHeight;
	local float LogWidth;
	local float WindowStart;
	local float MinWindowHeight;

	if ( bWidthSpecified )
	{
		PreferredHeight =  TopMargin;

		WinIcon.QueryPreferredSize(WindowStart, MinWindowHeight);

		if (MinWindowHeight < minHeight)
			MinWindowHeight = minHeight;

		WindowStart += (LogMargin * 3);

		LogWidth  = PreferredWidth - WindowStart - LogMargin;
		PreferredHeight += WinLog.QueryPreferredHeight(LogWidth) + LogMargin;

		PreferredHeight = Max(MinWindowHeight, PreferredHeight);
	}
}

// ----------------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------------

event bool ChildRequestedReconfiguration( Window ChildWindow )
{
	return false;
}

// ----------------------------------------------------------------------------
// VisibilityChanged()
// ----------------------------------------------------------------------------

event VisibilityChanged( bool bInVisibility )
{
	Super(HUDSharedBorderWindow).VisibilityChanged( bInVisibility );
}

// ----------------------------------------------------------------------------
// HasTimedOut()
// ----------------------------------------------------------------------------

function bool HasTimedOut()
{
	local HXTextLogWindow _WinLog;

	_WinLog = HXTextLogWindow(WinLog);

	return _WinLog==None || _WinLog.NumLines()==0;
}

// ----------------------------------------------------------------------------
// Tick()
//
// Used to display the log Window for 'x' number of seconds before
// hiding it again.
// ----------------------------------------------------------------------------

event Tick( float DeltaTime )
{
	// Hide whenever there is nothing left to display.
	//if ( IsVisible(false) && HasTimedOut() )
		//Hide();
}

// ----------------------------------------------------------------------------
// ClientMessage()
//
// Replaces the old AddLog interace.
// ----------------------------------------------------------------------------

function bool ClientMessage( coerce string Message, optional Name Type, optional bool bBeep )
{
	local HXPlayerPawn PlayerPawn;
	local Color MessageColor;
	local Sound MessageSound;
	local float MessageSoundVolume;
	local float MessageTimeout;

	// Set default text color and no sounds.
	MessageColor       = ColText;
	MessageSound       = None;
	MessageSoundVolume = 0.0;

	if ( HXDeusExHUD(GetParent())!=None )
		HXDeusExHUD(GetParent()).CustomizeMessageType( Type, MessageColor, MessageSound, MessageSoundVolume );

	// Play sound if desired.
	if ( bBeep && MessageSound!=None && MessageSoundVolume>0.0 )
		PlaySound( MessageSound, MessageSoundVolume );

	// Fetch LogTimeout each time a message is displayed.
	PlayerPawn = HXPlayerPawn(GetRootWindow().ParentPawn);
	if ( PlayerPawn!=None )
	{
		if ( Type=='Say' || Type=='TeamSay' )
			MessageTimeout = PlayerPawn.ChatTimeout;
		else
			MessageTimeout = PlayerPawn.LogTimeout;
	}
	else
	{
		MessageTimeout = class'HXPlayerPawn'.default.LogTimeout;
	}

	// Make sure it's at least a small positive number.
	MessageTimeout = FMax( 0.5, MessageTimeout );

	if ( HXTextLogWindow(WinLog)!=None )
		HXTextLogWindow(WinLog).AddLine( Message, MessageColor, MessageTimeout );

	// Could just be always enabled instead.
	//bTickEnabled = true;

	//Show();
	return true;
}

// ----------------------------------------------------------------------------
// SetIcon()
// ----------------------------------------------------------------------------

function SetIcon( Texture InIcon )
{
	WinIcon.SetBackground( InIcon );
}

// ----------------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------------

event StyleChanged()
{
	Super(HUDSharedBorderWindow).StyleChanged();
}

// ----------------------------------------------------------------------------
// Deprecated.
// ----------------------------------------------------------------------------

function AddLog( coerce String InLog, Color InLineColor )
{
	Warn( "Called." );

	ClientMessage( InLog, 'AddLog', false );
}
function SetLogTimeout( float InTimeout )
{
	Warn( "Called." );
}
function SetMaxLogLines( byte InMaxLogLines )
{
	Warn( "Called." );
}
function bool MessagesWaiting()
{
	Warn( "Called." );

	return bMessagesWaiting;
}
function PlayLogSound(Sound newLogSound)
{
	Warn( "Called." );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FontLog=FontMenuSmall_DS
	LogMargin=10.0
	MinLogLines=4
	MaxLogLines=10
	//bTickEnabled=True
}
