//=============================================================================
// HXHUDMedBotNavBarWindow
//=============================================================================
class HXHUDMedBotNavBarWindow expands HXPersonaNavBarBaseWindow;

var PersonaNavButtonWindow HealthButton;
var PersonaNavButtonWindow AugsButton;

var localized String HealthButtonLabel;
var localized String AugsButtonLabel;

// ----------------------------------------------------------------------
// CreateButtons()
// ----------------------------------------------------------------------

function CreateButtons()
{
	AugsButton   = CreateNavButton( WinNavButtons, AugsButtonLabel   );
	HealthButton = CreateNavButton( WinNavButtons, HealthButtonLabel );

	Super.CreateButtons();
}

// ----------------------------------------------------------------------
// CreateButtonWindow()
// ----------------------------------------------------------------------

function CreateButtonWindows()
{
	Super.CreateButtonWindows();

	WinNavButtons.FillAllSpace( false );
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window ButtonPressed )
{
	local HXPersonaScreenHealthMedBot        HealthScreen;
	local HXPersonaScreenAugmentationsMedBot AugsScreen;
	local HXMedicalBot MedBot;

	switch ( ButtonPressed )
	{
		case HealthButton:
			// Need to be sure the MedBot variable is set in the Health Screen when we bring it up.
			AugsScreen = HXPersonaScreenAugmentationsMedBot(GetParent());
			if ( AugsScreen!=None )
			{
				MedBot = AugsScreen.MedBot;

				// Remove MedBot from AugsScreen, so it won't logout on DestroyWindow.
				AugsScreen.SetMedicalBot( None );
			}

			// Invoke the health screen
			HealthScreen = HXPersonaScreenHealthMedBot(Root.InvokeUIScreen(Class'HXPersonaScreenHealthMedBot',true));
			HealthScreen.SetMedicalBot(MedBot);
			return true;
			break;

		case AugsButton:
			// Need to be sure the MedBot variable is set in the Health Screen when we bring it up.
			HealthScreen = HXPersonaScreenHealthMedBot(GetParent());
			if ( HealthScreen!=None )
			{
				MedBot = HealthScreen.MedBot;

				// Remove MedBot from HealthScreen, so it won't logout on DestroyWindow.
				HealthScreen.SetMedicalBot( None );
			}

			AugsScreen = HXPersonaScreenAugmentationsMedBot(Root.InvokeUIScreen(Class'HXPersonaScreenAugmentationsMedBot',true));
			AugsScreen.SetMedicalBot( MedBot );
			return true;
			break;

		default:
			return Super.ButtonActivated( ButtonPressed );
			break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	HealthButtonLabel=" |&Health   "
	AugsButtonLabel="   |&Augmentations   "
}
