//=============================================================================
// HXHUDObjectBelt
//=============================================================================
class HXHUDObjectBelt extends HUDBaseWindow;

var TileWindow winSlots;				// Window containing slots
var HXHUDObjectSlot objects[10];

//var int	KeyRingSlot;
var Bool bInteractive;

// Defaults
var Texture texBackgroundLeft;
var Texture texBackgroundRight;
var Texture texBorder[3];

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super(HUDBaseWindow).InitWindow();

	// Hardcoded size, baby!
	SetSize(541, 69);
	
	CreateSlots();
}

// ----------------------------------------------------------------------
// CreateSlots()
//
// Creates the Slots 
// ----------------------------------------------------------------------

function CreateSlots()
{
	local int i;
	local RadioBoxWindow winRadio;

	// Radio window used to contain objects so they can be selected
	// with the mouse on the inventory screen.

	winRadio = RadioBoxWindow(NewChild(Class'RadioBoxWindow'));
	winRadio.SetSize(504, 54);
	winRadio.SetPos(10, 6);
	winRadio.bOneCheck = False;

	winSlots = TileWindow(winRadio.NewChild(Class'TileWindow'));
	winSlots.SetMargins(0, 0);
	winSlots.SetMinorSpacing(0);
	winSlots.SetOrder(ORDER_LeftThenUp);

	for (i=0; i<ArrayCount(Objects); i++)
	{
		objects[i] = HXHUDObjectSlot(winSlots.NewChild(Class'HXHUDObjectSlot'));
		objects[i].SetObjectNumber(i);
		objects[i].Lower();

		// Last item is a little shorter
		if ( i == 0 )
			objects[i].SetWidth(44);
	}
	objects[0].Lower();

	// Disable dragging for pinned slots.
	for (i=0; i<ArrayCount(Objects); i++)
		Objects[i].AllowDragging( !HXPlayerPawn(Player).BeltPositionPinned(i) );

}

// ----------------------------------------------------------------------
// DrawBackground()
// ----------------------------------------------------------------------

function DrawBackground(GC gc)
{
	local Color newBackground;

	gc.SetStyle(backgroundDrawStyle);
	gc.SetTileColor(colBackground);
	gc.DrawTexture(  2, 6, 9, 54, 0, 0, texBackgroundLeft);
	gc.DrawTexture(514, 6, 8, 54, 0, 0, texBackgroundRight);
}

// ----------------------------------------------------------------------
// DrawBorder()
// ----------------------------------------------------------------------

function DrawBorder(GC gc)
{
	local Color newCol;

	if ( bDrawBorder )
	{
		gc.SetStyle(borderDrawStyle);
		gc.SetTileColor(colBorder);
		gc.DrawTexture(  0, 0, 256, 69, 0, 0, texBorder[0]);
		gc.DrawTexture(256, 0, 256, 69, 0, 0, texBorder[1]);
		gc.DrawTexture(512, 0,  29, 69, 0, 0, texBorder[2]);
	}
}

// ----------------------------------------------------------------------
// SetInteractive()
// ----------------------------------------------------------------------

function SetInteractive( bool bNewInteractive )
{
	local int i;

	bInteractive = bNewInteractive;

	// Update ObjectSlots.
	for ( i=0; i<ArrayCount(Objects); i++ )
		objects[i].bInteractive = bNewInteractive;
}

// ----------------------------------------------------------------------
// GetObjectFromBelt()
// ----------------------------------------------------------------------

function Inventory GetObjectFromBelt( int Position )
{
	return HXPlayerPawn(Player).GetInventoryFromBeltPosition( Position );
}

// ----------------------------------------------------------------------
// SetVisibility()
// ----------------------------------------------------------------------

function SetVisibility( bool bNewVisibility )
{
	Show( bNewVisibility );
}

// ----------------------------------------------------------------------
// AssignWinInv()
// ----------------------------------------------------------------------

function AssignWinInv( HXPersonaScreenInventory newWinInventory )
{
	local Int slotIndex;

	// Update the individual slots
	for (slotIndex=0; slotIndex<ArrayCount(Objects); slotIndex++)
		objects[slotIndex].AssignWinInv(newWinInventory);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	texBackgroundLeft=Texture'DeusExUI.UserInterface.HUDObjectBeltBackground_Left'
	texBackgroundRight=Texture'DeusExUI.UserInterface.HUDObjectBeltBackground_Right'
	texBorder(0)=Texture'DeusExUI.UserInterface.HUDObjectBeltBorder_1'
	texBorder(1)=Texture'DeusExUI.UserInterface.HUDObjectBeltBorder_2'
	texBorder(2)=Texture'DeusExUI.UserInterface.HUDObjectBeltBorder_3'
}
