//=============================================================================
// HXHangingChicken.
//=============================================================================
class HXHangingChicken extends HXHangingDecoration;

function SpawnBlood(Vector HitLocation, float Damage)
{
	local int i;

	spawn(class'BloodSpurt',,,HitLocation);
	spawn(class'BloodDrop',,,HitLocation);
	for (i=0; i<int(Damage); i+=10)
		spawn(class'BloodDrop',,,HitLocation);
}

auto state Active
{
	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		Super.TakeDamage(Damage, EventInstigator, HitLocation, Momentum, DamageType);
		if ((DamageType == 'Shot') || (DamageType == 'Exploded'))
			SpawnBlood(HitLocation, Damage);
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	HitPoints=30
	FragType=FleshFragment
	ItemName="Slaughtered Chicken"
	Mesh=HangingChicken
	PrePivot=(Z=31.68)
	CollisionRadius=15.00
	//CollisionHeight=31.68
	CollisionHeight=30.93
	Mass=60.0
	Buoyancy=5.0
}
