//=============================================================================
// HXHealthPickup.
//=============================================================================
class HXHealthPickup extends HXInstantUsePickup
	abstract;

var const localized String MsgHealedPoint;
var const localized String MsgHealedPoints;
var const localized String MsgHealedPointOn;
var const localized String MsgHealedPointsOn;
var const localized String MsgGotHealedPoint;
var const localized String MsgGotHealedPoints;

var const Sound HealSound;
var const int HealAmount;

// ----------------------------------------------------------------------------
// InstantUse()
// ----------------------------------------------------------------------------

function InstantUse( Pawn OwnerPawn, Actor FrobTarget )
{
	local HXPlayerPawn OwnerPlayer, HealTarget;
	local int SkillHealAmount, PointsHealed;
	local string OwnerPlayerName, TargetPlayerName;

	OwnerPlayer = HXPlayerPawn(OwnerPawn);
	if ( OwnerPlayer==None )
		return;

	SkillHealAmount = OwnerPlayer.CalculateSkillHealAmount( HealAmount );
	if ( SkillHealAmount<=0 )
	{
		Warn( "Expected positive heal amount." );
		return;
	}

	// If we have another Player as the FrobTarget, heal him instead using our medical skill.
	HealTarget = HXPlayerPawn(FrobTarget);
	if ( HealTarget==None )
		HealTarget = OwnerPlayer;

	PointsHealed = HealTarget.HealPlayer( SkillHealAmount, true );

	// We healed ourself.
	if ( HealTarget==OwnerPlayer )
	{
		if ( PointsHealed==1 )
			OwnerPlayer.ClientMessage( Sprintf(MsgHealedPoint,ItemName), 'StatusLine' );
		else
			OwnerPlayer.ClientMessage( Sprintf(MsgHealedPoints,ItemName,PointsHealed), 'StatusLine' );
	}
	// We healed somebody else.
	else
	{
		OwnerPlayerName  = OwnerPlayer.PlayerReplicationInfo.PlayerName;
		TargetPlayerName = HealTarget.PlayerReplicationInfo.PlayerName;

		// I haven't yet fully bought into sending it as a status line to HealTarget. --han
		if ( PointsHealed==1 )
		{
			OwnerPlayer.ClientMessage( Sprintf(MsgHealedPointOn,ItemName,TargetPlayerName), 'StatusLine' );
			HealTarget.ClientMessage( Sprintf(MsgGotHealedPoint,OwnerPlayerName), 'StatusLine' );
		}
		else
		{
			OwnerPlayer.ClientMessage( Sprintf(MsgHealedPointsOn,ItemName,PointsHealed,TargetPlayerName), 'StatusLine' );
			HealTarget.ClientMessage( Sprintf(MsgGotHealedPoints,PointsHealed,OwnerPlayerName), 'StatusLine' );
		}
	}

	if ( HealSound!=None )
		OwnerPlayer.PlaySound( HealSound, SLOT_None,,, 256 );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	M_Activated=""
	MsgHealedPoint="%s healed 1 point"
	MsgHealedPoints="%s healed %d points"
	MsgHealedPointOn="%s healed 1 point on %s"
	MsgHealedPointsOn="%s healed %d points on %s"
	MsgGotHealedPoint="You got healed 1 point by %s"
	MsgGotHealedPoints="You got healed %s points by %s"
	HealSound=MedicalHiss
}
