//=============================================================================
// HXHumanScriptedPawn.
//=============================================================================
class HXHumanScriptedPawn extends HXScriptedPawn
	abstract;

// ----------------------------------------------------------------------------
// WillTakeStompDamage()
// ----------------------------------------------------------------------------

function bool WillTakeStompDamage( Actor Stomper )
{
	local PlayerPawn PlayerStomper;

	// This blows chunks!
	if ( Stomper.bIsPawn )
	{
		PlayerStomper = PlayerPawn(Stomper);
		if ( PlayerStomper!=None && GetPawnAllianceType(PlayerStomper)!=ALLIANCE_Hostile )
			return false;
	}

	return true;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	Intelligence=BRAINS_HUMAN
	bPlayIdle=True
	bCanTurnHead=True
	WaterSpeed=80.0
	AirSpeed=160.0
	AccelRate=500.0
	BaseEyeHeight=40.0
	UnderWaterTime=20.0
	AttitudeToPlayer=ATTITUDE_Ignore
	HitSound1=MalePainSmall
	HitSound2=MalePainMedium
	Die=MaleDeath
	VisibilityThreshold=0.01
	DrawType=DT_Mesh
	Mass=150.0
	Buoyancy=155.0
	bIsHuman=True
}
