//=============================================================================
// HXImageReplicationInfo.
//=============================================================================
class HXImageReplicationInfo extends ReplicationInfo;

const DATAVAULT_IMAGE_MAX_COUNT = 48;

var int bHasDataVaultImage[48]; // Why not byte?
var class<DataVaultImage> DataVaultImageClasses[48];

// ----------------------------------------------------------------------
// replication
// ----------------------------------------------------------------------

replication
{
	reliable if ( Role == ROLE_Authority )
		bHasDataVaultImage;
}

// ----------------------------------------------------------------------
// PostNetBeginPlay()
// ----------------------------------------------------------------------

simulated function PostNetBeginPlay()
{
	local int i;

	Super.PostNetBeginPlay();

	//Log( Self $ ".PostNetBeginPlay() called." );
}

// ----------------------------------------------------------------------
// AddImage()
// ----------------------------------------------------------------------

function bool AddImage( class<DataVaultImage> newImageClass )
{
	local int i;

	//Log( Self $ ".AddImage( " $ newImageClass $ " ) called." );

	if ( newImageClass == None )
		return false;

	for ( i = 0; i < DATAVAULT_IMAGE_MAX_COUNT; i++ )
	{
		if ( DataVaultImageClasses[i] == newImageClass )
		{
			if ( bHasDataVaultImage[i] == 1 )
			{
				return false;
			}
			else
			{
				bHasDataVaultImage[i] = 1;
				return true;
			}
		}
	}

	return false;
}

// ----------------------------------------------------------------------------
// PruneCurrent()
//
// Called before current map progress is saved just before switching level.
// Out parameter can be used to flag or unflag actor as transient.
//
// Be aware that this can break linked lists such as Level.PawnList.
// ----------------------------------------------------------------------------

simulated event PruneCurrent( out byte bTransient )
{
	bTransient = 1;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bGameRelevant=True
	DataVaultImageClasses(0)=Class'DeusEx.Image01_GunFireSensor'
	DataVaultImageClasses(1)=Class'DeusEx.Image01_LibertyIsland'
	DataVaultImageClasses(2)=Class'DeusEx.Image01_TerroristCommander'
	DataVaultImageClasses(3)=Class'DeusEx.Image02_Ambrosia_Flyer'
	DataVaultImageClasses(4)=Class'DeusEx.Image02_NYC_Warehouse'
	DataVaultImageClasses(5)=Class'DeusEx.Image02_BobPage_ManOfYear'
	DataVaultImageClasses(6)=Class'DeusEx.Image03_747Diagram'
	DataVaultImageClasses(7)=Class'DeusEx.Image03_NYC_Airfield'
	DataVaultImageClasses(8)=Class'DeusEx.Image03_WaltonSimons'
	DataVaultImageClasses(9)=Class'DeusEx.Image04_NSFHeadquarters'
	DataVaultImageClasses(10)=Class'DeusEx.Image04_UNATCONotice'
	DataVaultImageClasses(11)=Class'DeusEx.Image05_GreaselDisection'
	DataVaultImageClasses(12)=Class'DeusEx.Image05_NYC_MJ12Lab'
	DataVaultImageClasses(13)=Class'DeusEx.Image06_HK_Market'
	DataVaultImageClasses(14)=Class'DeusEx.Image06_HK_MJ12Helipad'
	DataVaultImageClasses(15)=Class'DeusEx.Image06_HK_MJ12Lab'
	DataVaultImageClasses(16)=Class'DeusEx.Image06_HK_Versalife'
	DataVaultImageClasses(17)=Class'DeusEx.Image06_HK_WanChai'
	DataVaultImageClasses(18)=Class'DeusEx.Image08_JoeGreenMIBMJ12'
	DataVaultImageClasses(19)=Class'DeusEx.Image09_NYC_Ship_Bottom'
	DataVaultImageClasses(20)=Class'DeusEx.Image09_NYC_Ship_Top'
	DataVaultImageClasses(21)=Class'DeusEx.Image10_Paris_Catacombs'
	DataVaultImageClasses(22)=Class'DeusEx.Image10_Paris_CatacombsTunnels'
	DataVaultImageClasses(23)=Class'DeusEx.Image10_Paris_Metro'
	DataVaultImageClasses(24)=Class'DeusEx.Image11_Paris_Cathedral'
	DataVaultImageClasses(25)=Class'DeusEx.Image11_Paris_CathedralEntrance'
	DataVaultImageClasses(26)=Class'DeusEx.Image12_Vandenberg_Command'
	DataVaultImageClasses(27)=Class'DeusEx.Image12_Vandenberg_Sub'
	DataVaultImageClasses(28)=Class'DeusEx.Image12_Tiffany_HostagePic'
	DataVaultImageClasses(29)=Class'DeusEx.Image14_OceanLab'
	DataVaultImageClasses(30)=Class'DeusEx.Image14_Schematic'
	DataVaultImageClasses(31)=Class'DeusEx.Image15_Area51Bunker'
	DataVaultImageClasses(32)=Class'DeusEx.Image15_GrayDisection'
	DataVaultImageClasses(33)=Class'DeusEx.Image15_BlueFusionDevice'
	DataVaultImageClasses(34)=Class'DeusEx.Image15_Area51_Sector3'
	DataVaultImageClasses(35)=Class'DeusEx.Image15_Area51_Sector4'
	RemoteRole=ROLE_SimulatedProxy
	NetUpdateFrequency=100.000000
}
