//=============================================================================
// HXIncenseBurnerSmokeGenerator.
//=============================================================================
class HXIncenseBurnerSmokeGenerator extends HXEffects;
/*
var() float frequency;			// what's the chance of spewing a particle every checkTime seconds
var() float riseRate;			// how fast do the particles rise
var() float ejectSpeed;			// how fast do the particles get ejected
var() texture particleTexture;	// replacement texture to use (default is smoke)
var() float particleLifeSpan;	// how long each particle lives
var() float particleDrawScale;	// draw scale for each particle
var() bool bParticlesUnlit;		// is each particle unlit?
var() bool bScale;				// scale each particle as it rises?
var() bool bFade;				// fade each particle as it rises?
var() bool bTriggered;			// start by triggering?
var() float spewTime;			// how long do I spew after I am triggered?
var() bool bRandomEject;		// random eject velocity vector
var() float checkTime;			// how often should I spit out particles?
var() bool bTranslucent;		// are these particles translucent?
var() bool bGravity;			// are these particles affected by gravity?
var() sound spawnSound;			// sound to play when spawned
var() bool bAmbientSound;		// play the ambient sound?
var() int numPerSpawn;			// number of particles to spawn per puff
var() name attachTag;			// attach us to this actor
var() bool bInitiallyOn;		// if triggered, start on instead of off
var bool bSpewing;				// am I spewing?
var bool bFrozen;				// are we out of the player's sight?
var float time;
var bool bDying;				// don't spew, but continue to update
var() bool bModulated;			// are these particles modulated?

var vector pLoc;				// Location used for replication, ParticleIterator uses these now
var rotator pRot;				// Rotation used for replication, ParticleIterator uses these now

var ParticleProxy proxy;

var Actor SmokeOwner; // Actor we are tied to.

// ----------------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------------

simulated function Tick( float DeltaTime )
{
	local int i;

	// Update our Location.
	if ( SmokeOwner!=None && !SmokeOwner.bDeleteMe )
	{
		SetLocation( SmokeOwner.Location + Vect(0,0,1) * SmokeOwner.CollisionHeight * 0.6 );
	}
	// If smoke owner is no longer valid stop spewing, etc.
	else
	{
		LifeSpan = 0;
		DelayedDestroy();
	}

	// Determine if we are frozen.
	bFrozen = True;
	if ( Proxy!=None )
	{
		// Don't freeze if we're dying
		if ( bDying )
		{
			bFrozen = False;
		}
		// If we are close.
		else if ( Proxy.DistanceFromPlayer<1000 || Proxy.LastRendered()<5.0 )
		{
			bFrozen = False;
		}
		// Can the player see our SmokeOwner?
		else if ( SmokeOwner!=None &&  SmokeOwner.LastRendered()<5.0 )
		{
			bFrozen = False;
		}
	}

	// Check LifeSpan and see if we need to DelayedDestroy()
	if ( LifeSpan>0 && LifeSpan<=1.0 )
	{
		LifeSpan = 0;
		DelayedDestroy();
	}

	// Return if we are frozen.
	if ( bFrozen )
		return;

	Super.Tick( DeltaTime );

	if ( Proxy!=None && Proxy.Texture!=ParticleTexture )
		SetProxyData();

	// tick the iterator since Objects don't Tick()
	if ( ParticleIterator(RenderInterface)!=None )
		ParticleIterator(RenderInterface).Update( DeltaTime );

	// Don't spew anymore if we're dying.
	if ( bDying || !bSpewing )
		return;

	Time += DeltaTime;

	if ( Time>CheckTime )
	{
		Time = 0;

		if ( FRand()<=Frequency )
			for ( i=0; i<NumPerSpawn; i++ )
				if ( ParticleIterator(RenderInterface)!=None )
					ParticleIterator(RenderInterface).AddParticle();
	}
}

// ----------------------------------------------------------------------------
// DelayedDestroy()
//
// Don't actually destroy the generator until after all of the
// particles have disappeared
// ----------------------------------------------------------------------------

simulated function DelayedDestroy()
{
	bDying = True;
	SetTimer( 1.0, True );
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

simulated function Timer()
{
	if ( ParticleIterator(RenderInterface)!=None )
	{
		if ( ParticleIterator(RenderInterface).IsListEmpty() )
			Destroy();
	}
	else // MB - We are most likely the server with no render interface, so kill it.
		Destroy();
}

// ----------------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------------

simulated function Destroyed()
{
	if ( Proxy!=None )
	{
		Proxy.Destroy();
		Proxy = None;
	}
	Super.Destroyed();
}

// ----------------------------------------------------------------------------
// SetProxyData()
// ----------------------------------------------------------------------------

simulated function SetProxyData()
{
	if ( Proxy!=None )
	{
		Proxy.bUnlit = bParticlesUnlit;

		if ( bModulated )
			Proxy.Style = STY_Modulated;
		else if ( bTranslucent )
			Proxy.Style = STY_Translucent;
		else
			Proxy.Style = STY_Masked;

		if ( ParticleTexture!=None )
			Proxy.Texture = ParticleTexture;
	}
}

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	// Create our proxy particle.
	if ( Proxy==None )
	{
		Proxy = Spawn( Class'ParticleProxy',,, Location, Rotation );
		SetProxyData();
	}
}
*/
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
/*
	Frequency=0.900000
	RiseRate=0.000000
	ejectSpeed=10.000000
	particleLifeSpan=4.000000
	particleDrawScale=0.200000
	bParticlesUnlit=True
	bScale=True
	bFade=True
	checkTime=0.250000
	bRandomEject=True
	bTranslucent=True
	numPerSpawn=1
	bInitiallyOn=True
	bSpewing=True
	bDirectional=True
	DrawType=DT_None
	Texture=Texture'Engine.S_Inventory'
	CollisionRadius=80.000000
	CollisionHeight=80.000000
	ParticleTexture=Texture'Effects.Smoke.SmokePuff1'
	RenderIteratorClass=Class'DeusEx.ParticleIterator'
*/
defaultproperties
{
}
