//=============================================================================
// HXInformationDevices.
//=============================================================================
class HXInformationDevices extends HXDecoration
	abstract;

var() name					textTag;
var() string				TextPackage;
var() class<DataVaultImage>	imageClass;

//var transient HUDInformationDisplay infoWindow;		// Window to display the information in
//var transient TextWindow winText;				// Last text window we added
//var Bool bSetText;
var Bool bAddToVault;					// True if we need to add this text to the DataVault
//var String vaultString;
//var DeusExPlayer aReader;				// who is reading this?
var localized String msgNoText;
//var Bool bFirstParagraph;
var localized String ImageLabel;
var localized String AddedToDatavaultLabel;

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
  // server to client
  reliable if (Role == ROLE_Authority)
		textTag, TextPackage, imageClass;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local InformationDevices OtherInformationDevices;

	// Call Super.
	Super.Succeeds( Other );

	// Special InformationDevices Init.
	OtherInformationDevices = InformationDevices(Other);
	if ( OtherInformationDevices!=None )
	{
		TextTag     = OtherInformationDevices.TextTag;
		TextPackage = OtherInformationDevices.TextPackage;
		ImageClass  = OtherInformationDevices.ImageClass;	
	}
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	Super.Frob(Frobber, frobWith);

	if ( bAddToVault )
		AddToVault();
}

// ----------------------------------------------------------------------------
// AddToVault()
// ----------------------------------------------------------------------------

function AddToVault()
{
	local DeusExTextParser parser;
	local DataVaultImage image;
	local bool bImageAdded;
	local bool bFirstParagraph;
	local String vaultString;

	// First check to see if we have a name
	if ( textTag != '' )
	{
		// Create the text parser
		parser = new(None) Class'DeusExTextParser';
								    
		// Attempt to find the text object
		//if ((aReader != None) && (parser.OpenText(textTag,TextPackage)))
		if (parser.OpenText(textTag,TextPackage))
		{
			parser.SetPlayerName(class'HXPlayerPawn'.default.TruePlayerName);

			//infoWindow = rootWindow.hud.ShowInfoWindow();
			//infoWindow.ClearTextWindows();

			vaultString = "";
			bFirstParagraph = True;

			while(parser.ProcessText())
				bFirstParagraph = ProcessTag(parser, vaultString, bFirstParagraph);

			parser.CloseText();

			//if (HXGameInfo(Level.Game).GetNote(textTag) == None)
			//{
				HXGameInfo(Level.Game).AddNote(vaultString, , True, textTag);
			//}

			vaultString = ""; // HX_NOTE: ???
		}
		CriticalDelete(parser);
	}

	// do we have any image data to give the player?
	//if ((imageClass != None) && (aReader != None))

	if ( imageClass != None )
	{
		//image = Spawn(imageClass, aReader);
		//if (image != None)  
		//{
			//image.GiveTo(aReader);
			//image.SetBase(aReader);
			//bImageAdded = aReader.AddImage(image);
			bImageAdded = HXGameInfo(Level.Game).AddImage( imageClass );

			// Display a note to the effect that there's an image here, 
			// but only if nothing else was displayed
			//if (infoWindow == None)
			//{
				//infoWindow = rootWindow.hud.ShowInfoWindow();
				//winText = infoWindow.AddTextWindow();
				//winText.SetText(Sprintf(ImageLabel, image.imageDescription));
			//}

			// Log the fact that the user just got an image.
			if (bImageAdded)
			{
				BroadcastMessage(Sprintf(AddedToDatavaultLabel, imageClass.default.imageDescription));
			}
		//}
	}

}

// ----------------------------------------------------------------------------
// ProcessTag()
// ----------------------------------------------------------------------------

function bool ProcessTag(DeusExTextParser parser, out string vaultString, bool bFirstParagraph )
{
	local String text;
	local byte tag;
	local Name fontName;
	local String textPart;

	tag  = parser.GetTag();

	switch(tag)
	{
		// If a winText window doesn't yet exist, create one.
		// Then add the text
		case 0:				// TT_Text:
		case 9:				// TT_PlayerName:
		case 10:			// TT_PlayerFirstName:
			text = parser.GetText();
			vaultString = vaultString $ text;
			break;

		// Create a new text window
		case 18:			// TT_NewParagraph:
			// Only add a return if this is not the *first*
			// paragraph.
			if (!bFirstParagraph)
				vaultString = vaultString $ CR();

			bFirstParagraph = False;
			break;

		case 15:			// TT_DefaultColor:
		case 16:			// TT_TextColor:
		case 17:			// TT_RevertColor:
			//winText.SetTextColor(parser.GetColor());
			break;
	}

	return bFirstParagraph;
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bIsInformationDevice=True
	TextPackage="DeusExText"
	MsgNoText="There's nothing interesting to read"
	ImageLabel="[Image: %s]"
	AddedToDatavaultLabel="Image %s added to DataVault"
	FragType=PaperFragment
	bPushable=False
}
