//=============================================================================
// HXInstantUsePickup.
//
// Pickup which is instantly used when activated.
//=============================================================================
class HXInstantUsePickup extends HXDeusExPickup
	abstract;

var const string MsgActivated;

// ----------------------------------------------------------------------------
// InstantUse()
// ----------------------------------------------------------------------------

function InstantUse( Pawn OwnerPawn, Actor FrobTarget )
{
}

// ----------------------------------------------------------------------------
// ActivateOn()
// ----------------------------------------------------------------------------

function ActivateOn( Actor FrobTarget )
{
	local Pawn PawnOwner;

	if( !bActivatable || bDeleteMe )
		return;

	// Does message and logging.
	Super.ActivateOn( FrobTarget );

	PawnOwner = Pawn(Owner);
	if ( PawnOwner==None )
		Warn( Sprintf("Item activated without Owner.") );
	else if ( MsgActivated!="" )
		PawnOwner.ClientMessage( MsgActivated, 'StatusLine' );

	InstantUse( PawnOwner, FrobTarget );

	UseOnce();
}

//=============================================================================
// state Activated
//=============================================================================

state Activated
{
}

//=============================================================================
// state Deactivated
//=============================================================================

state Deactivated
{
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
}
