//=============================================================================
// HXInterpolateTrigger.
//
// Send an actor on a spline path through the level
// Copied and modified from Engine.SpecialEvent
// Set this trigger's Event to match the Tag of the target actor
// The target actor's Event should match the Tag of the InterpolationPoints.
//=============================================================================
class HXInterpolateTrigger extends HXTrigger;

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	if ( SendActorOnPath() )
	{
		Super.Trigger( Other, Instigator );
		if ( bTriggerOnceOnly )
			Destroy();
	}
}

// ----------------------------------------------------------------------------
// Touch()
// ----------------------------------------------------------------------------

singular function Touch(Actor Other)
{
	if ( !IsRelevant(Other) )
		return;

	if ( SendActorOnPath() )
		if ( bTriggerOnceOnly )
			Destroy();
}

// ----------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------

function bool SendActorOnPath()
{
	local InterpolationPoint I;
	local Actor A;
	local Pawn CurPawn;

	Log( Self $ ".SendActorOnPath() Event = " $ Event );
	
	// find the target actors to start on the path
	foreach AllActors (class'Actor', A, Event)
	{
		if ( A!=None && !A.IsA('InterpolationPoint') )
		{
			foreach AllActors( class'InterpolationPoint', I, A.Event )
			{
				// Start at 1 instead of 0 - put 0 at the object's initial position..
				if ( I.Position==1 )
				{
					Log( "Initiating Interpolation for " $ A );

					// HX_Note: change remote role, so the client has controll over it.
					if ( !A.IsA('PlayerPawn') )
					{
						A.bCarriedItem  = true; // Removes unreliable Location and Rotation updates.
						A.RemoteRole    = ROLE_SimulatedProxy;

						A.SetCollision( false, false, false );
						A.bCollideWorld = false;

						A.Target        = I;

						A.SetPhysics(PHYS_Interpolating);

						A.PhysRate       = 1.0;
						A.PhysAlpha      = 0.0;
						A.bInterpolating = true;
						A.bStasis        = false;

						A.GotoState('Interpolating');
					}
					break;
				}
			}
		}
	}

	// Replicate.
	for ( CurPawn=Level.PawnList; CurPawn!=None; CurPawn=CurPawn.NextPawn )
		if ( CurPawn.bIsPlayer && CurPawn.IsA('HXPlayerPawn') && CurPawn!=GetPlayerPawn() )
			HXPlayerPawn(CurPawn).SendActorOnPath( Event );

	return true;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
	bTriggerOnceOnly=True
	CollisionRadius=96.000000
}
