//=============================================================================
// HXInterpolationDummy.
//
// Runs along interpolation path and triggers the map change,
// like the player did in vanilla dx.
//=============================================================================
class HXInterpolationDummy extends HXInfo
	transient;

var() string NextMap;
var() bool bItems;

event InterpolateEnd( Actor Other )
{
	//Log( Self $ ".InterpolateEnd( " $ Other $ " )" );

	if ( InterpolationPoint(Other).bEndOfPath )
	{
		// Reset physics, as InterpolateEnd() on IP will have set them to falling.
		SetPhysics( PHYS_None );

		Level.ServerTravel( NextMap, bItems );
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bItems=True
	bHidden=True
	bCollideActors=False
	bCollideWorld=False
	bBlockActors=False
	bBlockPlayers=False
	RemoteRole=ROLE_None
}
