//=============================================================================
// HXKeypad.
//=============================================================================
class HXKeypad extends HXHackableDevices
	abstract;

var() string ValidCode;
var() Sound SuccessSound;
var() Sound FailureSound;
var() name FailEvent;
var() bool bToggleLock;		// if True, toggle the lock state instead of triggering

var transient HXHUDKeypadWindow keypadwindow; // FIX-ME: Dangerous!

// ----------------------------------------------------------------------------
// Network replication.
// ----------------------------------------------------------------------------

replication
{
   //server to client variables
   reliable if ( Role == ROLE_Authority )
      bToggleLock, FailEvent, ValidCode;
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Keypad OtherKeypad;

	// Call Super.
	Super.Succeeds( Other );

	// Special Keypad Init.
	OtherKeypad = Keypad(Other);
	if ( OtherKeypad!=None )
	{
		ValidCode    = OtherKeypad.ValidCode;
		SuccessSound = OtherKeypad.SuccessSound;
		FailureSound = OtherKeypad.FailureSound;
		FailEvent    = OtherKeypad.FailEvent;
		bToggleLock  = OtherKeypad.bToggleLock;
	}
}

// ----------------------------------------------------------------------------
// HackAction()
// ----------------------------------------------------------------------------

function HackAction(Actor Hacker, bool bHacked)
{
	local HXPlayerPawn Player;

	// if we're already using this keypad, get out
	if (keypadwindow != None)
		return;

	Player = HXPlayerPawn(Hacker);

	if (Player != None)
	{
      // DEUS_EX AMSD if we are in multiplayer, just act based on bHacked
      // if you want keypad windows to work in multiplayer, just get rid of this
      // if statement.  I've already got the windows working, they're just disabled.
      //if (Level.NetMode != NM_Standalone)
      //{
         //if (bHacked)
         //{
            //ToggleLocks(Player);
            //RunEvents(Player,True);
            //RunUntriggers(Player);
         //}
         //return;
      //}
      
      //DEUS_EX AMSD Must call in player for replication to work.
      Player.HXActivateKeypadWindow(Self, bHacked);
	}
}

// ----------------------------------------------------------------------------
// ActivateKeypadWindow
// DEUS_EX AMSD Bounce back call from player so function rep works right.
// ----------------------------------------------------------------------------
simulated function ActivateKeypadWindow(DeusExPlayer Hacker, bool bHacked)
{
	local HXRootWindow root;

   root = HXRootWindow(Hacker.rootWindow);
   if (root != None)
   {
      keypadwindow = HXHUDKeypadWindow(root.InvokeUIScreen(Class'HXHUDKeypadWindow', True));
      root.MaskBackground(True);
      
      // copy the tag data to the actual class
      if (keypadwindow != None)
      {
         keypadwindow.keypadOwner = Self;
         keypadwindow.player = Hacker;
         keypadwindow.bInstantSuccess = bHacked;
         keypadwindow.InitData();
      }
   }
}

// ----------------------------------------------------------------------------
// RunUntriggers()
// DEUS_EX AMSD Bounce back call from player so function rep works right.
// ----------------------------------------------------------------------------
function RunUntriggers(DeusExPlayer Player)
{
   local Actor A;
   local int i;

   for (i=0; i<ArrayCount(UnTriggerEvent); i++)
   {
      if (UnTriggerEvent[i] != '')
      {
         foreach AllActors(class 'Actor', A, UnTriggerEvent[i])
         {
            A.UnTrigger(Self, Player);
         }
      }
   }
}

// ----------------------------------------------------------------------------
// RunEvents()
// ----------------------------------------------------------------------------
function RunEvents(DeusExPlayer Player, bool bSuccess)
{
   local Actor A;

   if ((bSuccess) && (Event != ''))
   {
      foreach AllActors(class 'Actor', A, Event)
         A.Trigger(Self, Player);
   }
   else if ((!bSuccess) && (FailEvent != ''))
   {
      foreach AllActors(class 'Actor', A, FailEvent)
         A.Trigger(Self, Player);
   }
}

// ----------------------------------------------------------------------------
// ToggleLocks()
// ----------------------------------------------------------------------------
function ToggleLocks(DeusExPlayer Player)
{
   local Actor A;
   if (bToggleLock)
   {
      foreach AllActors(class 'Actor', A, Event)
         if (A.IsA('HXMover'))
            HXMover(A).bLocked = !HXMover(A).bLocked;
   }
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ValidCode="1234"
	SuccessSound=Beep2
	FailureSound=Buzz1
	bToggleLock=True
	ItemName="Security Keypad"
	Mass=10.0
	Buoyancy=5.0
}
