//=============================================================================
// HXKeypoint.
//
// The base class of invisible actors which mark things.
//=============================================================================
class HXKeypoint extends Keypoint
	abstract
	native;

var transient HXGameInfo Game;
var Name PrecessorName;
var bool bSpawning;

// ----------------------------------------------------------------------------
// IsInRelevant()
// 
// Whether code is currently running during a spawn inside a mutator in which
// case the properties are not yet properly set.
// ----------------------------------------------------------------------------

simulated function bool IsInRelevant()
{
	if ( Level.Game==None ) // Will happen on client too.
		return false;
	return Level.Game.IsInState( 'InIsRelevant' );
}

// ----------------------------------------------------------------------------
// Spawned()
// ----------------------------------------------------------------------------

simulated event Spawned()
{
	Super.Spawned();

	if ( Level.bStartup )
		bGameRelevant = true;

	Game = HXGameInfo(Level.Game);
}

// ----------------------------------------------------------------------------
// PreBeginPlay()
// ----------------------------------------------------------------------------

function PreBeginPlay()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	// Handle autodestruction if desired. Moved this here because the
	// config properties won't have their correct value set when spawned inside
	// the mutator, so you can't replace them at first pass there.
	if ( !bGameRelevant && Level.NetMode!=NM_Client && !Level.Game.IsRelevant(Self) )
	{
		Destroy();
		return;
	}
}

// ----------------------------------------------------------------------------
// SetInitialState()
//
// Called after PostBeginPlay.
// ----------------------------------------------------------------------------

simulated event SetInitialState()
{
	if ( bDeleteMe || IsInRelevant() )
		return;

	if ( InitialState!='' )
		GotoState( InitialState );
	else
		GotoState( 'Auto' );

	bSpawning = false;
}

// ----------------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------------

event PostPostBeginPlay()
{
	// This may need to be reset, as a new GameInfo is spawned each time.
	Game = HXGameInfo(Level.Game);

	Super.PostPostBeginPlay();
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	// Save Precessors name aside for debugging purposes.
	PrecessorName        = Other.Name;

	// Advanced.
//bStatic              = Other.bStatic;             // Nope. Defined by defaultproperties.
	bHidden              = Other.bHidden;
//bNoDelete            = Other.bNoDelete;           // Nope. Defined by defaultproperties.
	bCanTeleport         = Other.bCanTeleport;        // Do I want this?
	bIsSecretGoal        = Other.bIsSecretGoal;
	bIsKillGoal          = Other.bIsKillGoal;
	bIsItemGoal          = Other.bIsItemGoal;
	bCollideWhenPlacing  = Other.bCollideWhenPlacing; // Still used by FarMove.
//bTravel              = Other.bTravel;             // Do not mess with this.
//bMovable             = Other.bMovable;            // Do not mess with this.
//bHighDetail          = Other.bHighDetail;         // Nah, do not mess with this.
//bStasis              = Other.bStasis;             // Rather not-ish.
//bForceStasis         = Other.bForceStasis;        // Rather not-ish.
//NetTemporary         = Other.NetTemporary;        // Certainly not.
//bNetOptional         = Other.bNetOptional;        // Certainly not.
  bBlockSight          = Other.bBlockSight;
  bDetectable          = Other.bDetectable;
//bTransient           = Other.bTransient;          // Rather not-ish.
	LifeSpan             = Other.LifeSpan;
	bHiddenEd            = Other.bHiddenEd;           // Editing flag.
	bDirectional         = Other.bDirectional;        // Editing flag.
	bEdShouldSnap        = Other.bEdShouldSnap;       // Editing flag.
//bOwnerNoSee          = Other.bOwnerNoSee;         // Rather not-ish.
//bOnlyOwnerSee        = Other.bOnlyOwnerSee;       // Rather not-ish.
//bAlwaysRelevant      = Other.bAlwaysRelevant;     // Certainly not-ish.
//bGameRelevant        = Other.bGameRelevant;       // Rather uncertain-ish.
	bOwned               = Other.bOwned;

	// Collision.
	SetCollisionSize( Other.CollisionRadius, Other.CollisionHeight );
	SetCollision( Other.bCollideActors, Other.bBlockActors, Other.bBlockPlayers );
	bCollideWorld	       = Other.bCollideWorld;
	bProjTarget          = Other.bProjTarget;

	// Conversation.
	BindName             = Other.BindName;         // !! Shadowed for ConversationTrigger.
	BarkBindName         = Other.BarkBindName;
	FamiliarName         = Other.FamiliarName;
	UnfamiliarName       = Other.UnfamiliarName;
	ConStartInterval     = Other.ConStartInterval;

	// Display.
	DrawType             = Other.DrawType;
	Style                = Other.Style;
	Sprite               = Other.Sprite;
	Texture              = Other.Texture;
	Skin                 = Other.Skin;
	MultiSkins[0]        = Other.MultiSkins[0];
	MultiSkins[1]        = Other.MultiSkins[1];
	MultiSkins[2]        = Other.MultiSkins[2];
	MultiSkins[3]        = Other.MultiSkins[3];
	MultiSkins[4]        = Other.MultiSkins[4];
	MultiSkins[5]        = Other.MultiSkins[5];
	MultiSkins[6]        = Other.MultiSkins[6];
	MultiSkins[7]        = Other.MultiSkins[7];
	Mesh                 = Other.Mesh;
	DrawScale            = Other.DrawScale;
	ScaleGlow            = Other.ScaleGlow;
	AmbientGlow          = Other.AmbientGlow;
	Fatness              = Other.Fatness;
	bUnlit               = Other.bUnlit;
//bNoSmooth            = Other.bNoSmooth;           // Not replicated.
//bParticles           = Other.bParticles;          // Not replicated.
//bRandomFrame         = Other.bRandomFrame;        // Not replicated.
	bMeshEnviroMap       = Other.bMeshEnviroMap;
//bMeshCurvy           = Other.bMeshCurvy;          // Not replicated.
//VisibilityRadius     = Other.VisibilityRadius;    // Not replicated.
//VisibilityHeight     = Other.VisibilityHeight;    // Not replicated.
//bShadowCast          = Other.bShadowCast;         // Not replicated.
	AnimSequence         = Other.AnimSequence;        // Preset?
	AnimFrame            = Other.AnimFrame;           // Preset? Implicit replicated?
	AnimRate             = Other.AnimRate;            // Preset? Implicit replicated?
//LODBias              = Other.LODBias;             // Not replicated.
//RenderIteratorClass  = Other.RenderIteratorClass; // Not replicated.

	// Events. 
	Event                = Other.Event;
//Tag                  = Other.Tag;   // Set by Spawn.

	// Filter.
	bDifficulty0         = Other.bDifficulty0;
	bDifficulty1         = Other.bDifficulty1;
	bDifficulty2         = Other.bDifficulty2;
	bDifficulty3         = Other.bDifficulty3;
	bSinglePlayer        = Other.bSinglePlayer;
	bNet                 = Other.bNet;
	bNetSpecial          = Other.bNetSpecial;
	OddsOfAppearing      = Other.OddsOfAppearing;

	// LightColor.
	LightBrightness      = Other.LightBrightness;
	LightHue             = Other.LightHue;
	LightSaturation      = Other.LightSaturation;

	// Lighting.
	LightType            = Other.LightType;
	LightEffect          = Other.LightEffect;
	LightRadius          = Other.LightRadius;
	LightPeriod          = Other.LightPeriod;
	LightPhase           = Other.LightPhase;
//LightCone            = Other.LightCone;        // Not replicated.
	VolumeBrightness     = Other.VolumeBrightness;
	VolumeRadius         = Other.VolumeRadius;
//VolumeFog            = Other.VolumeFog;        // Not replicated.
	bSpecialLit          = Other.bSpecialLit;
//bActorShadows        = Other.bActorShadows;    // Not replicated.
	bCorona              = Other.bCorona;          // Not replicated.
	bLensFlare           = Other.bLensFlare;       // Not replicated.

	// Movement.
//Location            = Other.Location; // Set by Spawn.
//Rotation            = Other.Rotation; // Set by Spawn.
//Velocity            = Other.Velocity; // Nah.
//SetPhysics( Other.Physics );          // Tricky-ish, hopefully irrelevant for Triggers.
	AttachTag           = Other.AttachTag;
	bBounce             = Other.bBounce;
	bFixedRotationDir   = Other.bFixedRotationDir;
	bRotateToDesired    = Other.bRotateToDesired;
	Mass                = Other.Mass;
	Buoyancy            = Other.Buoyancy;
	RotationRate        = Other.RotationRate;
	DesiredRotation     = Other.DesiredRotation;

	// Networking.
//RemoteRole           = Other.RemoteRole;         // I certainly
//NetPriority          = Other.NetPriority;        // won't use
//NetUpdateFrequency   = Other.NetUpdateFrequency; // these
//RelevantRadius       = Other.RelevantRadius;     // values. --han

	// Object.
	InitialState         = Other.InitialState; // Does this even work out of the box?
	Group                = Other.Group;

	// Smell.
	SmellClass           = Other.SmellClass;

	// Sound.
	SoundRadius          = Other.SoundRadius;
	SoundVolume          = Other.SoundVolume;
	SoundPitch           = Other.SoundPitch;
	AmbientSound         = Other.AmbientSound;
//TransientSoundVolume = Other.TransientSoundVolume; // Not replicated.
//TransientSoundRadius = Other.TransientSoundRadius; // Not replicated.

	// Make sure old Actor has Tag, Event, Group, BindName and BarkBindName removed.
	Other.Tag            = '';
	Other.Event          = '';
	Other.Group          = '';
	Other.BindName       = "";
	Other.BarkBindName   = "";

	// Keypoint class contains no properties.
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bSpawning=True
}
