//=============================================================================
// HXLamp.
//=============================================================================
class HXLamp extends HXFurniture
	abstract;

var() bool bOn;

// ----------------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------------

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		if ( bOn )
		{
			LightType = LT_Steady;
			bUnlit = True;
			ScaleGlow = 2.0;
		}
		else
		{
			LightType = LT_None;
			bUnlit = False;
			ResetScaleGlow();
		}
	}
}

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Lamp OtherLamp;

	// Call Super.
	Super.Succeeds( Other );

	// Special Lamp Init.
	OtherLamp = Lamp(Other);
	if ( OtherLamp!=None )
	{
		bOn = OtherLamp.bOn;
	}
}

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	Super.Frob( Frobber, FrobWith );

	if ( !bOn )
	{
		bOn = True;
		LightType = LT_Steady;
		PlaySound( Sound'Switch4ClickOn' );
		bUnlit = true;
		ScaleGlow = 2.0;
	}
	else
	{
		bOn = False;
		LightType = LT_None;
		PlaySound( Sound'Switch4ClickOff' );
		bUnlit = false;
		ResetScaleGlow();
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	FragType=GlassFragment
	bPushable=False
	LightBrightness=255
	LightSaturation=255
	LightRadius=10
	bFlammable=False
}
