//=============================================================================
// HXLifeSupportBase.
//=============================================================================
class HXLifeSupportBase extends HXDecoration;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local LifeSupportBase OtherLifeSupportBase;

	Log( "Succeeds", Self.Name );

	// Call Super.
	Super.Succeeds( Other );

	// Special LifeSupportBase Init.
	OtherLifeSupportBase = LifeSupportBase(Other);
	if ( OtherLifeSupportBase!=None )
	{
		// Fixup for script/per map localization set custom item names.
		if ( OtherLifeSupportBase.ItemName!=OtherLifeSupportBase.Class.default.ItemName )
			ItemName = OtherLifeSupportBase.ItemName;
	}
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	ItemName="Life Support"
	bInvincible=True
	bHighlight=False
	bClientHighlight=False
	bPushable=False
	bBlockSight=True
	Physics=PHYS_None
	Mesh=LifeSupportBase
	CollisionRadius=77.00
	//CollisionHeight=46.45
	CollisionHeight=45.70
	Mass=400.0
	Buoyancy=200.0
}
