//=============================================================================
// HXLightSwitch.
//
// Notes:
//  * Maybe make bOn configurable.
//  * Maybe send an AI event when frobbed.
//  * Maybe merged ION's network code out of Button1 here in case someone uses
//    this class on a mover.
//=============================================================================
class HXLightSwitch extends HXDecoration;

var bool bOn;

// ----------------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------------

function Frob( Actor Frobber, Inventory FrobWith )
{
	Super.Frob( Frobber, FrobWith );

	if ( bOn )
	{
		PlaySound( Sound'Switch4ClickOff' );
		PlayAnim( 'Off' );
	}
	else
	{
		PlaySound( Sound'Switch4ClickOn' );
		PlayAnim( 'On' );
	}

	bOn = !bOn;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	bInvincible=True
	ItemName="Switch"
	bPushable=False
	Physics=PHYS_None
	Mesh=LightSwitch
	CollisionRadius=3.75
	//CollisionHeight=6.25
	CollisionHeight=5.50
	Mass=30.0
	Buoyancy=40.0
}
