//=============================================================================
// HXLiquor40oz.
//=============================================================================
class HXLiquor40oz extends HXBeverage;

enum ESkinColor
{
	SC_Super45,
	SC_Bottle2,
	SC_Bottle3,
	SC_Bottle4
};

var() ESkinColor SkinColor;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local Liquor40oz OtherLiquor40oz;

	// Call Super.
	Super.Succeeds( Other );

	// Special Liquor40oz Init.
	OtherLiquor40oz = Liquor40oz(Other);
	if ( OtherLiquor40oz!=None )
	{
		// Liquor40oz.
		SetPropertyText( "SkinColor", OtherLiquor40oz.GetPropertyText("SkinColor") );
	}
}

// ----------------------------------------------------------------------------
// BeginPlay()
// ----------------------------------------------------------------------------

simulated function BeginPlay()
{
	Super.BeginPlay();

	if ( bDeleteMe )
		return;

	if ( Role==ROLE_Authority && !IsInRelevant() )
	{
		switch ( SkinColor )
		{
			case SC_Super45: Skin = Texture'Liquor40ozTex1'; break;
			case SC_Bottle2: Skin = Texture'Liquor40ozTex2'; break;
			case SC_Bottle3: Skin = Texture'Liquor40ozTex3'; break;
			case SC_Bottle4: Skin = Texture'Liquor40ozTex4'; break;
		}
	}
}

// ----------------------------------------------------------------------------
// SpawnCopy()
// ----------------------------------------------------------------------------

function Inventory SpawnCopy( Pawn Other )
{
	local HXLiquor40oz Copy;
	Copy = HXLiquor40oz(Super.SpawnCopy(Other));
	Copy.SkinColor = SkinColor;
	return Copy;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	HealAmount=2
	DrugAmount=10.0
	MsgTooMany="You can't carry any more malt liquor"
	bBreakable=True
	MaxCopies=10
	ItemName="Forty"
	ItemArticle="a"
	PlayerViewOffset=(X=30.0,Y=0.0,Z=-12.0)
	PlayerViewMesh=Liquor40oz
	PickupViewMesh=Liquor40oz
	Skin=Liquor40ozTex1
	ThirdPersonMesh=Liquor40oz
	LandSound=GlassHit1
	Icon=BeltIconBeerBottle
	LargeIcon=LargeIconBeerBottle
	LargeIconWidth=14
	LargeIconHeight=47
	Description="'COLD SWEAT forty ounce malt liquor. Never let 'em see your COLD SWEAT.'"
	BeltDescription="FORTY"
	Mesh=Liquor40oz
	CollisionRadius=3.00
	//CollisionHeight=9.14
	CollisionHeight=8.39
	Mass=10.0
	Buoyancy=8.0
}
