//=============================================================================
// HXLocalLink: Receives LAN beacons from servers.
//
// Copy of DeusExLocalLink to use own HXMenuScreenJoinGame class.
//=============================================================================
class HXLocalLink extends HXUdpLink
	transient;

// Misc
var HXMenuScreenJoinGame	OwnerWindow;

// Config
var string BeaconProduct;
var int    LocalUDPPort;

// ----------------------------------------------------------------------------
// Start()
// ----------------------------------------------------------------------------

function Start()
{
	local int BoundPort;

	Log( Name $ ": BeaconProduct is " $ BeaconProduct, 'DevGameSpy' );

	BoundPort = BindPort();
	if ( BoundPort==0 )
	{
		OwnerWindow.QueryFinished( False, Class.Name$": Could not bind to a free port.");
		Warn( "Failed to bind a port." );
		return;
	}
	Log( Name $ ": Port "$boundport$" successfully bound.", 'DevGameSpy' );

	BroadcastBeacon();
}

// ----------------------------------------------------------------------------
// Timer()
// ----------------------------------------------------------------------------

function Timer()
{
	OwnerWindow.QueryFinished( True );
}

// ----------------------------------------------------------------------------
// BroadcastBeacon()
// ----------------------------------------------------------------------------

function BroadcastBeacon()
{
	local IpAddr Addr;
	local int i;

	Addr.Addr = BroadcastAddr;

	for ( i=0; i<10; i++ )
	{
		Addr.Port = LocalUDPPort + i;
		SendText( Addr, "REPORTQUERY" );
	}
}

// ----------------------------------------------------------------------------
// ReceivedText()
// ----------------------------------------------------------------------------

event ReceivedText( IpAddr Addr, string Text )
{
	local int n;
	local int QueryPort;
	local string Address;

	n = Len( BeaconProduct );

	if ( Left(Text,n+1)~=(BeaconProduct$" ") )
	{
		QueryPort = int(Mid(Text,n+1));
		Address   = IpAddrToString( Addr );
		Address   = Left( Address, InStr(Address,":") );

		OwnerWindow.FoundServer( Address, QueryPort, "", BeaconProduct );
	}
}

// ----------------------------------------------------------------------------
// Destroyed()
// ----------------------------------------------------------------------------

event Destroyed()
{
   OwnerWindow = None;
   Super.Destroyed();
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	BeaconProduct="invalid"
}
