//=============================================================================
// HXLogicTrigger
//
// Allows boolean relationships between two different events.
//
// To trigger set the Event of whatever to match the Tag of this trigger.
// For fist input set the Group of whatever to match InGroup1 of this trigger.
// For second input set the Group of whatever to match InGroup2 of this trigger.
//=============================================================================
class HXLogicTrigger extends HXTrigger;

enum ELogicType
{
	GATE_AND,
	GATE_OR,
	GATE_XOR
};

var() ELogicType Op;

var() Name InGroup1;
var() Name InGroup2;

var() bool bNot;
var() bool bOneShot;

var bool bIn1;
var bool bIn2;
var bool bOut;
var bool bOutHit;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

function Succeeds( Actor Other )
{
	local LogicTrigger OtherDamageTrigger;

	// Call Super.
	Super.Succeeds( Other );

	// Special LogicTrigger Init.
	OtherDamageTrigger = LogicTrigger(Other);
	if ( OtherDamageTrigger!=None )
	{
		SetPropertyText( "Op", OtherDamageTrigger.GetPropertyText("Op") );

		InGroup1 = OtherDamageTrigger.InGroup1;
		InGroup2 = OtherDamageTrigger.InGroup2;
		bNot     = OtherDamageTrigger.Not;
		bOneShot = OtherDamageTrigger.OneShot;
	}
}

// ----------------------------------------------------------------------------
// Trigger()
// ----------------------------------------------------------------------------

function Trigger( Actor Other, Pawn Instigator )
{
	local Actor A;

	if ( Other.Group==InGroup1 )
		bIn1 = !bIn1;
	if ( Other.Group==InGroup2 )
		bIn2 = !bIn2;

	switch( Op )
	{
		case GATE_AND:
			bOut = bIn1 && bIn2;
			break;

		case GATE_OR:
			bOut = bIn1 || bIn2;
			break;

		case GATE_XOR:
			bOut = bIn1 ^^ bIn2;
			break;
	}

	// bOut = bNot ^^ bOut; ?
	if ( bNot )
		bOut = !bOut;

	// Trigger event on bOut==true
	if ( bOut && !bOutHit )
	{
		if ( bOneShot )
			bOutHit = true;

		if ( Event!='' )
			foreach AllActors( class'Actor', A, Event )
				A.Trigger( Self, Instigator );
	}

	Super.Trigger( Other, Instigator );
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	CollisionRadius=0.0
	bCollideActors=False
}
