//=============================================================================
// HXMIB.
//=============================================================================
class HXMIB extends HXHumanMilitary;

// ----------------------------------------------------------------------------
// Succeeds()
//
// Intended to be called by Mutator code if Self was spawned as a successor
// to Other. Super call recommended.
// ----------------------------------------------------------------------------

// Copying CollisionSize is suspended for now, making this quirk obsolete.
/*
function Succeeds( Actor Other )
{
	local MIB OtherMIB;

	// Call Super.
	Super.Succeeds( Other );

	// Special MIB Init.
	OtherMIB = MIB(Other);
	if ( OtherMIB!=None )
	{
		// Original CollisionHeight didn't match the other GM_Suit characters.
		if ( OtherMIB.CollisionHeight==(OtherMIB.default.CollisionHeight-4.5) && OtherMIB.CollisionRadius==OtherMIB.default.CollisionRadius ) 
		{
			SetCollisionSize( default.CollisionRadius, default.CollisionHeight );
		}
	}
}
*/

// ----------------------------------------------------------------------------
// SpawnCarcass()
//
// Blow up instead of spawning a carcass
// ----------------------------------------------------------------------------

function Carcass SpawnCarcass()
{
	if (bStunned)
		return Super.SpawnCarcass();

	Explode();

	return None;
}

function Explode()
{
	local SphereEffect sphere;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;
	local float explosionDamage;
	local float explosionRadius;

	explosionDamage = 100;
	explosionRadius = 256;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius*16);
	PlaySound(Sound'LargeExplosion1', SLOT_None,,, explosionRadius*16);

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, Location);
	if (light != None)
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionMedium',,, Location + 2*VRand()*CollisionRadius);
	Spawn(class'ExplosionLarge',,, Location + 2*VRand()*CollisionRadius);

	sphere = Spawn(class'SphereEffect',,, Location);
	if (sphere != None)
		sphere.size = explosionRadius / 32.0;

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks and flesh fragments
	for (i=0; i<explosionDamage/6; i++)
	{
		if (FRand() < 0.3)
			spawn(class'Rockchip',,,Location);
		else
			spawn(class'FleshFragment',,,Location);
	}

	HurtRadius(explosionDamage, explosionRadius, 'Exploded', explosionDamage*100, Location);
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

defaultproperties
{
	MinHealth=0.0
	CarcassType=MIBCarcass
	WalkingSpeed=0.213333
	CloseCombatMult=0.5
	GroundSpeed=180.0
	Health=350
	HealthHead=350
	HealthTorso=350
	HealthLegLeft=350
	HealthLegRight=350
	HealthArmLeft=350
	HealthArmRight=350
	Mesh=GM_Suit
	DrawScale=1.1
	MultiSkins(0)=MIBTex0
	MultiSkins(1)=PantsTex5
	MultiSkins(2)=MIBTex0
	MultiSkins(3)=MIBTex1
	MultiSkins(4)=MIBTex1
	MultiSkins(5)=FramesTex2
	MultiSkins(6)=LensesTex3
	MultiSkins(7)=PinkMaskTex
	CollisionRadius=22.00
	// Orignal too large and inconsistent GM_Suit CollisionHeight.
	////CollisionHeight=52.25
	//CollisionHeight=47.75
	// CollisionHeight matching other GM_Suit characters.
	//CollisionHeight=51.80
	CollisionHeight=47.30
	BindName="MIB"
	FamiliarName="Man In Black"
	UnfamiliarName="Man In Black"
	NameArticle="a "
}
